/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.swt.samples.eswtdemo;

import java.util.Vector;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;


/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 */

public class NormalView extends ViewPart {

	private Composite composite;
	private Demo demo;
	
	/**
	 * The constructor.
	 */
	public NormalView() {
	}
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		composite = parent;
		demo = new Demo();
		demo.workbenchMode(parent);
	}
		
	/**
	 * 
	 */
	public void setFocus() {
		if(demo != null) {
			demo.setFocus();
		}
	}
}