/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook;



import java.util.*;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;



public class PhoneBookDataBase {
	static private PhoneBookDataBase This = null;

	private Hashtable dataBase = null;
	
	private PhoneBookDataBase() {
		dataBase = new Hashtable();
		buildSample();
	}
	
	public static PhoneBookDataBase getThePhoneBook() {
		if (This == null) {
			This = new PhoneBookDataBase();
		}

		return This;
	}
	
	public boolean addEntry(PhoneBookEntry entry) {
		boolean isAdded = false;
		PhoneBookEntry removedObject = null;
		if ( (removedObject = (PhoneBookEntry) dataBase.remove(entry.getSurnameAndName())) == null) {
			dataBase.put(entry.getSurnameAndName(), entry);		
			isAdded = true;
		} else {
			dataBase.put(removedObject.getSurnameAndName(), removedObject);
		}
	    
	    return isAdded;
	}
	
	public Object removeEntry(PhoneBookEntry entry) {
		if (entry != null) {
	    	return dataBase.remove(entry.getSurnameAndName());
		}
		
		return null;
	}
	
	public PhoneBookEntry getEntryWithSurnameAndName(String SurnameAndName) {
	    return (PhoneBookEntry) dataBase.get(SurnameAndName);
	}
	
	// Return a Vector wich contains all Entries in alphabetical order.
	public Vector getEntriesVector() {
		Vector vectorEntries = new Vector();

		Enumeration entries = dataBase.elements();
		
		while (entries.hasMoreElements()) {
			PhoneBookEntry entry = (PhoneBookEntry)entries.nextElement();
			vectorEntries.add(entry);
		}
		
	    return vectorEntries;
	}

	// Return a Vector wich contains all SurnameName in alphabetical order.
	public Vector getSurnameNameVector() {
		Vector vectorEntries = new Vector();

		Enumeration entries = dataBase.elements();
		
		while (entries.hasMoreElements()) {
			PhoneBookEntry entry = (PhoneBookEntry)entries.nextElement();
			String stringToAdd = entry.getSurnameAndName();
			String string = ""; //$NON-NLS-1$
			int index = 0;
			boolean continueLoop = true;
			while ( (index < vectorEntries.size()) && continueLoop == true) {
				string = (String) vectorEntries.get(index);
				
				if ((string.compareTo(stringToAdd) < 0)) {
					index++;					
				} else {
					continueLoop = false;
				}
			}
			vectorEntries.add(index, entry.getSurnameAndName());
		}
		
	    return vectorEntries;
	}
	
	public void update() {

		Enumeration entries = dataBase.keys();
		
		while (entries.hasMoreElements()) {
			String key = (String)entries.nextElement();

			PhoneBookEntry entry = (PhoneBookEntry)dataBase.get(key);
			
			if(!entry.getSurnameAndName().equals(key) ) {
				dataBase.remove(key);
				dataBase.put(entry.getSurnameAndName(), entry);
			}
		}
	}
	
	/**
	 * Fill the database with entries
	 *
	 */
	public void buildSample() {
		dataBase.clear();
	    addEntry(new PhoneBookEntry("Blake",   "Robert",  "Madison Avenue", "Manager", "0", "", "01 58 87 68", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Hampton", "Mark",    "West 51st Street", "Marketing Dept", "0", "", "85 59 78 12", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Hogan",   "Lisa",    "131 Lawrence Street", "", "0", "01 87 54 31", "02 36 87 46", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Lawson",  "William", "205 Rivington Street", "", "0", "98 55 33 75", "78 35 94 54", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Smith",   "John",    "Imperial Hotel", "Cook", "0", "01 02 03 04", "", "jsmith@imperial.com")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Cleese",  "Lionel",  "East 20th Street", "", "0", "54 35 82 94", "52 13 98 65", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Davis",   "Janet",   "The Plaza Hotel", "", "0", "87 25 91 67", "", "")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	    addEntry(new PhoneBookEntry("Jameson", "Jane",    "East 55th Street", "", "0", "06 05 04 03", "", "jane@myemail.com")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	}
}
