/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/

package org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;


public class PhoneBookEntry implements Comparable {
	private String	surname;
	private String	name;
	private String	organization;
	private String	experience;
	private String	position;
	private String	phone;
	private String	mobilePhone;
	private String	email;
	
	public PhoneBookEntry(String surname, String name, String organization,
	                      String position, String experience, String phone, String mobilePhone,
	                      String email) {
		this.surname      = surname;
		this.name         = name;
		this.organization = organization;
		this.position	  = position;
		this.experience	  = experience;
		this.phone        = phone;
		this.mobilePhone  = mobilePhone;
		this.email        = email;
	}
	
	public String get0rganization() {
		return organization;
	}
	
	public void set0rganization(String organization) {
		this.organization = organization;
	}
	
	public String getSurnameAndName() {
	    if (surname != "" && name != "") { //$NON-NLS-1$ //$NON-NLS-2$
	        return surname + ", " + name; //$NON-NLS-1$
	    } else if (surname == "" && name != "") { //$NON-NLS-1$ //$NON-NLS-2$
	        return name;	        
	    } else if (surname != "" && name == "") { //$NON-NLS-1$ //$NON-NLS-2$
	        return surname;
	    } else {
	        return Messages.getString("PhoneBookEntry.7"); //$NON-NLS-1$
	    }
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getSurName() {
		return surname;
	}
	
	public void setSurName(String surName) {
		this.surname = surName;
	}
	
	public String getPosition() {
		return position;
	}
	
	public void setPosition(String position) {
		this.position = position;
	}
	
	public String getExperience() {
		return experience;
	}
	
	public void setExperience(String experience) {
		this.experience = experience;
	}
	
	public String getPhone() {
		return phone;
	}
	
	public void setPhone(String phone) {
		this.phone = phone;
	}
	
	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}
	
	public String getMobilePhone() {
		return mobilePhone;
	}
	
	public void setEmail(String email) {
		this.email = email;
	}
	
	public String getEmail() {
		return email;
	}
	
	public int compareTo(Object o) {
		PhoneBookEntry entry = (PhoneBookEntry)o;
		int res = surname.compareTo(entry.surname);
		if (res == 0)
			res = name.compareTo(entry.name);
		return res;
	}
	
	public String toString() {
	   return getSurnameAndName();
	}
	
}
