/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook;


import java.util.Vector;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.ScrolledComposite;




public class PhoneBookShowCase extends ShowCase implements SelectionListener, 
  KeyListener, TraverseListener, ModifyListener, ControlListener {
	// The key are the value in the listName, and the value is the  
	private PhoneBookDataBase				phoneBookDataBase;
	
	// The name list of the directory.
	private Shell							shellDirectory;
	private SortedList	listNameWidget;
	private boolean							landscape;
	private boolean                         detailsOpened;
	private Image background;
	
	// the contents of one name on the directory.
	private Shell  shellDetails;
//	Label          detailOrganization;
//	Label          detailPosition;
	Text          detailOrganization;
	Text          detailPosition;
	HyperLink detailPhone;
	HyperLink detailMobile;
	HyperLink detailEmail;
	
	private ScrolledComposite entryScrollScreen;
	private Composite entryScreen;
	Text entryLastName;
	Text entryFirstName;
	Text entryCompany;
	Text entryJob;
	ConstrainedText entryTelephone;
	ConstrainedText entryMobile;
	TextExtension entryEMail;
	
	Command commandExitDirectory;
	Command commandExitDetails;
	Command commandEdit;
	Command commandNew;
	Command commandDelete;
	Command commandEntryScreenDone;
	Command commandBackDetails;
	
	Screen[] screens;
	RotationListener rotationListener;
	
	public class RotationListener implements ScreenListener {
		public void screenActivated(ScreenEvent event) {}
		public void screenDeactivated(ScreenEvent event) {}
		public void screenOrientationChanged(ScreenEvent event) {
			landscape = (event.orientation == Screen.LANDSCAPE);
			setOrientation();
			positionDirectory();
			positionDetails();
		}
	}	
	
	public PhoneBookShowCase() {
	}
	
	public String getName() {
		return Messages.getString("PhoneBookShowCase.0"); //$NON-NLS-1$
	}
	
	private void positionDirectory() {
		Rectangle bgdBnds = getComposite().getShell().getBounds();
		if (landscape) {
			int x = bgdBnds.x + 5;
			int y = bgdBnds.y + 5;
			int w = bgdBnds.width/2 - 10;
			int h = bgdBnds.height - 10;
			shellDirectory.setBounds(x, y, w, h);
		} else {
			shellDirectory.setBounds(bgdBnds.x+1, bgdBnds.y+1, bgdBnds.width-1, bgdBnds.height-1);
		}
	}
	
	private void positionDetails() {
		Rectangle bgdBnds = getComposite().getShell().getBounds();
		if (landscape) {
			int x = bgdBnds.x + bgdBnds.width/2 + 5;
			int y = bgdBnds.y + 5;
			int w = bgdBnds.width/2 - 10;
			int h = bgdBnds.height - 10;
			shellDetails.setBounds(x, y, w, h);
		} else {
			shellDetails.setBounds(bgdBnds.x+1, bgdBnds.y+1, bgdBnds.width-1, bgdBnds.height-1);
		}
	}
	
	public void controlResized(ControlEvent e) {
		positionDirectory();
		positionDetails();
	}
	
	public void controlMoved(ControlEvent e) {
 		positionDirectory();
		positionDetails();
	}
	
	public void show() {
		phoneBookDataBase = PhoneBookDataBase.getThePhoneBook();
		
		Rectangle bgdBnds = getComposite().getShell().getBounds();
		landscape = (bgdBnds.width > 240) && (bgdBnds.width > bgdBnds.height); 
		
		// Directory
		shellDirectory = new Shell(getComposite().getShell(), SWT.BORDER | SWT.TITLE | SWT.MODELESS);
		shellDirectory.setText(Messages.getString("PhoneBookShowCase.2")); //$NON-NLS-1$
		positionDirectory();
		shellDirectory.setLayout(new FillLayout());
		//shellDirectory.addControlListener(this);
		getComposite().getShell().addControlListener(this);
				
		listNameWidget = new SortedList(shellDirectory, SWT.SINGLE | SWT.V_SCROLL, SortedList.FILTER);
		listNameWidget.addSelectionListener(this);
		listNameWidget.addKeyListener(this);
		listNameWidget.addTraverseListener(this);
		Vector nameSurname = phoneBookDataBase.getSurnameNameVector();
		
		for (int i = 0; i < nameSurname.size(); i++) {
			listNameWidget.add((String) nameSurname.get(i));
		}

		// Details
		shellDetails = new Shell(getComposite().getShell(), SWT.BORDER|SWT.TITLE|SWT.MODELESS);
		detailsOpened = false;
		shellDetails.setText(Messages.getString("PhoneBookShowCase.3")); //$NON-NLS-1$
		
		RowLayout rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		shellDetails.setLayout(rowLayout);
		//shellDetails.addControlListener(this);

		
		CaptionedControl detailCapc1 = new CaptionedControl(shellDetails, SWT.NONE /*SWT.LEFT_TO_RIGHT*/);
//		detailOrganization = new Label(detailCapc1, SWT.NONE);
		detailOrganization = new Text(detailCapc1,SWT.READ_ONLY);
		detailCapc1.setText(Messages.getString("PhoneBookShowCase.4")); //$NON-NLS-1$
//		detailCapc1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		CaptionedControl detailCapc2 = new CaptionedControl(shellDetails, SWT.LEFT_TO_RIGHT);
//		detailPosition = new Label(detailCapc2, SWT.NONE);
		detailPosition = new Text(detailCapc2, SWT.READ_ONLY);
		detailCapc2.setText(Messages.getString("PhoneBookShowCase.5")); //$NON-NLS-1$
//		detailCapc2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		CaptionedControl detailCapc3 = new CaptionedControl(shellDetails, SWT.LEFT_TO_RIGHT);
		detailPhone = new HyperLink(detailCapc3, SWT.NONE, HyperLink.PHONE);
		detailCapc3.setText(Messages.getString("PhoneBookShowCase.6")); //$NON-NLS-1$
		detailPhone.addKeyListener(this);
//		detailCapc3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		CaptionedControl detailCapc4 = new CaptionedControl(shellDetails, SWT.LEFT_TO_RIGHT);
		detailMobile = new HyperLink(detailCapc4, SWT.NONE, HyperLink.PHONE);
		detailCapc4.setText(Messages.getString("PhoneBookShowCase.7")); //$NON-NLS-1$
		detailMobile.addKeyListener(this);
//		detailCapc4.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		CaptionedControl detailCapc5 = new CaptionedControl(shellDetails, SWT.LEFT_TO_RIGHT);
		detailEmail = new HyperLink(detailCapc5, SWT.NONE, HyperLink.EMAIL);
		detailCapc5.setText(Messages.getString("PhoneBookShowCase.8")); //$NON-NLS-1$
		detailEmail.addKeyListener(this);
//		detailCapc5.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		// entryScreen
		Composite parentComposite = getComposite();	       
		entryScrollScreen = new ScrolledComposite(parentComposite, SWT.NONE | SWT.V_SCROLL);
		entryScrollScreen.setLayout(new FormLayout());
		entryScrollScreen.setBounds(parentComposite.getClientArea());

		entryScreen = new Composite(entryScrollScreen, SWT.NONE);
		Rectangle clientArea = entryScrollScreen.getClientArea();
		entryScreen.setSize(clientArea.width, clientArea.height);

		Vector captionList = new Vector();
		CaptionedControl entryCapc1 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT | SWT.BORDER);
		entryCapc1.setText(Messages.getString("PhoneBookShowCase.9")); //$NON-NLS-1$
		entryLastName = new Text(entryCapc1, SWT.BORDER);
		entryLastName.addModifyListener(this);
		captionList.add(entryCapc1);
		
		CaptionedControl entryCapc2 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc2.setText(Messages.getString("PhoneBookShowCase.10")); //$NON-NLS-1$
		entryFirstName = new Text(entryCapc2, SWT.BORDER);
		entryFirstName.addModifyListener(this);
		captionList.add(entryCapc2);
		
		CaptionedControl entryCapc3 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc3.setText(Messages.getString("PhoneBookShowCase.11")); //$NON-NLS-1$
		entryCompany = new Text(entryCapc3, SWT.BORDER);
		captionList.add(entryCapc3);

		CaptionedControl entryCapc4 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc4.setText(Messages.getString("PhoneBookShowCase.12")); //$NON-NLS-1$
		entryJob = new Text(entryCapc4, SWT.BORDER);
		captionList.add(entryCapc4);

		CaptionedControl entryCapc5 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc5.setText(Messages.getString("PhoneBookShowCase.13")); //$NON-NLS-1$
		entryTelephone = new ConstrainedText(entryCapc5, SWT.BORDER, ConstrainedText.PHONENUMBER);
		captionList.add(entryCapc5);

		CaptionedControl entryCapc6 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc6.setText(Messages.getString("PhoneBookShowCase.14")); //$NON-NLS-1$
		entryMobile = new ConstrainedText(entryCapc6, SWT.BORDER, ConstrainedText.PHONENUMBER);
		captionList.add(entryCapc6);

		CaptionedControl entryCapc7 = new CaptionedControl(entryScreen, SWT.LEFT_TO_RIGHT);
		entryCapc7.setText(Messages.getString("PhoneBookShowCase.15")); //$NON-NLS-1$
		entryEMail = new TextExtension(entryCapc7, SWT.BORDER, TextExtension.EMAILADDRESS);
		captionList.add(entryCapc7);

		Point entryCapSize = entryCapc1.computeSize(entryScreen.getClientArea().width, SWT.DEFAULT);
		Point entryCapPos = new Point(0, 0);
		int margin = 2;
/*		int nbCaptions = captionList.size();
		
		// Size of the entries
		if ((entryCapSize.y + margin) * nbCaptions < clientArea.height) {
			FillLayout fillLayoutEntry = new FillLayout(SWT.VERTICAL);
			fillLayoutEntry.marginHeight = margin;
			entryScreen.setLayout(fillLayoutEntry);
			entryScreen.layout();
		} else
*/		
	 	{
			for (int i=0; i<captionList.size(); ++i) {
				CaptionedControl caption = (CaptionedControl) captionList.elementAt(i); 
				caption.setBounds(entryCapPos.x, entryCapPos.y, entryCapSize.x, entryCapSize.y);
				entryCapPos.y +=  entryCapSize.y + margin;
			}
			entryScreen.setSize(clientArea.width, entryCapPos.y);
		}	
		
		entryScrollScreen.setContent(entryScreen);
		entryScrollScreen.setAutoScroll(true);
		entryScrollScreen.setVisible(false);

		
		// create Commands
		commandNew = new Command(shellDirectory, Command.GENERAL, 3);
		commandNew.setText(Messages.getString("PhoneBookShowCase.16")); //$NON-NLS-1$
		commandNew.addSelectionListener(this);
		
		commandDelete = new Command(shellDirectory, Command.GENERAL, 2);
		commandDelete.setText(Messages.getString("PhoneBookShowCase.17"));	 //$NON-NLS-1$
		commandDelete.addSelectionListener(this);

		commandExitDirectory = new Command(shellDirectory, Command.EXIT, 1);
		commandExitDirectory.setText(Messages.getString("PhoneBookShowCase.18")); //$NON-NLS-1$
		commandExitDirectory.setLongLabel(Messages.getString("PhoneBookShowCase.19")); //$NON-NLS-1$
		commandExitDirectory.addSelectionListener(this);

		commandEdit = new Command(shellDirectory, Command.SELECT, 4);
		commandEdit.setText(Messages.getString("PhoneBookShowCase.20")); //$NON-NLS-1$
		commandEdit.addSelectionListener(this);
//		commandEdit.setDefaultCommand();
		
		commandEntryScreenDone = new Command(entryScreen, Command.EXIT, 0);
		commandEntryScreenDone.setText(Messages.getString("PhoneBookShowCase.21")); //$NON-NLS-1$
		commandEntryScreenDone.addSelectionListener(this);
		
		addKeyListenerToAllChildren(shellDirectory, this);
		addKeyListenerToAllChildren(shellDetails, this);
//		addTraverseListenerToAllChildren(shellDetails, this);

		setOrientation();
		
		shellDirectory.layout();
		shellDirectory.open();

		updateSelectedDetail();
		
		MobileDevice md = MobileDevice.getMobileDevice();
		screens = md.getScreens();
		rotationListener = new RotationListener();
		screens[0].addEventListener(rotationListener); 
	}

	void setOrientation() {
		if (landscape) {
		    if (!detailsOpened) {
		    	detailsOpened = true;
				positionDetails();
				shellDetails.open();
		    }	
		
		    shellDetails.setVisible(true);
		    
		    commandExitDetails = new Command(shellDetails, Command.EXIT, 0);
			commandExitDetails.setText(Messages.getString("PhoneBookShowCase.22")); //$NON-NLS-1$
			commandExitDetails.setLongLabel(Messages.getString("PhoneBookShowCase.23")); //$NON-NLS-1$
			commandExitDetails.addSelectionListener(this);
			
			if (commandBackDetails != null) {
				commandBackDetails.dispose();
				commandBackDetails = null;
			}
		} else {
		    commandBackDetails = new Command(shellDetails, Command.EXIT, 0);
			commandBackDetails.setText(Messages.getString("PhoneBookShowCase.24")); //$NON-NLS-1$
			commandBackDetails.addSelectionListener(this);
			
			if (commandExitDetails != null) {
				commandExitDetails.dispose();
				commandExitDetails = null;
			}
		}
	}
	
	// return true if the element is added, false if not (i.e. if this entry already exists)
	boolean addEntry(PhoneBookEntry entry) {
		boolean isAdded = false;
		if (phoneBookDataBase.getEntryWithSurnameAndName(entry.getSurnameAndName()) == null) {
			phoneBookDataBase.addEntry(entry);
			listNameWidget.add(entry.getSurnameAndName());
			isAdded = true;
		} 
	    
	    return isAdded;
	}
	
	void removeEntry(String key) {		
		PhoneBookEntry phoneBookEntry = phoneBookDataBase.getEntryWithSurnameAndName(key);

		phoneBookDataBase.removeEntry(phoneBookEntry);

		listNameWidget.remove(key);
	}
	
	void showEntryScreen() {
	    if (listNameWidget.getSelectionCount() == 0) return;
	    // we fill the entry screen
	    String selection = listNameWidget.getSelection()[0];
	    PhoneBookEntry entry = phoneBookDataBase.getEntryWithSurnameAndName(selection);
	    getComposite().getShell().setText(selection);
		entryLastName.setText(entry.getSurName());
		entryFirstName.setText(entry.getName());
		entryCompany.setText(entry.get0rganization());
		entryJob.setText(entry.getPosition());
		entryTelephone.setText(entry.getPhone());
		entryMobile.setText(entry.getMobilePhone());
		entryEMail.setText(entry.getEmail());
	    
	    shellDetails.setVisible(false);
	    shellDirectory.setVisible(false);
	    entryScrollScreen.setVisible(true);
	    entryScreen.setVisible(true);
	    //fix bug 237, the command of edit and new screen is invisible problem.
	    if(!entryLastName.isFocusControl())
	     entryLastName.setFocus();
	    else
	     entryFirstName.setFocus();	
	    	
 	}
	
	void hideEntryScreen() {
	    // validate the changes
	    String selection = listNameWidget.getSelection()[0];
	    PhoneBookEntry entry = phoneBookDataBase.getEntryWithSurnameAndName(selection);
	    listNameWidget.remove(entry.getSurnameAndName());
		entry.setSurName(entryLastName.getText());
		entry.setName(entryFirstName.getText());
		entry.set0rganization(entryCompany.getText());
		entry.setPosition(entryJob.getText());
		entry.setPhone(entryTelephone.getText());
		entry.setMobilePhone(entryMobile.getText());
		entry.setEmail(entryEMail.getText());
		phoneBookDataBase.update();
		listNameWidget.add(entry.getSurnameAndName());
		listNameWidget.select(entry.getSurnameAndName());
		updateSelectedDetail();
		
		getComposite().getShell().setText(getName());
		entryScrollScreen.setVisible(false);
		entryScreen.setVisible(false);
	    shellDetails.setVisible(landscape);
	    shellDirectory.setVisible(true);
	    shellDirectory.forceActive();
		listNameWidget.showSelection();
	    listNameWidget.forceFocus();
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
	    if (e.widget == listNameWidget) {
			updateSelectedDetail();
			setFocusOnDetails(true);
	    }
	}
	
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == commandExitDirectory || e.widget == commandExitDetails) {
			quit();
		} else if (e.widget==commandEdit) {
			showEntryScreen();
		} else if (e.widget==commandDelete) {
		    if (listNameWidget.getSelectionCount()>0) {
		        MessageBox box = new MessageBox(getComposite().getShell(), SWT.ICON_QUESTION | SWT.OK | SWT.CANCEL);
				box.setMessage(Messages.getString("PhoneBookShowCase.25")); //$NON-NLS-1$
		        if (box.open() == SWT.OK) {
		            removeEntry(listNameWidget.getSelection()[0]);
		    		updateSelectedDetail();
		        }
		        listNameWidget.setFocus();
		    }
		} else if (e.widget==commandNew) {
		    PhoneBookEntry newentry = new PhoneBookEntry("", "","", "", "0", "", "", ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		    if (addEntry(newentry)) {
		        listNameWidget.select(Messages.getString("PhoneBookShowCase.34")); //$NON-NLS-1$
		        listNameWidget.showSelection();
		        showEntryScreen();
		    }
		} else if (e.widget == listNameWidget) {
			updateSelectedDetail();	
		} else if (e.widget == commandEntryScreenDone) {
		    hideEntryScreen();
		} else if (e.widget == commandBackDetails) {
		    setFocusOnDetails(false);
		}
	}
	
	public void quit() {
		screens[0].removeEventListener(rotationListener);
	
		getComposite().getShell().removeControlListener(this);
		
		if (background != null) {
			background.dispose();
			background = null;
		}	
		
		commandExitDirectory.dispose();
		if (commandExitDetails != null) {
		    commandExitDetails.dispose();
		}
		if (commandBackDetails != null) {
		    commandBackDetails.dispose();
		}
		commandEdit.dispose();
		commandNew.dispose();
		commandDelete.dispose();
		
		shellDetails.dispose();
		shellDirectory.dispose();
		entryScreen.dispose();
		entryScrollScreen.dispose();
		
		dispose();
	}
	
	public void setFocusOnDetails(boolean isVisible) {
	    if (landscape) {
	        if (isVisible == true) {
	            shellDetails.setFocus();
	        } else {
	            shellDirectory.setFocus();
	        }
	    } else {
	        if (isVisible == true) {
	            if (detailsOpened == false) {
	                detailsOpened = true;
	                positionDetails();
	                shellDetails.open();
	            }
	            shellDetails.setVisible(true);
	            shellDirectory.setVisible(false);
	            shellDetails.setFocus();
	        } else {
	        	shellDirectory.setVisible(true);
	            shellDetails.setVisible(false);
	            shellDirectory.setActive();
	        }
	    }
	}
	
	private void updateSelectedDetail() {
	    if (listNameWidget.getSelectionCount() == 0) {
	        return;
	    }
		PhoneBookEntry entry = (PhoneBookEntry)phoneBookDataBase.getEntryWithSurnameAndName(listNameWidget.getSelection()[0]);

		if (entry != null) {
			updateDetail(entry);
		}
	}
	
	private void updateDetail(PhoneBookEntry entry) {
		shellDetails.setText(entry.getSurnameAndName());
		
		if ( entry.get0rganization() != "") { //$NON-NLS-1$
			detailOrganization.setVisible(true);	
			detailOrganization.setText(entry.get0rganization());			
		} else {
//			detailOrganization.setVisible(false);			
		}
		
		if ( entry.getPosition() != "") { //$NON-NLS-1$
			detailPosition.setVisible(true);	
			detailPosition.setText(entry.getPosition());			
		} else {
//			detailPosition.setVisible(false);			
		}
		
		if (entry.getPhone() != "" ){ //$NON-NLS-1$
			detailPhone.setVisible(true);	
			detailPhone.setText(entry.getPhone());
		} else {
//			detailPhone.setVisible(false);
		}
		
		if (entry.getMobilePhone() != "" ){ //$NON-NLS-1$
			detailMobile.setVisible(true);	
			detailMobile.setText(entry.getMobilePhone());
		} else {
//			detailMobile.setVisible(false);
		}
		
		if (entry.getEmail() != "") { //$NON-NLS-1$
			detailEmail.setVisible(true);	
			detailEmail.setText(entry.getEmail());			
		} else {
//			detailEmail.setVisible(false);			
		}
		shellDetails.layout();
	}


    public void keyPressed(KeyEvent e) {
        if (e.keyCode == SWT.ARROW_RIGHT) {
        	setFocusOnDetails(true);
        } 
        else if (e.keyCode == SWT.ARROW_LEFT) {
        	setFocusOnDetails(false);
         }
    }

    public void keyReleased(KeyEvent arg0) {
        
    }
    
    private void addKeyListenerToAllChildren(Composite parent, KeyListener listener) {
    	if (parent != null) {
	    	Control[] childrens  = parent.getChildren();
	    	
	    	for (int i =0; i < childrens.length ; i++) {
	    		if (Composite.class.isAssignableFrom(childrens[i].getClass())) {
	    			addKeyListenerToAllChildren( (Composite)childrens[i], this);
	    		} else {
		    		childrens[i].addKeyListener(listener);	
	    		}
	    	}
    	}
    }
    
    private void addTraverseListenerToAllChildren(Composite parent, TraverseListener listener) {
    	if (parent != null) {
	    	Control[] childrens  = parent.getChildren();
	    	
	    	for (int i =0; i < childrens.length ; i++) {
	    		if (Composite.class.isAssignableFrom(childrens[i].getClass())) {
	    			addTraverseListenerToAllChildren( (Composite)childrens[i], this);
	    		} else {
		    		childrens[i].addTraverseListener(listener);	
	    		}
	    	}
    	}
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.character == SWT.ESC && ((Control)(e.widget)).getShell() == shellDetails ) {
            e.doit = false;
        } else if (e.doit && e.widget == shellDetails) {
            setFocusOnDetails(true);
        } else if (e.doit && e.widget == listNameWidget) {
        	updateSelectedDetail();
			setFocusOnDetails(true);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == entryFirstName || e.widget == entryLastName) {
            if (entryLastName.getText() != "" && entryFirstName.getText() != "") { //$NON-NLS-1$ //$NON-NLS-2$
                getComposite().getShell().setText(entryLastName.getText() + ", " + entryFirstName.getText()); //$NON-NLS-1$
            }
            else if (entryLastName.getText() == "" && entryFirstName.getText() != "") { //$NON-NLS-1$ //$NON-NLS-2$
                getComposite().getShell().setText(entryFirstName.getText());
            }
            else if (entryLastName.getText() != "" && entryFirstName.getText() == "") { //$NON-NLS-1$ //$NON-NLS-2$
                getComposite().getShell().setText(entryLastName.getText());
            }
            else if (entryLastName.getText() == "" && entryFirstName.getText() == "") { //$NON-NLS-1$ //$NON-NLS-2$
                getComposite().getShell().setText(Messages.getString("PhoneBookShowCase.49")); //$NON-NLS-1$
            }
        }
    }
}
