/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo;

import org.eclipse.swt.widgets.Composite;


/**
 * ShowCase interface
 *
 */
public abstract class ShowCase {
    private Composite background;
    
    /**
     * Launch the ShowCase
     */
    protected void show(Composite background) {
        this.background = background;
        show();
    }
    
    protected void dispose() {
        background.dispose();
    }
    
    public Composite getComposite() {
        return background;
    }
    
    /**
     * returns the name of the ShowCase
     * @return the name of the ShowCase
     */
    public abstract String getName();

    /**
     * Launch the ShowCase
     */
	protected abstract void show();
	
	protected void setFocus() {};
}
