/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Table;

import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.Vector;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;



/**
 * TODO : We use a workaround to find a place (shell) to create the table.
 * Maybe it is better to use the composite from getComposite().
 * Font are hard coded : no 
 */
public class TableShowCase extends ShowCase implements SelectionListener {

    final static int COLUMN_NUMBER = 3;
    final static int ROWS_IN_COLUMN = 7;
    
    Display display;
    Shell shell;
    Command commandExit;
    Command commandGrid;
    Table table;
    Vector tableColumns;
    Vector tableItems;
    Vector images;
    Canvas canvas;
    Font fontArial;
    Font fontCourrier;
    Vector colors;

    
    public TableShowCase(){
        
    }
    
    
    public String getName() {
        return Messages.getString("TableShowCase.0"); //$NON-NLS-1$
    }
    
    
    protected void show() {
        
        //shell = getComposite().getShell(); ??
        
        
        shell = new Shell(getComposite().getShell(),SWT.MAX | SWT.TITLE);
        shell.setBounds(getComposite().getShell().getBounds());
        shell.setText(Messages.getString("TableShowCase.1")); //$NON-NLS-1$
        display = getComposite().getShell().getDisplay();
        
        tableItems = new Vector();
        tableColumns = new Vector();
        images = new Vector();
        colors = new Vector();
        boolean useHeader = true;
        
        final int column_width = shell.getClientArea().width/3;
        
        //  - Commands
        
        commandExit = new Command(shell, Command.EXIT, 0);
        commandExit.setText(Messages.getString("TableShowCase.2")); //$NON-NLS-1$
        commandExit.setLongLabel(Messages.getString("TableShowCase.3")); //$NON-NLS-1$
        commandExit.addSelectionListener(this);

        commandGrid = new Command(shell, Command.GENERAL, 1);
        commandGrid.setText(Messages.getString("TableShowCase.4")); //$NON-NLS-1$
        commandGrid.addSelectionListener(this);
        
        // - table and table items
        table = new Table(shell, SWT.BORDER|SWT.MULTI|SWT.CHECK|SWT.H_SCROLL|SWT.V_SCROLL|SWT.HIDE_SELECTION);
        table.setVisible(false);
        table.setBounds(getComposite().getBounds());
        table.setLocation(0,0);
        //table = new Table(shell, SWT.NONE);
        
        // Creating the columns
        TableColumn tableColumn;
        String string;
        for (int count = 0; count < COLUMN_NUMBER; count++) {
            tableColumn = new TableColumn(table, SWT.NONE);
            tableColumn.setWidth(column_width);
            string = Messages.getString("TableShowCase.5") + count; //$NON-NLS-1$
            if (useHeader)
                tableColumn.setText(string);
            tableColumns.add(tableColumn);
        }
        
        // Settings item's text
        TableItem tableItem;
        String[] texts;
        int rowIndex;
        for ( rowIndex = 0; rowIndex < ROWS_IN_COLUMN; rowIndex++) {
            tableItem = new TableItem(table, SWT.NONE);
            for (int index = 0; index < tableColumns.size(); index++) {
                string = Messages.getString("TableShowCase.6") + rowIndex + "_" + index; //$NON-NLS-1$ //$NON-NLS-2$
                tableItem.setText(index, string);               
            }
            tableItems.add(tableItem);
        }   
        
        
        // Preparing images for items
        final String [] imagesPath = {
                "/res/lb2heading.png", //$NON-NLS-1$
                "/res/point.png", //$NON-NLS-1$
                "/res/flower.png", //$NON-NLS-1$
                "/res/lb3heading.png", //$NON-NLS-1$
                "/res/lb3details.png"}; //$NON-NLS-1$
        
        
        Image image;
        final int[] indexes = { 1,0,1,1,0};
        final int[] tableItemIndex = {0,0,0,2,2};
        
        for( int count =0; count < imagesPath.length; count++ ) {
            image = new Image(display, getClass().getResourceAsStream(imagesPath[count]));   
            tableItem = (TableItem)(tableItems.elementAt(tableItemIndex[count]));
            tableItem.setImage(indexes[count], image);
            images.add(image);   
        }
        
        // Sets an array of images
        int nbImages = images.size();
        Image[] imageArray = new Image[nbImages];
        for (int count = 0; count < nbImages; count++) {
            imageArray[count] = (Image)images.elementAt(count);
        }
        tableItem = (TableItem) tableItems.elementAt(1);
        tableItem.setImage(imageArray);    


        
        // Colors
        Color background, foreground;
        int red, green, blue;
        for (rowIndex=0; rowIndex<tableItems.size(); rowIndex++) {
            tableItem = (TableItem)tableItems.elementAt(rowIndex);
            for (int row = 0; row < tableColumns.size(); row++) {
                red   = (int)(Math.random() * 128);
                green = (int)(Math.random() * 128);
                blue  = (int)(Math.random() * 128);
                background = new Color(display, red, green, blue);
                tableItem.setBackground(row, background);
                colors.add(background);
                
                red   = ((int)(Math.random() * 128)) + 128;
                green = ((int)(Math.random() * 128)) + 128;
                blue  = ((int)(Math.random() * 128)) + 128;
                foreground = new Color(display, red, green, blue);
                tableItem.setForeground(row, foreground);
                colors.add(foreground);
            }
        }
        


        // Fonts TODO : hardcoded
        FontData fontDataArial = new FontData("arial", 7, SWT.BOLD); //$NON-NLS-1$
        FontData fontDataCourrier = new FontData("courrier", 15, SWT.ITALIC); //$NON-NLS-1$
        
        fontArial = new Font(display, fontDataArial);
        fontCourrier = new Font(display, fontDataCourrier);
        

        for (rowIndex=0; rowIndex<tableItems.size(); rowIndex++) {
            tableItem = (TableItem)tableItems.elementAt(rowIndex);
            for (int colum = 0; colum <tableColumns.size(); colum++) {
                switch (colum) {
                case 0:
                    tableItem.setFont(colum, fontArial);
                    break;
                case 1:
                    tableItem.setFont(colum, fontCourrier);
                    break;
                case 2:
                    tableItem.setFont(colum, null);
                    break;
                }
            }
        }

   
        // setting alignement style for colums

        for (int columIndex=0; columIndex<tableColumns.size(); columIndex++) {
            tableColumn = (TableColumn)(tableColumns.elementAt(columIndex));
            
            switch (columIndex) {
                case 0:
                    tableColumn.setAlignment(SWT.LEFT);
                    break;
                case 1:
                    tableColumn.setAlignment(SWT.CENTER);
                    break;
                case 2:
                    tableColumn.setAlignment(SWT.RIGHT);
                    break;
            }

        }

        
        //shell.setLayout(new FillLayout(SWT.HORIZONTAL));
        //shell.layout();
        shell.open();
        table.setHeaderVisible(true);
        table.setVisible(true);
        table.setFocus();
        
        //TODO :  Using a readAnDispatch loop to manage the key events ?
        
 

        return ;
    }
    
    
    private void quit() {
        
        table.dispose();
        
        fontArial.dispose();
        fontCourrier.dispose();
        Color color;
        for (int i=0 ; i<colors.size(); i++) {
            color = (Color)colors.elementAt(i);
            color.dispose();
        }
        for (int i=0; i<images.size(); i++) {
            Image image = (Image)(images.elementAt(i));
            image.dispose();            
        }
        commandExit.dispose();
        commandGrid.dispose();
        shell.dispose();
        dispose();

    }
 
  
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == commandExit) {
            quit();
            
        } else if (e.widget == commandGrid) {
            table.setLinesVisible(!table.getLinesVisible());
        }
        
    }

 
    public void widgetDefaultSelected(SelectionEvent arg0) {
        // TODO Auto-generated method stub

    }

}
