/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nokia - eSWT Demo application
 *******************************************************************************/

package org.eclipse.ercp.swt.samples.eswtdemo.Tree;

import java.io.InputStream;
import java.util.Vector;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.swt.graphics.*;




/**
 * 
 */
public class TreeShowCase extends ShowCase implements KeyListener, SelectionListener {
     
 
    static final int ROOT = 0;
    static final int NODE = 1;
    static final int LEAVE = 2;
    static final int TREE = 3;
    
    
    static final String [] itemText = { Messages.getString("TreeShowCase.0"), Messages.getString("TreeShowCase.1"), Messages.getString("TreeShowCase.2")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
            
    
    /**
     * Represents for each TreeItem the kind of the item. ItemTrees are sorted in the order they
     * are displayed at screen when each node is developped. The first cell is reserved for "tree" 
     * itself
     */
    private Vector itemType;
    
    /**
     * Represents for each TreeItem the kind of the item. ItemTrees are sorted in the order they
     * are displayed at screen when each node is developped. The first cell is reserved for "tree" 
     * itself
     */
    private Vector itemsInTree;
    
    /**
     * This boolean is set to true if command widget have been redefined.
     */
    private boolean overlapped;    
    private Shell shell;
    private Display display;
    private Tree tree;
    private Command commandExit;
    private Command commandRemove;
    private Command commandAdd;
    private Command commandLabel;

    private Image imageRoot;
    private Image imageNode;
    private Image imageLeave;
    private ImageData rootImageData;
    private ImageData nodeImageData;
    private ImageData leaveImageData;
    
    
    public TreeShowCase() {
        super();
        overlapped = false; // REM : default setting by java !
        
    }
 
    
    public String getName() {
        return Messages.getString("TreeShowCase.3"); //$NON-NLS-1$
    }
    private void  quit() {
        shell.dispose();    // dispose the shell     
        imageRoot.dispose();
        imageNode.dispose();
        imageLeave.dispose();
        super.dispose();

}
    
    protected void show() {
        
        //shell = getComposite().getShell(); ??

        shell = new Shell(getComposite().getShell(),SWT.BORDER | SWT.TITLE);
        shell.setBounds(getComposite().getShell().getBounds());
        shell.setText(Messages.getString("TreeShowCase.4")); //$NON-NLS-1$
        display = getComposite().getShell().getDisplay();

        
        // commands
        commandLabel = new Command(shell, Command.GENERAL, 1);
        commandLabel.setText(Messages.getString("TreeShowCase.5")); //$NON-NLS-1$
        commandLabel.addSelectionListener(this);
        
        commandAdd = new Command(shell, Command.GENERAL, 1);
        commandAdd.setText(Messages.getString("TreeShowCase.6")); //$NON-NLS-1$
        commandAdd.addSelectionListener(this);
        
        commandRemove = new Command(shell, Command.GENERAL, 1);
        commandRemove.setText(Messages.getString("TreeShowCase.7")); //$NON-NLS-1$
        commandRemove.addSelectionListener(this);
        
        commandExit = new Command(shell, Command.EXIT, 1);
        commandExit.setText(Messages.getString("TreeShowCase.8")); //$NON-NLS-1$
        commandExit.setLongLabel(Messages.getString("TreeShowCase.9")); //$NON-NLS-1$
        commandExit.addSelectionListener(this);

        // main widget : tree
        tree = new Tree(shell,SWT.SINGLE|SWT.BORDER|SWT.V_SCROLL|SWT.H_SCROLL);
        
        //create tree node imageData
        rootImageData = new ImageData( getClass().getResourceAsStream("/res/folderRoot.png"));	//$NON-NLS-1$
        nodeImageData = new ImageData( getClass().getResourceAsStream("/res/folder.png"));	//$NON-NLS-1$
        leaveImageData = new ImageData( getClass().getResourceAsStream("/res/file.png"));	//$NON-NLS-1$
        
        //Extend icon to corresponding scale in DPI 192 high resolution device
        if ( display.getDPI().equals(new Point(192,192)))
        {
        	rootImageData = rootImageData.scaledTo(32, 32);
        	nodeImageData = nodeImageData.scaledTo(32, 32);
        	leaveImageData = leaveImageData.scaledTo(32, 32);       
        }		
        
         // create images for tree      
        imageRoot= new Image(display, rootImageData);
        imageNode = new Image(display, nodeImageData);
        imageLeave = new Image(display, leaveImageData);        
       
        resetTree();

        tree.addKeyListener(this);
        

        tree.addSelectionListener(this); 
        
        shell.setText(Messages.getString("TreeShowCase.13")); //$NON-NLS-1$
        shell.setLayout(new FillLayout());
        shell.open();
        shell.layout();     
    }
    
  private void changeCommands(){
      
      // commands
      if(!overlapped){
          commandExit.setText(Messages.getString("TreeShowCase.14")); //$NON-NLS-1$
          commandExit.setLongLabel(Messages.getString("TreeShowCase.15")); //$NON-NLS-1$
          commandAdd.setText(Messages.getString("TreeShowCase.16")); //$NON-NLS-1$
          commandRemove.setText(Messages.getString("TreeShowCase.17")); //$NON-NLS-1$
          commandLabel.setText(Messages.getString("TreeShowCase.18")); //$NON-NLS-1$
      } else {
          commandExit.setText(Messages.getString("TreeShowCase.19"));  //$NON-NLS-1$
          commandExit.setLongLabel(Messages.getString("TreeShowCase.20")); //$NON-NLS-1$
          commandAdd.setText(Messages.getString("TreeShowCase.29")); //$NON-NLS-1$
          commandRemove.setText(Messages.getString("TreeShowCase.22")); //$NON-NLS-1$
          commandLabel.setText(Messages.getString("TreeShowCase.23"));           //$NON-NLS-1$
      }
 
      
  }
    private void ShowResult(String text) {
        final TimedMessageBox timedMessageBox =  new TimedMessageBox(shell);
        timedMessageBox.setText(text);
        timedMessageBox.open();
    }
 
    
    private void displayError(String errorText) {
        MessageBox messagebox = new MessageBox(shell,SWT.ICON_ERROR|SWT.OK);
        messagebox.setMessage(errorText);
        messagebox.open();
    }

    private void SetTreeInVectors(){
        if (itemsInTree == null)
            itemsInTree = new Vector();
        if (itemType == null)
            itemType= new Vector();
        
        itemsInTree.add(0, tree);
        itemType.add(0,new Integer(TREE));
    }
    
    private void removeAndClear(){
        if (tree != null)
            tree.removeAll();
        if (itemsInTree != null)
            itemsInTree.clear();
        if (itemType != null)
            itemType.clear();
    }
 
    
    private void resetTree() {
        removeAndClear();
        SetTreeInVectors();
        
        
        TreeItem root;
        TreeItem node;
        TreeItem leave;
        
        root = (TreeItem) insertItem(tree,ROOT,1);
        node = (TreeItem) insertItem(root,NODE,2);
        leave = (TreeItem) insertItem(node,LEAVE,3);
        leave = (TreeItem) insertItem(node,LEAVE,4);
        leave = (TreeItem) insertItem(node,LEAVE,5);
        
        
        root =(TreeItem) insertItem(tree,ROOT,6);
        node = (TreeItem) insertItem(root,NODE,7);
        node = (TreeItem) insertItem(root,LEAVE,8);
        
        root =(TreeItem) insertItem(tree,ROOT,9);
        node = (TreeItem) insertItem(root,NODE,10);
        node = (TreeItem) insertItem(root,NODE,11);
        node = (TreeItem) insertItem(node,NODE,12);
        node = (TreeItem) insertItem(node,NODE,13);
        leave = (TreeItem) insertItem(node,LEAVE,14);
 
    }
    
    /**
     * Retrieve the index of the item in the vector
     * @param parent
     * @return
     */
    private int findIndexOfItem(Object item){
        if(itemsInTree == null)
            return -1;
       return itemsInTree.indexOf(item);
    }
    
    private void removeAllItemsFrom(TreeItem start, int startIndex){
        
        
        
        // We adopt the following strategy. To delete 
        // - A root. Delete it and search the next element just under tree in itemInTree
        // - A node, just delete it and search for the next element in itemInTree that have not the same parent
        // - A leave, not implemented. But we would  just delete it and delete its entries in vectors
        
        int index = startIndex+1; // All element between startIndex and index will be removed.
        
        switch (((Integer)itemType.get(startIndex)).intValue()) {
            case ROOT : {
                for(index = startIndex+1; index < itemsInTree.size(); index++) {
                    final Object currentParent = ((TreeItem)itemsInTree.get(index)).getParentItem();
                    if (  currentParent == null )
                        break;
                }
                break;
            }
            case NODE : { 
                // parent of a node is a root or a node and is never null 
                final TreeItem parentOfStart = ((TreeItem)itemsInTree.get(startIndex)).getParentItem();            
                for(index = startIndex+1; index < itemsInTree.size(); index++) {  
                    final TreeItem parentOfCurrent = ((TreeItem)itemsInTree.get(index)).getParentItem();
                    if (  parentOfStart.equals(parentOfCurrent) || parentOfCurrent == null  )
                        break;
                }
                break; 
            }
            case LEAVE : // not handled here
            default: {
                SWT.error(SWT.ERROR_INVALID_RANGE);
            }
        }
 
        start.dispose();
        for (int counter = 0; counter < index - startIndex; counter++ ) {
            itemType.removeElementAt(startIndex);
            itemsInTree.removeElementAt(startIndex);       
        }
    }
    
    void removeItem(){
        if (tree == null)
            return;
        final TreeItem [] selection = tree.getSelection();
        if (selection.length == 0){
            displayError(Messages.getString("TreeShowCase.24")); //$NON-NLS-1$
            return; 
        }
        
        final int indexofSelected = itemsInTree.indexOf(selection[0]);
        switch (((Integer)itemType.get(indexofSelected)).intValue()) {
            
            case LEAVE: {
                selection[0].dispose();
                itemType.removeElementAt(indexofSelected);
                itemsInTree.removeElementAt(indexofSelected);
                break;
            }
            case ROOT:{
                removeAllItemsFrom(selection[0],indexofSelected );
                break;
            }
            case NODE: {
                removeAllItemsFrom(selection[0], indexofSelected);
                break;
            }
        }
        
        if(tree.getItemCount() != 0) {
            TreeItem [] newSelection;
            if (indexofSelected != 1) {
                newSelection = new  TreeItem []{(TreeItem)itemsInTree.get(indexofSelected-1)};
            } else {
                newSelection = new TreeItem [] {(TreeItem)itemsInTree.get(1) };
            }
            tree.setSelection(newSelection);
            tree.showSelection();
        }
    }
    
    private void add(int type){
        
        
        // consistency Verification
        if (tree == null)
            return;

        TreeItem [] selection = tree.getSelection();
        if ( (selection.length == 0)  && (tree.getItemCount() != 0 )){
            displayError(Messages.getString("TreeShowCase.25")); //$NON-NLS-1$
            return;
        }
        
        
        int indexOfSelected = 0;
        // Is operation enabled ?
        if(tree.getItemCount() != 0 ) {            
    
            indexOfSelected = itemsInTree.indexOf(selection[0]);
            int typeSelected = ((Integer)itemType.get(indexOfSelected)).intValue();
            if( (typeSelected == LEAVE && type == LEAVE )
                 || (typeSelected == LEAVE && type == NODE )
                 ||(typeSelected == NODE && type == ROOT) ){
                displayError(Messages.getString("TreeShowCase.26")); //$NON-NLS-1$
                return;
            }
        } else if (type != ROOT) {
            displayError(Messages.getString("TreeShowCase.27")); //$NON-NLS-1$
            return;
        }
        
        TreeItem newItem = null;
        switch (type) {
        case ROOT: {
                int rankOfnew = 0;
                int indexOfNewInVector = 1;
                
                String label = changeLabel(itemText[ROOT]);
                
                if(label != null) {
                	if(tree.getItemCount() == 0 ) { 
                		newItem = new TreeItem(tree,SWT.BORDER);
                	} else {
                		rankOfnew = rankUnderRoot(indexOfSelected);
                		indexOfNewInVector = findIndexOfNextItemUnderRoot(indexOfSelected);
                		newItem = new TreeItem(tree,SWT.BORDER,rankOfnew);
                    }
                	newItem.setImage(imageRoot);
                	newItem.setText(label);
                	itemsInTree.insertElementAt(newItem,indexOfNewInVector);
                	itemType.insertElementAt(new Integer(ROOT), indexOfNewInVector);
                }

            break;
        }    
        case NODE: {
            // nodes are always built at place 0
            Object parent = itemsInTree.get(indexOfSelected);
            // parents node are only a node or a root
            String label = changeLabel(itemText[NODE]);
            if(label != null) {
            	newItem = new TreeItem((TreeItem)parent,SWT.BORDER,0);
            	newItem.setImage(imageNode);
            	newItem.setText(label);
            	itemsInTree.insertElementAt(newItem,indexOfSelected+1);
            	itemType.insertElementAt(new Integer(NODE), indexOfSelected+1);
            }
            break;
        }
        case LEAVE: {
            // Leaves are always built at place 0
            Object parent = itemsInTree.get(indexOfSelected);
            //parent of leaves  are nodes or roots
            
            String label = changeLabel(itemText[LEAVE]);
            if(label != null) {
            	newItem = new TreeItem((TreeItem)parent,SWT.BORDER,0);
            	newItem.setImage(imageLeave);
            	newItem.setText(label);
            	itemsInTree.insertElementAt(newItem,indexOfSelected+1);
            	itemType.insertElementAt(new Integer(LEAVE), indexOfSelected+1);
            }
            break;
        }
        }
        
        tree.setSelection(new TreeItem[]{newItem});
        tree.showSelection();
    }
 
    /**
     * Retrieve the index of the root of the item at position index
     * Applied to a root it returns the root's index itself.
     * Return is the index in the vector that is composed at place 0 of "tree" (not an item).
     * @return the root's index or -1 if not found
     */
    private int findRootOfItemIndex(int current){
        
        if (((Integer)itemType.get(current)).intValue() == ROOT)
            return current;
        
        for(int index = current-1; index>0; index--){
            if (((Integer)itemType.get(current)).intValue() == ROOT){
                return index;
            }
        }
        return -1;
    }
    
    
    /**
     * Retrieve the index of the next element built directly under tree.
     * If not found return the number of item in the tree.
     * Return is the index in the vector that is composed at place 0 of "tree" (not an item).
     * @param current
     * @return
     */
    int findIndexOfNextItemUnderRoot(int current){
        int index;
        for( index = current+1; index < itemType.size(); current++){
            if(((TreeItem)itemsInTree.get(current)).getParentItem() == null){
                break;
            }
        }
        return index;
    }
    
    private void changeLabel(){
        
        TreeItem [] selection = tree.getSelection();
        if (selection.length == 0){
            return;
        }
        String newLabel = changeLabel(selection[0].getText());
        if(newLabel != null)
        	selection[0].setText(newLabel);
     }
    
    private String changeLabel(String label){
//        boolean done = false;
        QueryDialog queryD = new QueryDialog(shell,SWT.APPLICATION_MODAL | QueryDialog.STANDARD);
        queryD.setMaximum(15);
        queryD.setPromptText(Messages.getString("TreeShowCase.28"), label); //$NON-NLS-1$
        String result = queryD.open();
        return result;
    }
    /**
     * Count All the item directly built under the tree (may be a root or a leave).
     * @param start : a root index
     * @return : result varies from 1 to n in a normal tree.
     */
    private int rankUnderRoot(int start){
        int result = 0;
        for(int index = start; index > 0; --index){
            if (((TreeItem)itemsInTree.get(index)).getParentItem() == null)
                    result++;
        }
        return result;
    }
    
    /**
     * Count All the Node and leave existing before the parent is encountered starting from start index.
     * included this node
     * @param start : a node index
     */
    private int nodeRank(int start){
        int result = 0;
        TreeItem parent  = ((TreeItem)itemsInTree.get(start)).getParentItem();
        for(int index = start; index>0; --index){
            if (parent.equals(((TreeItem)itemsInTree.get(index))))
                break;
            else
                result++;
        }
        return result;
    }
    
    /**
     * Count All the leaves displayed before a node or a root is encountered starting from start index
     * if leave is not just created under the tree itself. In this case count the roots..
     * Result includes the node itself.
     * @param start : a leave index
     */
    private int leaveRank(int start){
        int result = 1;
        if (((TreeItem)itemsInTree.get(start)).getParentItem() == null){
            return rankUnderRoot(start);
        } else {
            for(int index = start-1; index>0; --index){
                int type = ((Integer)itemType.get(index)).intValue();
                if (type == ROOT || type == NODE)
                    break;
                if (((Integer)itemType.get(index)).intValue() == NODE)
                    result++;
            }
       }
        return result;
    }
    
    /**
     * This method is used to reset the tree. It can not be used if you want to
     * set yourself the rank of the item to add to the tree.
     */
    private Object insertItem(Object parent, int type, int itemIndex){
 
        //  create the item
        TreeItem newItem;
        if (parent.equals(tree))
            newItem = new TreeItem((Tree)parent,SWT.BORDER);
        else
            newItem = new TreeItem((TreeItem)parent,SWT.BORDER);
        
         
        // attach the image and the text
        switch (type) {
            case ROOT: {
                newItem.setImage(imageRoot);
                newItem.setText(itemText[ROOT]);
                break;
            }
            case NODE: {
                newItem.setImage(imageNode);
                newItem.setText(itemText[NODE]);
                break;
            }
            case LEAVE: {
                newItem.setImage(imageLeave);
                newItem.setText(itemText[LEAVE]);
                break;
            }
            default: {
                newItem.setImage(imageLeave);
                newItem.setText(itemText[LEAVE]);
                type = LEAVE;
            }
        } 
        // Set the vectors.
        itemsInTree.add(itemIndex,newItem);
        itemType.add(itemIndex, new Integer(type));
        return newItem;
    }

    private void cancel(){
        overlapped = false;
        changeCommands();
    }
    
    public void widgetSelected(SelectionEvent e) {
        try {

            if (e.widget == tree) {
            }
 
            else if (e.widget == commandLabel){
                if (overlapped){
                    add(ROOT);
                } else {
                    changeLabel();
                }           }
            else if (e.widget == commandAdd) {
                if (overlapped){
                    add(NODE);
                } else {
                    // TODO : is invalidated for the time being 
                    overlapped = true;
                    changeCommands();
                }                
            }
            else if (e.widget == commandRemove){
                if (overlapped){
                    add(LEAVE);
                } else {
                    removeItem();
                }
            }
            else if (e.widget == commandExit) {
                if (overlapped){
                    cancel(); 
                } else {
                    quit(); 
                }
            }
        } catch (Exception error) {
        }

    }

    public void keyPressed(KeyEvent e) {
    }
    
    public void keyReleased(KeyEvent e) {
    }
 
    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
     


