/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.example;

import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Debug {
	public static final boolean DEBUG=true;
	public static boolean BENCHMARK_ONLY = false;

	public static final String ERCP_HELLO = "org.eclipse.ercp.example.ercpHello/"; //$NON-NLS-1$
	public static final String OPTION_BENCHMARKONLY = ERCP_HELLO + "benchmarkOnly"; //$NON-NLS-1$
	
		public static void loadOptions(BundleContext context) {
		DebugOptions service = null;
		ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
		if (reference != null)
			service = (DebugOptions) context.getService(reference);
		if (service == null)
			return;
		try {
			BENCHMARK_ONLY = service.getBooleanOption(OPTION_BENCHMARKONLY, BENCHMARK_ONLY);
		} finally {
			// we have what we want - release the service
			context.ungetService(reference);
		}		
	}

}
