/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.example;


import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;

import java.io.InputStream;
import java.util.ResourceBundle;

/*
 * This example builds on HelloWorld1 and demonstrates how to draw directly
 * on an SWT Control.
 */
public class ErcpHello {
	private static final String MAIN = "ErcpHello.main()";
	private static ResourceBundle resHello = ResourceBundle.getBundle("ercpHello");

public static void main (String [] args) {
	if (Profile.PROFILE && Profile.STARTUP)
		Profile.logEnter(MAIN);
	
	try {
		Display display = Display.getDefault();
		Shell shell = new ErcpHello().open (display);
		
		if (Profile.PROFILE && (Profile.STARTUP || Profile.BENCHMARK))
			Profile.logTime(MAIN, "application started");
		else 
			System.out.println("eRCPHello started");
		
		if (!Debug.DEBUG || !Debug.BENCHMARK_ONLY) {
			while (!shell.isDisposed ()) {
				if (!display.readAndDispatch ()) display.sleep ();
			}
		}
		display.dispose ();
	} finally {
		if (Profile.PROFILE && Profile.STARTUP)
			Profile.logExit(MAIN);
	}
}

public Shell open (Display display) {
	final Color blue = display.getSystemColor(SWT.COLOR_BLUE);
	final Shell shell = new Shell (display, SWT.CLOSE);

	Rectangle r0 = shell.getBounds();
	shell.setBounds(r0.x, r0.y, r0.height>500?240:r0.width, r0.height>500?294:r0.height);
	InputStream is = getClass().getResourceAsStream("EclipseBannerPic.png");
	ImageData bannerImage = (is != null) ? new ImageData(is) : null;
	Label banner = new Label(shell, SWT.NONE);
	banner.setBounds(shell.getClientArea());
	banner.setImage(new Image(display, bannerImage));
	banner.pack();
	Rectangle r1 = shell.getClientArea();
	Rectangle r2 = banner.getBounds();
	banner.setLocation((r1.width-r2.width)/2, (r1.height-r2.height)/2);
	
	shell.addShellListener( new ShellListener() {
		public void shellActivated(ShellEvent arg0) {
		}
		public void shellClosed(ShellEvent arg0) {
		}
		public void shellDeactivated(ShellEvent arg0) {
		}
		public void shellDeiconified(ShellEvent arg0) {
		}
		public void shellIconified(ShellEvent arg0) {
			shell.close();
		}
	});
	shell.addPaintListener(new PaintListener () {
		public void paintControl(PaintEvent event){
			GC gc = event.gc;
			gc.setForeground(blue);
			Rectangle rect = shell.getClientArea();
			gc.drawRectangle(rect.x + 10, rect.y + 10, rect.width - 20, rect.height - 20);
			gc.drawString(resHello.getString("Hello_world"), rect.x + 20, rect.y + 20);
		}
	});
	shell.addDisposeListener (new DisposeListener () {
		public void widgetDisposed (DisposeEvent e) {
			blue.dispose();
		}
	});
	shell.setText(resHello.getString("Hello_title"));
	Menu menuBar = new Menu(shell, SWT.BAR);
	shell.setMenuBar(menuBar);
	MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	item.setText(resHello.getString("File"));
	Menu menu = new Menu(shell, SWT.DROP_DOWN);
	item.setMenu(menu);
	MenuItem subItem = new MenuItem(menu, SWT.NULL);
	subItem.setText(resHello.getString("Exit"));
	subItem.addSelectionListener(new SelectionListener() {
		public void widgetSelected(SelectionEvent arg0) {
			shell.close();
		}
		public void widgetDefaultSelected(SelectionEvent arg0) {
		}
	});
	shell.open ();
	return shell;
}
}

