/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.FeatureStatus;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationValidator;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.osgi.framework.Bundle;

public class OperationValidator
implements IOperationValidator {
    public IStatus validatePlatformConfigValid() {
        ArrayList status = new ArrayList(1);
        OperationValidator.checkPlatformWasModified(status);
        if (status.size() > 0) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, status, 4);
        }
        return null;
    }

    public IStatus validatePendingInstall(IFeature oldFeature, IFeature newFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateInstall(oldFeature, newFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingUnconfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateUnconfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingConfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateConfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingReplaceVersion(IFeature feature, IFeature anotherFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateReplaceVersion(feature, anotherFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingRevert(IInstallConfiguration config) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateRevert(config, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingChanges(IInstallFeatureOperation[] jobs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        OperationValidator.checkPlatformWasModified(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validatePendingConfigChanges(jobs, status, beforeStatus);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingChanges(IConfigFeatureOperation[] jobs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        OperationValidator.checkPlatformWasModified(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validatePendingConfigChanges(jobs, status, beforeStatus);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingChanges(IUnconfigFeatureOperation[] jobs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        OperationValidator.checkPlatformWasModified(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validatePendingUnconfigChanges(jobs, status, beforeStatus);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public RequiredFeaturesResult getRequiredFeatures(IInstallFeatureOperation[] jobs) {
        RequiredFeaturesResult requiredFeaturesResult = new RequiredFeaturesResult();
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        OperationValidator.checkPlatformWasModified(beforeStatus);
        ArrayList status = new ArrayList();
        Set requiredFeatures = OperationValidator.validatePendingConfigChanges(jobs, status, beforeStatus);
        requiredFeaturesResult.setRequiredFeatures(requiredFeatures);
        requiredFeaturesResult.setStatus(OperationValidator.createCombinedReportStatus(beforeStatus, status));
        return requiredFeaturesResult;
    }

    public IStatus validateCurrentState() {
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateInitialState(status);
        if (status.size() > 0) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, status, 4);
        }
        return null;
    }

    private static void validateInitialState(ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateUnconfigure(IFeature feature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            features = OperationValidator.computeFeaturesAfterOperation(features, null, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateConfigure(IFeature feature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkOptionalChildConfiguring(feature, status);
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, feature, null);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateReplaceVersion(IFeature feature, IFeature anotherFeature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, anotherFeature, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateInstall(IFeature oldFeature, IFeature newFeature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(oldFeature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(newFeature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkLicense(newFeature, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateRevert(IInstallConfiguration config, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeaturesAfterRevert(config);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkRevertConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static Set validatePendingUnconfigChanges(IFeatureOperation[] jobs, ArrayList status, ArrayList beforeStatus) {
        try {
            IFeature rmFeature;
            IFeature addFeature;
            IFeatureOperation job;
            ArrayList features;
            ArrayList savedFeatures = features = OperationValidator.computeFeatures();
            ArrayList tmpStatus = new ArrayList();
            int i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                addFeature = null;
                rmFeature = job.getFeature();
                features = OperationValidator.computeFeaturesAfterOperation(features, addFeature, rmFeature);
                ++i;
            }
            OperationValidator.checkConstraints(features, tmpStatus);
            if (tmpStatus.size() == 0) {
                return Collections.EMPTY_SET;
            }
            features = savedFeatures;
            i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                addFeature = null;
                rmFeature = job.getFeature();
                features = OperationValidator.computeFeaturesAfterOperation(features, addFeature, rmFeature);
                Set result = OperationValidator.checkConstraints(features, status);
                if (status.size() > 0 && !OperationValidator.isBetterStatus(beforeStatus, status)) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        return Collections.EMPTY_SET;
    }

    private static Set validatePendingConfigChanges(IFeatureOperation[] jobs, ArrayList status, ArrayList beforeStatus) {
        try {
            IFeature oldFeature;
            IFeature newFeature;
            IFeatureOperation job;
            ArrayList features;
            ArrayList savedFeatures = features = OperationValidator.computeFeatures();
            int nexclusives = 0;
            ArrayList tmpStatus = new ArrayList();
            int i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                OperationValidator.checkLicense(newFeature, status);
                if (jobs.length > 1 && newFeature.isExclusive()) {
                    ++nexclusives;
                    status.add(OperationValidator.createStatus(newFeature, 4, Messages.ActivityConstraints_exclusive));
                } else {
                    OperationValidator.checkForCycles(newFeature, null, features);
                    features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
                }
                ++i;
            }
            if (nexclusives > 0) {
                return Collections.EMPTY_SET;
            }
            i = 0;
            while (i < jobs.length) {
                IFeature newFeature2 = jobs[i].getFeature();
                OperationValidator.checkOptionalChildConfiguring(newFeature2, features, status);
                if (status.size() > 0) {
                    return Collections.EMPTY_SET;
                }
                ++i;
            }
            OperationValidator.checkConstraints(features, tmpStatus);
            if (tmpStatus.size() == 0) {
                return Collections.EMPTY_SET;
            }
            features = savedFeatures;
            i = 0;
            while (i < jobs.length) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
                Set result = OperationValidator.checkConstraints(features, status);
                if (status.size() > 0 && !OperationValidator.isBetterStatus(beforeStatus, status)) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        return Collections.EMPTY_SET;
    }

    private static void checkPlatformWasModified(ArrayList status) {
        try {
            IPlatformConfiguration platformConfig = ConfiguratorUtils.getCurrentPlatformConfiguration();
            long currentTimeStamp = platformConfig.getChangeStamp();
            if (platformConfig instanceof PlatformConfiguration) {
                currentTimeStamp = ((PlatformConfiguration)platformConfig).getConfiguration().lastModified();
            }
            URL platformXML = platformConfig.getConfigurationLocation();
            long actualTimeStamp = currentTimeStamp;
            if ("file".equals(platformXML.getProtocol())) {
                actualTimeStamp = new File(platformXML.getFile()).lastModified();
            } else {
                URLConnection connection = platformXML.openConnection();
                actualTimeStamp = connection.getLastModified();
            }
            if (currentTimeStamp != actualTimeStamp) {
                status.add(OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_platformModified));
            }
        }
        catch (IOException iOException) {}
    }

    private static void checkSiteReadOnly(IFeature feature, ArrayList status) {
        if (feature == null) {
            return;
        }
        IConfiguredSite csite = feature.getSite().getCurrentConfiguredSite();
        if (csite != null && !csite.isUpdatable()) {
            status.add(OperationValidator.createStatus(feature, 0, NLS.bind((String)Messages.ActivityConstraints_readOnly, (Object[])new String[]{csite.getSite().getURL().toExternalForm()})));
        }
    }

    private static ArrayList computeFeatures() throws CoreException {
        return OperationValidator.computeFeatures(true);
    }

    private static ArrayList computeFeatures(boolean configuredOnly) throws CoreException {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] crefs = configuredOnly ? csite.getConfiguredFeatures() : csite.getSite().getFeatureReferences();
            int j = 0;
            while (j < crefs.length) {
                IFeatureReference cref = crefs[j];
                IFeature cfeature = cref.getFeature(null);
                features.add(cfeature);
                ++j;
            }
            ++i;
        }
        return features;
    }

    public static ArrayList computeFeatureSubtree(IFeature top, IFeature feature, ArrayList features, boolean tolerateMissingChildren, ArrayList configuredFeatures, ArrayList visitedFeatures) throws CoreException {
        if (top == null) {
            return features;
        }
        if (feature == null) {
            feature = top;
        }
        if (features == null) {
            features = new ArrayList();
        }
        if (visitedFeatures == null) {
            visitedFeatures = new ArrayList<IFeature>();
        }
        if (visitedFeatures.contains(feature)) {
            IStatus status = OperationValidator.createStatus(top, 8, Messages.ActivityConstraints_cycle);
            throw new CoreException(status);
        }
        visitedFeatures.add(feature);
        if (!features.contains(feature)) {
            features.add(feature);
        }
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < children.length) {
            block9: {
                try {
                    IFeature child = UpdateUtils.getIncludedFeature(feature, children[i]);
                    features = OperationValidator.computeFeatureSubtree(top, child, features, tolerateMissingChildren, null, visitedFeatures);
                }
                catch (CoreException e) {
                    if (children[i].isOptional() || tolerateMissingChildren) break block9;
                    throw e;
                }
            }
            ++i;
        }
        visitedFeatures.remove(feature);
        return features;
    }

    private static void checkLicense(IFeature feature, ArrayList status) {
        String license;
        IURLEntry licenseEntry = feature.getLicense();
        if (licenseEntry != null && (license = licenseEntry.getAnnotation()) != null && license.trim().length() > 0) {
            return;
        }
        status.add(OperationValidator.createStatus(feature, 0, Messages.ActivityConstraints_noLicense));
    }

    private static ArrayList computeFeaturesAfterOperation(ArrayList features, IFeature add, IFeature remove) throws CoreException {
        ArrayList addTree = OperationValidator.computeFeatureSubtree(add, null, null, false, features, null);
        ArrayList removeTree = OperationValidator.computeFeatureSubtree(remove, null, null, true, null, null);
        if (remove != null) {
            OperationValidator.contributePatchesFor(removeTree, features, removeTree);
        }
        if (remove != null) {
            features.removeAll(removeTree);
        }
        if (add != null) {
            features.addAll(addTree);
        }
        return features;
    }

    private static void contributePatchesFor(ArrayList removeTree, ArrayList features, ArrayList result) throws CoreException {
        int i = 0;
        while (i < removeTree.size()) {
            IFeature feature = (IFeature)removeTree.get(i);
            OperationValidator.contributePatchesFor(feature, features, result);
            ++i;
        }
    }

    private static void contributePatchesFor(IFeature feature, ArrayList features, ArrayList result) throws CoreException {
        int i = 0;
        while (i < features.size()) {
            IFeature candidate = (IFeature)features.get(i);
            if (UpdateUtils.isPatch(feature, candidate)) {
                ArrayList removeTree = OperationValidator.computeFeatureSubtree(candidate, null, null, true, null, null);
                result.addAll(removeTree);
            }
            ++i;
        }
    }

    private static ArrayList computeFeaturesAfterRevert(IInstallConfiguration config) throws CoreException {
        ArrayList<IFeature> list = new ArrayList<IFeature>();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] features = csite.getConfiguredFeatures();
            int j = 0;
            while (j < features.length) {
                list.add(features[j].getFeature(null));
                ++j;
            }
            ++i;
        }
        return list;
    }

    private static ArrayList computePluginsForFeatures(ArrayList features) throws CoreException {
        if (features == null) {
            return new ArrayList();
        }
        HashMap<VersionedIdentifier, IPluginEntry> plugins = new HashMap<VersionedIdentifier, IPluginEntry>();
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            IPluginEntry[] entries = feature.getPluginEntries();
            int j = 0;
            while (j < entries.length) {
                IPluginEntry entry = entries[j];
                plugins.put(entry.getVersionedIdentifier(), entry);
                ++j;
            }
            ++i;
        }
        ArrayList result = new ArrayList();
        result.addAll(plugins.values());
        return result;
    }

    private static void checkForCycles(IFeature feature, ArrayList candidates, ArrayList configuredFeatures) throws CoreException {
        if (feature == null) {
            return;
        }
        if (configuredFeatures == null) {
            configuredFeatures = new ArrayList();
        }
        if (candidates == null) {
            candidates = new ArrayList<IFeature>();
        }
        if (candidates.contains(feature)) {
            String msg = NLS.bind((String)Messages.ActivityConstraints_cycle, (Object[])new String[]{feature.getLabel(), feature.getVersionedIdentifier().toString()});
            IStatus status = OperationValidator.createStatus(feature, 8, msg);
            throw new CoreException(status);
        }
        candidates.add(feature);
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < children.length) {
            block7: {
                try {
                    IFeature child = UpdateUtils.getIncludedFeature(feature, children[i]);
                    OperationValidator.checkForCycles(child, candidates, configuredFeatures);
                }
                catch (CoreException e) {
                    if (children[i].isOptional()) break block7;
                    throw e;
                }
            }
            ++i;
        }
        candidates.remove(feature);
    }

    private static Set checkConstraints(ArrayList features, ArrayList status) throws CoreException {
        if (features == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList plugins = OperationValidator.computePluginsForFeatures(features);
        OperationValidator.checkEnvironment(features, status);
        OperationValidator.checkPlatformFeature(features, plugins, status);
        OperationValidator.checkPrimaryFeature(features, plugins, status);
        return OperationValidator.checkPrereqs(features, plugins, status);
    }

    private static void checkEnvironment(ArrayList features, ArrayList status) {
        String os = Platform.getOS().toLowerCase();
        String ws = Platform.getWS().toLowerCase();
        String arch = Platform.getOSArch().toLowerCase();
        int i = 0;
        while (i < features.size()) {
            IStatus s;
            IFeature feature = (IFeature)features.get(i);
            String featureOS = feature.getOS();
            ArrayList fos = OperationValidator.createList(featureOS != null ? featureOS.toLowerCase() : null);
            String featureWS = feature.getWS();
            ArrayList fws = OperationValidator.createList(featureWS != null ? featureWS.toLowerCase() : null);
            String featureArch = feature.getOSArch();
            ArrayList farch = OperationValidator.createList(featureArch != null ? featureArch.toLowerCase() : null);
            if (fos.size() > 0 && !fos.contains(os)) {
                s = OperationValidator.createStatus(feature, 32, Messages.ActivityConstraints_os);
                if (!status.contains(s)) {
                    status.add(s);
                }
            } else if (fws.size() > 0 && !fws.contains(ws)) {
                s = OperationValidator.createStatus(feature, 32, Messages.ActivityConstraints_ws);
                if (!status.contains(s)) {
                    status.add(s);
                }
            } else if (farch.size() > 0 && !farch.contains(arch) && !status.contains(s = OperationValidator.createStatus(feature, 32, Messages.ActivityConstraints_arch))) {
                status.add(s);
            }
            ++i;
        }
    }

    private static void checkPlatformFeature(ArrayList features, ArrayList plugins, ArrayList status) {
        IStatus s;
        IProduct product = Platform.getProduct();
        if (product == null) {
            return;
        }
        Bundle primaryBundle = product.getDefiningBundle();
        boolean found = false;
        int j = 0;
        while (j < plugins.size()) {
            IPluginEntry plugin = (IPluginEntry)plugins.get(j);
            if (primaryBundle.getSymbolicName().equals(plugin.getVersionedIdentifier().getIdentifier())) {
                found = true;
                break;
            }
            ++j;
        }
        if (!found && !status.contains(s = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_platform))) {
            status.add(s);
        }
    }

    private static void checkPrimaryFeature(ArrayList features, ArrayList plugins, ArrayList status) {
        String featureId = ConfiguratorUtils.getCurrentPlatformConfiguration().getPrimaryFeatureIdentifier();
        if (featureId != null) {
            int i = 0;
            while (i < features.size()) {
                IFeature feature = (IFeature)features.get(i);
                if (featureId.equals(feature.getVersionedIdentifier().getIdentifier())) {
                    return;
                }
                ++i;
            }
            IStatus s = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_primary);
            if (!status.contains(s)) {
                status.add(s);
            }
        } else {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return;
            }
            Bundle primaryBundle = product.getDefiningBundle();
            int j = 0;
            while (j < plugins.size()) {
                IPluginEntry plugin = (IPluginEntry)plugins.get(j);
                if (primaryBundle.getSymbolicName().equals(plugin.getVersionedIdentifier().getIdentifier())) {
                    return;
                }
                ++j;
            }
            IStatus s = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_primary);
            if (!status.contains(s)) {
                status.add(s);
            }
        }
    }

    private static Set checkPrereqs(ArrayList features, ArrayList plugins, ArrayList status) {
        HashSet<InternalImport> result = new HashSet<InternalImport>();
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            IImport[] imports = feature.getImports();
            int j = 0;
            while (j < imports.length) {
                IImport iimport = imports[j];
                VersionedIdentifier iid = iimport.getVersionedIdentifier();
                String id = iid.getIdentifier();
                PluginVersionIdentifier version = iid.getVersion();
                boolean featurePrereq = iimport.getKind() == 1;
                boolean ignoreVersion = version.getMajorComponent() == 0 && version.getMinorComponent() == 0 && version.getServiceComponent() == 0;
                int rule = iimport.getRule();
                if (rule == 0) {
                    rule = 3;
                }
                boolean found = false;
                ArrayList candidates = featurePrereq ? features : plugins;
                int k = 0;
                while (k < candidates.size()) {
                    block25: {
                        VersionedIdentifier cid;
                        block26: {
                            block24: {
                                if (!featurePrereq) break block24;
                                IFeature candidate = (IFeature)candidates.get(k);
                                if (feature.equals(candidate)) break block25;
                                cid = candidate.getVersionedIdentifier();
                                break block26;
                            }
                            IPluginEntry plugin = (IPluginEntry)candidates.get(k);
                            cid = plugin.getVersionedIdentifier();
                        }
                        PluginVersionIdentifier cversion = cid.getVersion();
                        if (id.equals(cid.getIdentifier())) {
                            if (ignoreVersion) {
                                found = true;
                            } else if (rule == 1 && cversion.isPerfect(version)) {
                                found = true;
                            } else if (rule == 2 && cversion.isEquivalentTo(version)) {
                                found = true;
                            } else if (rule == 3 && cversion.isCompatibleWith(version)) {
                                found = true;
                            } else if (rule == 4 && cversion.isGreaterOrEqualTo(version)) {
                                found = true;
                            }
                        }
                        if (found) break;
                    }
                    ++k;
                }
                if (!found) {
                    String target = featurePrereq ? Messages.ActivityConstaints_prereq_feature : Messages.ActivityConstaints_prereq_plugin;
                    int errorCode = featurePrereq ? 1 : 2;
                    String msg = NLS.bind((String)Messages.ActivityConstraints_prereq, (Object[])new String[]{target, id});
                    if (!ignoreVersion) {
                        if (rule == 1) {
                            msg = NLS.bind((String)Messages.ActivityConstraints_prereqPerfect, (Object[])new String[]{target, id, version.toString()});
                        } else if (rule == 2) {
                            msg = NLS.bind((String)Messages.ActivityConstraints_prereqEquivalent, (Object[])new String[]{target, id, version.toString()});
                        } else if (rule == 3) {
                            msg = NLS.bind((String)Messages.ActivityConstraints_prereqCompatible, (Object[])new String[]{target, id, version.toString()});
                        } else if (rule == 4) {
                            msg = NLS.bind((String)Messages.ActivityConstraints_prereqGreaterOrEqual, (Object[])new String[]{target, id, version.toString()});
                        }
                    }
                    IStatus s = OperationValidator.createStatus(feature, errorCode, msg);
                    result.add(new InternalImport(iimport));
                    if (!status.contains(s)) {
                        status.add(s);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static void checkRevertConstraints(ArrayList features, ArrayList status) {
        int i = 0;
        while (i < features.size()) {
            IFeature feature = (IFeature)features.get(i);
            try {
                OperationValidator.computeFeatureSubtree(feature, null, null, false, null, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
    }

    private static void checkOptionalChildConfiguring(IFeature feature, ArrayList status) throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        boolean included = false;
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            ISiteFeatureReference[] crefs = csite.getSite().getFeatureReferences();
            int j = 0;
            while (j < crefs.length) {
                ISiteFeatureReference cref = crefs[j];
                IFeature cfeature = null;
                cfeature = cref.getFeature(null);
                if (OperationValidator.isParent(cfeature, feature, true)) {
                    included = true;
                    if (csite.isConfigured(cfeature)) {
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (included) {
            String msg = Messages.ActivityConstraints_optionalChild;
            status.add(OperationValidator.createStatus(feature, 16, msg));
        }
    }

    private static void checkOptionalChildConfiguring(IFeature feature, ArrayList afterFeatures, ArrayList status) throws CoreException {
        boolean included = false;
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] sites = config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite site = sites[i];
            ISiteFeatureReference[] refs = site.getSite().getFeatureReferences();
            int j = 0;
            while (j < refs.length) {
                ISiteFeatureReference ref = refs[j];
                IFeature candidate = ref.getFeature(null);
                boolean bParent = OperationValidator.isParent(candidate, feature, false);
                if (bParent) {
                    included = true;
                    int k = 0;
                    while (k < afterFeatures.size()) {
                        IFeature cFeature = (IFeature)afterFeatures.get(k);
                        if (cFeature.equals(candidate)) {
                            return;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (included) {
            String msg = Messages.ActivityConstraints_optionalChild;
            status.add(OperationValidator.createStatus(feature, 16, msg));
        }
    }

    private static boolean isParent(IFeature candidate, IFeature feature, boolean optionalOnly) throws CoreException {
        IIncludedFeatureReference[] refs = candidate.getIncludedFeatureReferences();
        int i = 0;
        while (i < refs.length) {
            PluginVersionIdentifier cversion;
            PluginVersionIdentifier fversion;
            IIncludedFeatureReference child = refs[i];
            VersionedIdentifier fvid = feature.getVersionedIdentifier();
            VersionedIdentifier cvid = child.getVersionedIdentifier();
            if (fvid.getIdentifier().equals(cvid.getIdentifier()) && (fversion = fvid.getVersion()).equals((Object)(cversion = cvid.getVersion()))) {
                return !optionalOnly || child.isOptional();
            }
            ++i;
        }
        return false;
    }

    private static IStatus createMultiStatus(String message, ArrayList children, int code) {
        IStatus[] carray = children.toArray(new IStatus[children.size()]);
        return new MultiStatus(UpdateCore.getPlugin().getBundle().getSymbolicName(), code, carray, message, null);
    }

    private static IStatus createStatus(IFeature feature, int errorCode, String message) {
        String fullMessage;
        if (feature == null) {
            fullMessage = message;
        } else {
            PluginVersionIdentifier version = feature.getVersionedIdentifier().getVersion();
            fullMessage = NLS.bind((String)Messages.ActivityConstraints_childMessage, (Object[])new String[]{feature.getLabel(), version.toString(), message});
        }
        return new FeatureStatus(feature, 4, UpdateCore.getPlugin().getBundle().getSymbolicName(), errorCode, fullMessage, null);
    }

    private static IStatus createCombinedReportStatus(ArrayList beforeStatus, ArrayList status) {
        if (beforeStatus.size() == 0) {
            if (status.size() == 0) {
                return null;
            }
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, status, 4);
        }
        if (status.size() == 0) {
            return null;
        }
        if (OperationValidator.isBetterStatus(beforeStatus, status)) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_warning, beforeStatus, 2);
        }
        ArrayList<IStatus> combined = new ArrayList<IStatus>();
        combined.add(OperationValidator.createMultiStatus(Messages.ActivityConstraints_beforeMessage, beforeStatus, 4));
        combined.add(OperationValidator.createMultiStatus(Messages.ActivityConstraints_afterMessage, status, 4));
        return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessageInitial, combined, 4);
    }

    private static ArrayList createList(String commaSeparatedList) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedList != null) {
            StringTokenizer t = new StringTokenizer(commaSeparatedList.trim(), ",");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.equals("")) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static boolean isBetterStatus(ArrayList beforeStatus, ArrayList status) {
        if (status == null || status.size() == 0) {
            return true;
        }
        if (beforeStatus == null || beforeStatus.size() == 0) {
            return false;
        }
        if (beforeStatus.size() < status.size()) {
            return false;
        }
        int i = 0;
        while (i < status.size()) {
            IStatus s = (IStatus)status.get(i);
            if (!(s instanceof FeatureStatus)) {
                return false;
            }
            FeatureStatus fs = (FeatureStatus)s;
            boolean found = false;
            int j = 0;
            while (!found && j < beforeStatus.size()) {
                if (fs.equals(beforeStatus.get(j))) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class InternalImport {
        private IImport iimport;

        public InternalImport(IImport iimport) {
            this.iimport = iimport;
        }

        public IImport getImport() {
            return this.iimport;
        }

        public void setImport(IImport iimport) {
            this.iimport = iimport;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InternalImport)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return this.iimport.getVersionedIdentifier().equals(((InternalImport)object).getImport().getVersionedIdentifier()) && this.getImport().getRule() == ((InternalImport)object).getImport().getRule();
        }

        public int hashCode() {
            return this.iimport.getVersionedIdentifier().hashCode() * this.iimport.getRule();
        }
    }

    public class RequiredFeaturesResult {
        private IStatus status;
        private Set requiredFeatures;

        public Set getRequiredFeatures() {
            return this.requiredFeatures;
        }

        public void setRequiredFeatures(Set requiredFeatures) {
            this.requiredFeatures = requiredFeatures;
        }

        public void addRequiredFeatures(Set requiredFeatures) {
            if (requiredFeatures == null) {
                requiredFeatures = new HashSet();
            }
            this.requiredFeatures.addAll(requiredFeatures);
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

