/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.Verifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.security.CertificatePair;
import org.eclipse.update.internal.security.JarVerificationResult;
import org.eclipse.update.internal.security.KeyStores;
import org.eclipse.update.internal.security.KeystoreHandle;

public class JarVerifier
extends Verifier {
    private static final String MANIFEST = "META-INF";
    private JarVerificationResult result;
    private List trustedCertificates;
    private boolean acceptUnsignedFiles;
    private List listOfKeystores;
    private IProgressMonitor monitor;
    private File jarFile;
    private static byte[] buffer = new byte[8192];

    public JarVerifier() {
        this.initialize();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getKeyStores() throws CoreException {
        if (this.listOfKeystores != null) return this.listOfKeystores;
        this.listOfKeystores = new ArrayList(0);
        KeyStores listOfKeystoreHandles = new KeyStores();
        InputStream in = null;
        KeyStore keystore = null;
        KeystoreHandle handle = null;
        while (listOfKeystoreHandles.hasNext()) {
            try {
                block14: {
                    Object var6_5;
                    handle = listOfKeystoreHandles.next();
                    in = ConnectionFactory.get(handle.getLocation()).getInputStream();
                    try {
                        try {
                            keystore = KeyStore.getInstance(handle.getType());
                            keystore.load(in, null);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToFindEncryption, (Object[])new String[]{handle.getLocation().toExternalForm()}), e);
                        }
                        catch (CertificateException e) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToLoadCertificate, (Object[])new String[]{handle.getLocation().toExternalForm()}), e);
                        }
                        catch (KeyStoreException e) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToFindProviderForKeystore, (Object[])new String[]{handle.getType()}), e);
                        }
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var6_5 = null;
                        if (in == null) break block14;
                    }
                    try {}
                    catch (IOException iOException) {}
                    in.close();
                }
                this.listOfKeystores.add(keystore);
            }
            catch (IOException iOException) {}
        }
        return this.listOfKeystores;
    }

    private void initialize() {
        this.result = null;
        this.trustedCertificates = null;
        this.acceptUnsignedFiles = false;
        this.listOfKeystores = null;
    }

    private void init(IFeature feature, ContentReference contentRef) throws CoreException {
        this.jarFile = null;
        if (contentRef instanceof JarContentReference) {
            JarContentReference jarReference = (JarContentReference)contentRef;
            try {
                this.jarFile = jarReference.asFile();
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("Attempting to read JAR file:" + this.jarFile);
                }
                if (!this.jarFile.exists()) {
                    throw new IOException();
                }
                JarFile jar = new JarFile(this.jarFile);
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ZipException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_InvalidJar, (Object[])new String[]{jarReference.toString()}), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToAccessJar, (Object[])new String[]{jarReference.toString()}), e);
            }
        }
        this.result = new JarVerificationResult();
        this.result.setVerificationCode(6);
        this.result.setResultException(null);
        this.result.setFeature(feature);
        this.result.setContentReference(contentRef);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsInKeystore(Certificate cert) throws CoreException {
        try {
            KeyStore keystore;
            List keyStores = this.getKeyStores();
            if (keyStores.isEmpty()) return false;
            Iterator listOfKeystores = keyStores.iterator();
            do {
                if (listOfKeystores.hasNext()) continue;
                return false;
            } while ((keystore = (KeyStore)listOfKeystores.next()).getCertificateAlias(cert) == null);
            return true;
        }
        catch (KeyStoreException e) {
            throw Utilities.newCoreException(Messages.JarVerifier_KeyStoreNotLoaded, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List readJarFile(JarFile jarFile, String identifier) throws IOException, InterruptedException {
        list = new ArrayList<JarEntry>();
        entries = jarFile.entries();
        currentEntry = null;
        in = null;
        if (this.monitor == null) ** GOTO lbl-1000
        this.monitor.setTaskName(NLS.bind((String)Messages.JarVerifier_Verify, (Object[])new String[]{identifier == null ? jarFile.getName() : identifier}));
        try {
            try lbl-1000:
            // 4 sources

            {
                while (entries.hasMoreElements()) {
                    currentEntry = entries.nextElement();
                    list.add(currentEntry);
                    in = jarFile.getInputStream(currentEntry);
                    while (in.read(JarVerifier.buffer, 0, JarVerifier.buffer.length) != -1) {
                    }
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                this.result.setVerificationCode(6);
                this.result.setResultException(e);
            }
        }
        catch (Throwable var9_8) {
            var8_9 = null;
            try {
                if (in == null) throw var9_8;
                in.close();
                throw var9_8;
            }
            catch (IOException v0) {}
            throw var9_8;
        }
        {
            var8_10 = null;
        }
        try {}
        catch (IOException v1) {
            return list;
        }
        if (in == null) return list;
        in.close();
        return list;
    }

    public void setMonitor(IProgressMonitor newMonitor) {
        this.monitor = newMonitor;
    }

    public IVerificationResult verify(IFeature feature, ContentReference reference, boolean isFeatureVerification, InstallMonitor monitor) throws CoreException {
        IVerificationResult vr;
        if (reference == null) {
            return this.result;
        }
        if (this.getParent() != null && (vr = this.getParent().verify(feature, reference, isFeatureVerification, monitor)).getVerificationCode() != 8) {
            return vr;
        }
        this.setMonitor(monitor);
        this.init(feature, reference);
        this.result.isFeatureVerification(isFeatureVerification);
        if (this.jarFile != null) {
            this.result = this.verify(this.jarFile.getAbsolutePath(), reference.getIdentifier());
        } else {
            this.result.setVerificationCode(8);
        }
        return this.result;
    }

    private JarVerificationResult verify(String file, String identifier) {
        try {
            this.verifyIntegrity(file, identifier);
            this.result.alreadySeen(this.alreadyValidated());
            if (this.result.getVerificationCode() == 5) {
                this.verifyAuthentication();
            }
            if (this.result.getVerificationCode() == 1) {
                this.acceptUnsignedFiles = true;
            }
        }
        catch (Exception e) {
            this.result.setVerificationCode(6);
            this.result.setResultException(e);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
            if (this.monitor.isCanceled()) {
                this.result.setVerificationCode(7);
            }
        }
        return this.result;
    }

    private void verifyAuthentication() throws CoreException {
        CertificatePair[] entries = this.result.getRootCertificates();
        boolean certificateFound = false;
        int i = 0;
        while (i < entries.length) {
            certificateFound = this.existsInKeystore(entries[i].getRoot());
            if (certificateFound) {
                this.result.setVerificationCode(3);
                this.result.setFoundCertificate(entries[i]);
                return;
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void verifyIntegrity(String file, String identifier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 276->280)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean alreadyValidated() {
        if (this.result.getVerificationCode() == 1) {
            return this.acceptUnsignedFiles;
        }
        if (this.getTrustedCertificates() != null) {
            Iterator iter = this.getTrustedCertificates().iterator();
            CertificatePair[] jarPairs = this.result.getRootCertificates();
            while (iter.hasNext()) {
                CertificatePair trustedCertificate = (CertificatePair)iter.next();
                int i = 0;
                while (i < jarPairs.length) {
                    if (trustedCertificate.equals(jarPairs[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < jarPairs.length) {
                this.addTrustedCertificate(jarPairs[i]);
                ++i;
            }
        }
        return false;
    }

    private void addTrustedCertificate(CertificatePair pair) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        if (pair != null) {
            this.trustedCertificates.add(pair);
        }
    }

    private List getTrustedCertificates() {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        return this.trustedCertificates;
    }

    public void setParent(IVerifier parentVerifier) {
        super.setParent(parentVerifier);
        this.initialize();
    }
}

