/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditDayViewListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthWidget;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CalendarMonthView
implements CalendarEditDayViewListener,
SelectionListener {
    Shell monthShell;
    CalendarShowCase calendarShowCase;
    CalendarMonthWidget calendarmonthwidget;
    String[] stringMonths = new String[]{Messages.getString("CalendarMonthView.0"), Messages.getString("CalendarMonthView.1"), Messages.getString("CalendarMonthView.2"), Messages.getString("CalendarMonthView.3"), Messages.getString("CalendarMonthView.4"), Messages.getString("CalendarMonthView.5"), Messages.getString("CalendarMonthView.6"), Messages.getString("CalendarMonthView.7"), Messages.getString("CalendarMonthView.8"), Messages.getString("CalendarMonthView.9"), Messages.getString("CalendarMonthView.10"), Messages.getString("CalendarMonthView.11")};
    private Command commandEditDay;
    private Command commandMTChangeView;
    private Command commandGoToDate;
    private Command commandExit;

    public CalendarMonthView(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
        this.calendarShowCase = calendarShowCase;
        Shell background = calendarShowCase.getComposite().getShell();
        Rectangle bgdBnds = background.getBounds();
        Rectangle bgdArea = background.getClientArea();
        boolean landscape = bgdArea.width > 240 && bgdArea.width > bgdArea.height;
        int style = 262176;
        if (landscape) {
            style |= 0x800;
        }
        this.monthShell = new Shell(background, style);
        this.monthShell.setText(Messages.getString("CalendarMonthView.12"));
        if (landscape) {
            int x = bgdBnds.x + 5;
            int y = bgdBnds.y + 5;
            int w = bgdBnds.width / 2 - 15;
            int h = bgdBnds.height - 5;
            this.monthShell.setBounds(x, y, w, h);
        } else {
            this.monthShell.setBounds(bgdBnds.x, bgdBnds.y, bgdBnds.width, bgdBnds.height);
        }
        this.commandEditDay = new Command((Control)this.monthShell, 2, 4);
        this.commandEditDay.setText(landscape ? Messages.getString("CalendarMonthView.13") : Messages.getString("CalendarMonthView.14"));
        this.commandEditDay.addSelectionListener((SelectionListener)this);
        this.commandMTChangeView = new Command((Control)this.monthShell, 1, 3);
        this.commandMTChangeView.setText(Messages.getString("CalendarMonthView.15"));
        this.commandMTChangeView.addSelectionListener((SelectionListener)this);
        this.commandGoToDate = new Command((Control)this.monthShell, 1, 2);
        this.commandGoToDate.setText(Messages.getString("CalendarMonthView.16"));
        this.commandGoToDate.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.monthShell, 7, 1);
        this.commandExit.setText(Messages.getString("CalendarMonthView.17"));
        this.commandExit.setLongLabel(Messages.getString("CalendarMonthView.18"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.calendarmonthwidget = new CalendarMonthWidget((Composite)this.monthShell, calendardatabase);
        this.calendarmonthwidget.setLocation(0, 0);
        this.calendarmonthwidget.setSize(this.monthShell.getClientArea().width, this.monthShell.getClientArea().height);
        this.calendarmonthwidget.addCalendarMonthWidgetListener(calendarShowCase);
        this.setTitle(this.calendarmonthwidget.getSelecteddate());
        this.calendarmonthwidget.addTraverseListener(calendarShowCase);
        this.monthShell.open();
    }

    public void dispose() {
        this.commandExit.dispose();
        this.commandGoToDate.dispose();
        this.commandMTChangeView.dispose();
        this.commandEditDay.dispose();
        this.monthShell.dispose();
    }

    public Date getDate() {
        return this.calendarmonthwidget.getSelecteddate();
    }

    public void setDate(Date date) {
        this.calendarmonthwidget.setSelectedDate(date);
    }

    public void activate() {
        this.monthShell.forceActive();
        this.calendarmonthwidget.setFocus();
    }

    public boolean isSwitcher(Widget w) {
        return w == this.calendarmonthwidget;
    }

    public void redraw() {
        this.monthShell.redraw();
    }

    public void setTitle(Date newdate) {
        GregorianCalendar gnewdate = new GregorianCalendar();
        gnewdate.setTime(newdate);
        String newTitle = new String();
        Locale locale = Locale.getDefault();
        if (Locale.TRADITIONAL_CHINESE.toString().equals(locale.toString())) {
            newTitle = String.valueOf(newTitle) + gnewdate.get(1);
            newTitle = String.valueOf(newTitle) + Messages.getString("CalendarMonthView.19");
            newTitle = String.valueOf(newTitle) + new String(" " + this.stringMonths[gnewdate.get(2)]);
        } else if (Locale.SIMPLIFIED_CHINESE.toString().equals(locale.toString())) {
            newTitle = String.valueOf(newTitle) + gnewdate.get(1);
            newTitle = String.valueOf(newTitle) + new String(" " + this.stringMonths[gnewdate.get(2)]);
        } else if (Locale.KOREA.toString().equals(locale.toString())) {
            newTitle = String.valueOf(newTitle) + gnewdate.get(1);
            newTitle = String.valueOf(newTitle) + Messages.getString("CalendarMonthView.19");
            newTitle = String.valueOf(newTitle) + new String(" " + this.stringMonths[gnewdate.get(2)]);
        } else if (Locale.JAPAN.toString().equals(locale.toString())) {
            newTitle = String.valueOf(newTitle) + gnewdate.get(1);
            newTitle = String.valueOf(newTitle) + Messages.getString("CalendarMonthView.19");
            newTitle = String.valueOf(newTitle) + new String(" " + this.stringMonths[gnewdate.get(2)]);
        } else {
            newTitle = String.valueOf(newTitle) + new String(String.valueOf(this.stringMonths[gnewdate.get(2)]) + " ");
            newTitle = String.valueOf(newTitle) + gnewdate.get(1);
        }
        this.monthShell.setText(newTitle);
    }

    public void EntriesUpdated() {
        this.calendarmonthwidget.redrawAllMonth();
        this.calendarmonthwidget.redraw();
    }

    public void notifyDateChanged(Date newDate) {
        this.setDate(newDate);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandExit) {
            this.calendarShowCase.quit();
        } else if (e.widget == this.commandEditDay) {
            this.calendarShowCase.editDay();
        } else if (e.widget == this.commandGoToDate) {
            this.calendarShowCase.goToDate(this.calendarShowCase.getComposite().getShell());
        } else if (e.widget == this.commandMTChangeView) {
            this.calendarShowCase.getDayViewScreen().activate(this.monthShell, this.calendarmonthwidget.getSelecteddate());
            if (this.calendarShowCase.getDayViewScreen().quitWanted()) {
                this.calendarShowCase.quit();
            } else {
                this.setDate(this.calendarShowCase.getDayViewScreen().getDisplayedDate());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

