/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCaseComplexLayout;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCaseSimpleLayout;
import org.eclipse.ercp.swt.samples.eswtdemo.MainMenu;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CompositeShowCase
extends ShowCase
implements SelectionListener {
    public static CompositeShowCase instance;
    private MobileShell mobileShell;
    private Command commandExit;
    private MainMenu mainMenu;

    public CompositeShowCase() {
        instance = this;
    }

    private Vector loadShowCases() {
        Vector<ShowCase> showCases = new Vector<ShowCase>();
        showCases.add(new CompositeShowCaseSimpleLayout());
        showCases.add(new CompositeShowCaseComplexLayout(this.mobileShell));
        return showCases;
    }

    public String getName() {
        return Messages.getString("CompositeShowCase.0");
    }

    public Composite getComposite() {
        return this.mobileShell;
    }

    public void show() {
        this.mobileShell = new MobileShell(Display.getCurrent(), 1200);
        this.mobileShell.setText(Messages.getString("CompositeShowCase.1"));
        Vector showCases = this.loadShowCases();
        this.mainMenu = new MainMenu(this.getComposite(), showCases);
        this.enableExit(true);
        this.getComposite().forceFocus();
        this.mobileShell.open();
    }

    public void widgetSelected(SelectionEvent e) {
        this.commandExit.dispose();
        this.commandExit = null;
        this.mobileShell.dispose();
        this.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void enableExit(boolean enable) {
        if (enable) {
            if (this.commandExit == null) {
                this.commandExit = new Command((Control)this.getComposite(), 7, 0);
                this.commandExit.setText(Messages.getString("CompositeShowCase.2"));
                this.commandExit.setLongLabel(Messages.getString("CompositeShowCase.3"));
                this.commandExit.addSelectionListener((SelectionListener)this);
            }
        } else if (this.commandExit != null) {
            this.commandExit.dispose();
            this.commandExit = null;
        }
    }

    public static CompositeShowCase getInstance() {
        return instance;
    }

    protected void setFocus() {
        this.mobileShell.forceActive();
        this.mainMenu.setFocus();
    }
}

