/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ListView;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.Screen;
import org.eclipse.ercp.swt.samples.eswtdemo.Demo;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MainMenu
implements SelectionListener,
DisposeListener,
ControlListener {
    private ListView list;
    private Vector showCases;
    private Composite parent;
    private boolean hasDirectSelect;
    private Composite background;
    Command commandExit;
    Command commandLaunch;
    ShowCase showcase;
    String originalShellString;

    public MainMenu(Composite parent, Vector showCases) {
        parent.setLayout(null);
        this.originalShellString = parent.getShell().getText();
        MobileDevice md = MobileDevice.getMobileDevice();
        Screen[] screens = md.getScreens();
        this.hasDirectSelect = screens[0].isTouchScreen();
        int orient = parent.getSize().x > parent.getSize().y ? 256 : 512;
        this.list = new ListView(parent, 4 | orient);
        this.list.setSize(parent.getSize());
        parent.addControlListener((ControlListener)this);
        this.parent = parent;
        this.showCases = showCases;
        int i = 0;
        while (i < showCases.size()) {
            ShowCase showCase = (ShowCase)showCases.get(i);
            this.list.add(showCase.getName(), null);
            ++i;
        }
        this.commandLaunch = new Command((Control)this.list, 2, 3);
        this.commandLaunch.setText(Messages.getString("MainMenu.0"));
        this.commandLaunch.addSelectionListener((SelectionListener)this);
        if (!Demo.bWorkbenchMode && parent != parent.getShell()) {
            this.commandExit = new Command((Control)this.list, 7, 2);
            this.commandExit.setText(Messages.getString("MainMenu.1"));
            this.commandExit.setLongLabel(Messages.getString("MainMenu.2"));
            this.commandExit.addSelectionListener((SelectionListener)this);
        }
        this.list.addSelectionListener((SelectionListener)this);
    }

    private void quit() {
        this.commandExit.dispose();
        this.commandLaunch.dispose();
        this.parent.dispose();
    }

    private void launch() {
        if (this.list.getSelectionCount() > 0) {
            this.background = new MyBackground(this.parent);
            this.background.addDisposeListener((DisposeListener)this);
            this.background.setBounds(this.parent.getClientArea());
            this.background.moveAbove(null);
            this.list.setVisible(false);
            int index = this.list.getSelectionIndices()[0];
            this.showcase = (ShowCase)this.showCases.get(index);
            this.parent.getShell().setText(this.showcase.getName());
            this.showcase.show(this.background);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.hasDirectSelect || e.widget != this.list) {
            if (e.widget == this.commandLaunch) {
                this.launch();
            } else if (e.widget == this.commandExit) {
                this.quit();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.list) {
            this.launch();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.widget == this.background && this.parent.isVisible()) {
            this.list.setVisible(true);
            this.parent.getShell().redraw();
            this.parent.getShell().setText(this.originalShellString);
            this.list.forceFocus();
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (!this.list.isDisposed()) {
            this.list.setBounds(this.parent.getClientArea());
        }
    }

    public void setFocus() {
        if (this.showcase == null || this.showcase.getComposite() == null || this.showcase.getComposite().isDisposed()) {
            this.list.setFocus();
            this.list.select(0);
            this.list.redraw();
        } else {
            this.showcase.setFocus();
        }
    }

    private static class MyBackground
    extends Composite
    implements ControlListener {
        public MyBackground(Composite parent) {
            super(parent, 0);
            parent.addControlListener((ControlListener)this);
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (!this.isDisposed()) {
                this.setBounds(this.getParent().getClientArea());
            }
        }
    }
}

