/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ConstrainedText;
import org.eclipse.ercp.swt.mobile.HyperLink;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.Screen;
import org.eclipse.ercp.swt.mobile.ScreenEvent;
import org.eclipse.ercp.swt.mobile.ScreenListener;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.swt.mobile.TextExtension;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.ScrolledComposite;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PhoneBookShowCase
extends ShowCase
implements SelectionListener,
KeyListener,
TraverseListener,
ModifyListener,
ControlListener {
    private PhoneBookDataBase phoneBookDataBase;
    private Shell shellDirectory;
    private SortedList listNameWidget;
    private boolean landscape;
    private boolean detailsOpened;
    private Image background;
    private Shell shellDetails;
    Text detailOrganization;
    Text detailPosition;
    HyperLink detailPhone;
    HyperLink detailMobile;
    HyperLink detailEmail;
    private ScrolledComposite entryScrollScreen;
    private Composite entryScreen;
    Text entryLastName;
    Text entryFirstName;
    Text entryCompany;
    Text entryJob;
    ConstrainedText entryTelephone;
    ConstrainedText entryMobile;
    TextExtension entryEMail;
    Command commandExitDirectory;
    Command commandExitDetails;
    Command commandEdit;
    Command commandNew;
    Command commandDelete;
    Command commandEntryScreenDone;
    Command commandBackDetails;
    Screen[] screens;
    RotationListener rotationListener;
    static /* synthetic */ Class class$0;

    public String getName() {
        return Messages.getString("PhoneBookShowCase.0");
    }

    private void positionDirectory() {
        Rectangle bgdBnds = this.getComposite().getShell().getBounds();
        if (this.landscape) {
            int x = bgdBnds.x + 5;
            int y = bgdBnds.y + 5;
            int w = bgdBnds.width / 2 - 10;
            int h = bgdBnds.height - 10;
            this.shellDirectory.setBounds(x, y, w, h);
        } else {
            this.shellDirectory.setBounds(bgdBnds.x + 1, bgdBnds.y + 1, bgdBnds.width - 1, bgdBnds.height - 1);
        }
    }

    private void positionDetails() {
        Rectangle bgdBnds = this.getComposite().getShell().getBounds();
        if (this.landscape) {
            int x = bgdBnds.x + bgdBnds.width / 2 + 5;
            int y = bgdBnds.y + 5;
            int w = bgdBnds.width / 2 - 10;
            int h = bgdBnds.height - 10;
            this.shellDetails.setBounds(x, y, w, h);
        } else {
            this.shellDetails.setBounds(bgdBnds.x + 1, bgdBnds.y + 1, bgdBnds.width - 1, bgdBnds.height - 1);
        }
    }

    public void controlResized(ControlEvent e) {
        this.positionDirectory();
        this.positionDetails();
    }

    public void controlMoved(ControlEvent e) {
        this.positionDirectory();
        this.positionDetails();
    }

    public void show() {
        this.phoneBookDataBase = PhoneBookDataBase.getThePhoneBook();
        Rectangle bgdBnds = this.getComposite().getShell().getBounds();
        this.landscape = bgdBnds.width > 240 && bgdBnds.width > bgdBnds.height;
        this.shellDirectory = new Shell(this.getComposite().getShell(), 2080);
        this.shellDirectory.setText(Messages.getString("PhoneBookShowCase.2"));
        this.positionDirectory();
        this.shellDirectory.setLayout((Layout)new FillLayout());
        this.getComposite().getShell().addControlListener((ControlListener)this);
        this.listNameWidget = new SortedList((Composite)this.shellDirectory, 516, 1);
        this.listNameWidget.addSelectionListener((SelectionListener)this);
        this.listNameWidget.addKeyListener((KeyListener)this);
        this.listNameWidget.addTraverseListener((TraverseListener)this);
        Vector nameSurname = this.phoneBookDataBase.getSurnameNameVector();
        int i = 0;
        while (i < nameSurname.size()) {
            this.listNameWidget.add((String)nameSurname.get(i));
            ++i;
        }
        this.shellDetails = new Shell(this.getComposite().getShell(), 2080);
        this.detailsOpened = false;
        this.shellDetails.setText(Messages.getString("PhoneBookShowCase.3"));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.shellDetails.setLayout((Layout)rowLayout);
        CaptionedControl detailCapc1 = new CaptionedControl((Composite)this.shellDetails, 0);
        this.detailOrganization = new Text((Composite)detailCapc1, 8);
        detailCapc1.setText(Messages.getString("PhoneBookShowCase.4"));
        CaptionedControl detailCapc2 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailPosition = new Text((Composite)detailCapc2, 8);
        detailCapc2.setText(Messages.getString("PhoneBookShowCase.5"));
        CaptionedControl detailCapc3 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailPhone = new HyperLink((Composite)detailCapc3, 0, 4);
        detailCapc3.setText(Messages.getString("PhoneBookShowCase.6"));
        this.detailPhone.addKeyListener((KeyListener)this);
        CaptionedControl detailCapc4 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailMobile = new HyperLink((Composite)detailCapc4, 0, 4);
        detailCapc4.setText(Messages.getString("PhoneBookShowCase.7"));
        this.detailMobile.addKeyListener((KeyListener)this);
        CaptionedControl detailCapc5 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailEmail = new HyperLink((Composite)detailCapc5, 0, 2);
        detailCapc5.setText(Messages.getString("PhoneBookShowCase.8"));
        this.detailEmail.addKeyListener((KeyListener)this);
        Composite parentComposite = this.getComposite();
        this.entryScrollScreen = new ScrolledComposite(parentComposite, 512);
        this.entryScrollScreen.setLayout((Layout)new FormLayout());
        this.entryScrollScreen.setBounds(parentComposite.getClientArea());
        this.entryScreen = new Composite((Composite)this.entryScrollScreen, 0);
        Rectangle clientArea = this.entryScrollScreen.getClientArea();
        this.entryScreen.setSize(clientArea.width, clientArea.height);
        Vector<CaptionedControl> captionList = new Vector<CaptionedControl>();
        CaptionedControl entryCapc1 = new CaptionedControl(this.entryScreen, 0x2000800);
        entryCapc1.setText(Messages.getString("PhoneBookShowCase.9"));
        this.entryLastName = new Text((Composite)entryCapc1, 2048);
        this.entryLastName.addModifyListener((ModifyListener)this);
        captionList.add(entryCapc1);
        CaptionedControl entryCapc2 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc2.setText(Messages.getString("PhoneBookShowCase.10"));
        this.entryFirstName = new Text((Composite)entryCapc2, 2048);
        this.entryFirstName.addModifyListener((ModifyListener)this);
        captionList.add(entryCapc2);
        CaptionedControl entryCapc3 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc3.setText(Messages.getString("PhoneBookShowCase.11"));
        this.entryCompany = new Text((Composite)entryCapc3, 2048);
        captionList.add(entryCapc3);
        CaptionedControl entryCapc4 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc4.setText(Messages.getString("PhoneBookShowCase.12"));
        this.entryJob = new Text((Composite)entryCapc4, 2048);
        captionList.add(entryCapc4);
        CaptionedControl entryCapc5 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc5.setText(Messages.getString("PhoneBookShowCase.13"));
        this.entryTelephone = new ConstrainedText((Composite)entryCapc5, 2048, 4);
        captionList.add(entryCapc5);
        CaptionedControl entryCapc6 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc6.setText(Messages.getString("PhoneBookShowCase.14"));
        this.entryMobile = new ConstrainedText((Composite)entryCapc6, 2048, 4);
        captionList.add(entryCapc6);
        CaptionedControl entryCapc7 = new CaptionedControl(this.entryScreen, 0x2000000);
        entryCapc7.setText(Messages.getString("PhoneBookShowCase.15"));
        this.entryEMail = new TextExtension((Composite)entryCapc7, 2048, 2);
        captionList.add(entryCapc7);
        Point entryCapSize = entryCapc1.computeSize(this.entryScreen.getClientArea().width, -1);
        Point entryCapPos = new Point(0, 0);
        int margin = 2;
        int i2 = 0;
        while (i2 < captionList.size()) {
            CaptionedControl caption = (CaptionedControl)captionList.elementAt(i2);
            caption.setBounds(entryCapPos.x, entryCapPos.y, entryCapSize.x, entryCapSize.y);
            entryCapPos.y += entryCapSize.y + margin;
            ++i2;
        }
        this.entryScreen.setSize(clientArea.width, entryCapPos.y);
        this.entryScrollScreen.setContent((Control)this.entryScreen);
        this.entryScrollScreen.setAutoScroll(true);
        this.entryScrollScreen.setVisible(false);
        this.commandNew = new Command((Control)this.shellDirectory, 1, 3);
        this.commandNew.setText(Messages.getString("PhoneBookShowCase.16"));
        this.commandNew.addSelectionListener((SelectionListener)this);
        this.commandDelete = new Command((Control)this.shellDirectory, 1, 2);
        this.commandDelete.setText(Messages.getString("PhoneBookShowCase.17"));
        this.commandDelete.addSelectionListener((SelectionListener)this);
        this.commandExitDirectory = new Command((Control)this.shellDirectory, 7, 1);
        this.commandExitDirectory.setText(Messages.getString("PhoneBookShowCase.18"));
        this.commandExitDirectory.setLongLabel(Messages.getString("PhoneBookShowCase.19"));
        this.commandExitDirectory.addSelectionListener((SelectionListener)this);
        this.commandEdit = new Command((Control)this.shellDirectory, 2, 4);
        this.commandEdit.setText(Messages.getString("PhoneBookShowCase.20"));
        this.commandEdit.addSelectionListener((SelectionListener)this);
        this.commandEntryScreenDone = new Command((Control)this.entryScreen, 7, 0);
        this.commandEntryScreenDone.setText(Messages.getString("PhoneBookShowCase.21"));
        this.commandEntryScreenDone.addSelectionListener((SelectionListener)this);
        this.addKeyListenerToAllChildren((Composite)this.shellDirectory, this);
        this.addKeyListenerToAllChildren((Composite)this.shellDetails, this);
        this.setOrientation();
        this.shellDirectory.layout();
        this.shellDirectory.open();
        this.updateSelectedDetail();
        MobileDevice md = MobileDevice.getMobileDevice();
        this.screens = md.getScreens();
        this.rotationListener = new RotationListener();
        this.screens[0].addEventListener((ScreenListener)this.rotationListener);
    }

    void setOrientation() {
        if (this.landscape) {
            if (!this.detailsOpened) {
                this.detailsOpened = true;
                this.positionDetails();
                this.shellDetails.open();
            }
            this.shellDetails.setVisible(true);
            this.commandExitDetails = new Command((Control)this.shellDetails, 7, 0);
            this.commandExitDetails.setText(Messages.getString("PhoneBookShowCase.22"));
            this.commandExitDetails.setLongLabel(Messages.getString("PhoneBookShowCase.23"));
            this.commandExitDetails.addSelectionListener((SelectionListener)this);
            if (this.commandBackDetails != null) {
                this.commandBackDetails.dispose();
                this.commandBackDetails = null;
            }
        } else {
            this.commandBackDetails = new Command((Control)this.shellDetails, 7, 0);
            this.commandBackDetails.setText(Messages.getString("PhoneBookShowCase.24"));
            this.commandBackDetails.addSelectionListener((SelectionListener)this);
            if (this.commandExitDetails != null) {
                this.commandExitDetails.dispose();
                this.commandExitDetails = null;
            }
        }
    }

    boolean addEntry(PhoneBookEntry entry) {
        boolean isAdded = false;
        if (this.phoneBookDataBase.getEntryWithSurnameAndName(entry.getSurnameAndName()) == null) {
            this.phoneBookDataBase.addEntry(entry);
            this.listNameWidget.add(entry.getSurnameAndName());
            isAdded = true;
        }
        return isAdded;
    }

    void removeEntry(String key) {
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(key);
        this.phoneBookDataBase.removeEntry(phoneBookEntry);
        this.listNameWidget.remove(key);
    }

    void showEntryScreen() {
        if (this.listNameWidget.getSelectionCount() == 0) {
            return;
        }
        String selection = this.listNameWidget.getSelection()[0];
        PhoneBookEntry entry = this.phoneBookDataBase.getEntryWithSurnameAndName(selection);
        this.getComposite().getShell().setText(selection);
        this.entryLastName.setText(entry.getSurName());
        this.entryFirstName.setText(entry.getName());
        this.entryCompany.setText(entry.get0rganization());
        this.entryJob.setText(entry.getPosition());
        this.entryTelephone.setText(entry.getPhone());
        this.entryMobile.setText(entry.getMobilePhone());
        this.entryEMail.setText(entry.getEmail());
        this.shellDetails.setVisible(false);
        this.shellDirectory.setVisible(false);
        this.entryScrollScreen.setVisible(true);
        this.entryScreen.setVisible(true);
        if (!this.entryLastName.isFocusControl()) {
            this.entryLastName.setFocus();
        } else {
            this.entryFirstName.setFocus();
        }
    }

    void hideEntryScreen() {
        String selection = this.listNameWidget.getSelection()[0];
        PhoneBookEntry entry = this.phoneBookDataBase.getEntryWithSurnameAndName(selection);
        this.listNameWidget.remove(entry.getSurnameAndName());
        entry.setSurName(this.entryLastName.getText());
        entry.setName(this.entryFirstName.getText());
        entry.set0rganization(this.entryCompany.getText());
        entry.setPosition(this.entryJob.getText());
        entry.setPhone(this.entryTelephone.getText());
        entry.setMobilePhone(this.entryMobile.getText());
        entry.setEmail(this.entryEMail.getText());
        this.phoneBookDataBase.update();
        this.listNameWidget.add(entry.getSurnameAndName());
        this.listNameWidget.select(entry.getSurnameAndName());
        this.updateSelectedDetail();
        this.getComposite().getShell().setText(this.getName());
        this.entryScrollScreen.setVisible(false);
        this.entryScreen.setVisible(false);
        this.shellDetails.setVisible(this.landscape);
        this.shellDirectory.setVisible(true);
        this.shellDirectory.forceActive();
        this.listNameWidget.showSelection();
        this.listNameWidget.forceFocus();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.listNameWidget) {
            this.updateSelectedDetail();
            this.setFocusOnDetails(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandExitDirectory || e.widget == this.commandExitDetails) {
            this.quit();
        } else if (e.widget == this.commandEdit) {
            this.showEntryScreen();
        } else if (e.widget == this.commandDelete) {
            if (this.listNameWidget.getSelectionCount() > 0) {
                MessageBox box = new MessageBox(this.getComposite().getShell(), 292);
                box.setMessage(Messages.getString("PhoneBookShowCase.25"));
                if (box.open() == 32) {
                    this.removeEntry(this.listNameWidget.getSelection()[0]);
                    this.updateSelectedDetail();
                }
                this.listNameWidget.setFocus();
            }
        } else if (e.widget == this.commandNew) {
            PhoneBookEntry newentry = new PhoneBookEntry("", "", "", "", "0", "", "", "");
            if (this.addEntry(newentry)) {
                this.listNameWidget.select(Messages.getString("PhoneBookShowCase.34"));
                this.listNameWidget.showSelection();
                this.showEntryScreen();
            }
        } else if (e.widget == this.listNameWidget) {
            this.updateSelectedDetail();
        } else if (e.widget == this.commandEntryScreenDone) {
            this.hideEntryScreen();
        } else if (e.widget == this.commandBackDetails) {
            this.setFocusOnDetails(false);
        }
    }

    public void quit() {
        this.screens[0].removeEventListener((ScreenListener)this.rotationListener);
        this.getComposite().getShell().removeControlListener((ControlListener)this);
        if (this.background != null) {
            this.background.dispose();
            this.background = null;
        }
        this.commandExitDirectory.dispose();
        if (this.commandExitDetails != null) {
            this.commandExitDetails.dispose();
        }
        if (this.commandBackDetails != null) {
            this.commandBackDetails.dispose();
        }
        this.commandEdit.dispose();
        this.commandNew.dispose();
        this.commandDelete.dispose();
        this.shellDetails.dispose();
        this.shellDirectory.dispose();
        this.entryScreen.dispose();
        this.entryScrollScreen.dispose();
        this.dispose();
    }

    public void setFocusOnDetails(boolean isVisible) {
        if (this.landscape) {
            if (isVisible) {
                this.shellDetails.setFocus();
            } else {
                this.shellDirectory.setFocus();
            }
        } else if (isVisible) {
            if (!this.detailsOpened) {
                this.detailsOpened = true;
                this.positionDetails();
                this.shellDetails.open();
            }
            this.shellDetails.setVisible(true);
            this.shellDirectory.setVisible(false);
            this.shellDetails.setFocus();
        } else {
            this.shellDirectory.setVisible(true);
            this.shellDetails.setVisible(false);
            this.shellDirectory.setActive();
        }
    }

    private void updateSelectedDetail() {
        if (this.listNameWidget.getSelectionCount() == 0) {
            return;
        }
        PhoneBookEntry entry = this.phoneBookDataBase.getEntryWithSurnameAndName(this.listNameWidget.getSelection()[0]);
        if (entry != null) {
            this.updateDetail(entry);
        }
    }

    private void updateDetail(PhoneBookEntry entry) {
        this.shellDetails.setText(entry.getSurnameAndName());
        if (entry.get0rganization() != "") {
            this.detailOrganization.setVisible(true);
            this.detailOrganization.setText(entry.get0rganization());
        }
        if (entry.getPosition() != "") {
            this.detailPosition.setVisible(true);
            this.detailPosition.setText(entry.getPosition());
        }
        if (entry.getPhone() != "") {
            this.detailPhone.setVisible(true);
            this.detailPhone.setText(entry.getPhone());
        }
        if (entry.getMobilePhone() != "") {
            this.detailMobile.setVisible(true);
            this.detailMobile.setText(entry.getMobilePhone());
        }
        if (entry.getEmail() != "") {
            this.detailEmail.setVisible(true);
            this.detailEmail.setText(entry.getEmail());
        }
        this.shellDetails.layout();
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000004) {
            this.setFocusOnDetails(true);
        } else if (e.keyCode == 0x1000003) {
            this.setFocusOnDetails(false);
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    private void addKeyListenerToAllChildren(Composite parent, KeyListener listener) {
        if (parent != null) {
            Control[] childrens = parent.getChildren();
            int i = 0;
            while (i < childrens.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(childrens[i].getClass())) {
                    this.addKeyListenerToAllChildren((Composite)childrens[i], this);
                } else {
                    childrens[i].addKeyListener(listener);
                }
                ++i;
            }
        }
    }

    private void addTraverseListenerToAllChildren(Composite parent, TraverseListener listener) {
        if (parent != null) {
            Control[] childrens = parent.getChildren();
            int i = 0;
            while (i < childrens.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(childrens[i].getClass())) {
                    this.addTraverseListenerToAllChildren((Composite)childrens[i], this);
                } else {
                    childrens[i].addTraverseListener(listener);
                }
                ++i;
            }
        }
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.character == '\u001b' && ((Control)e.widget).getShell() == this.shellDetails) {
            e.doit = false;
        } else if (e.doit && e.widget == this.shellDetails) {
            this.setFocusOnDetails(true);
        } else if (e.doit && e.widget == this.listNameWidget) {
            this.updateSelectedDetail();
            this.setFocusOnDetails(true);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.entryFirstName || e.widget == this.entryLastName) {
            if (this.entryLastName.getText() != "" && this.entryFirstName.getText() != "") {
                this.getComposite().getShell().setText(String.valueOf(this.entryLastName.getText()) + ", " + this.entryFirstName.getText());
            } else if (this.entryLastName.getText() == "" && this.entryFirstName.getText() != "") {
                this.getComposite().getShell().setText(this.entryFirstName.getText());
            } else if (this.entryLastName.getText() != "" && this.entryFirstName.getText() == "") {
                this.getComposite().getShell().setText(this.entryLastName.getText());
            } else if (this.entryLastName.getText() == "" && this.entryFirstName.getText() == "") {
                this.getComposite().getShell().setText(Messages.getString("PhoneBookShowCase.49"));
            }
        }
    }

    public class RotationListener
    implements ScreenListener {
        public void screenActivated(ScreenEvent event) {
        }

        public void screenDeactivated(ScreenEvent event) {
        }

        public void screenOrientationChanged(ScreenEvent event) {
            PhoneBookShowCase.this.landscape = event.orientation == 1;
            PhoneBookShowCase.this.setOrientation();
            PhoneBookShowCase.this.positionDirectory();
            PhoneBookShowCase.this.positionDetails();
        }
    }
}

