/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Tree;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.QueryDialog;
import org.eclipse.ercp.swt.mobile.TimedMessageBox;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeShowCase
extends ShowCase
implements KeyListener,
SelectionListener {
    static final int ROOT = 0;
    static final int NODE = 1;
    static final int LEAVE = 2;
    static final int TREE = 3;
    static final String[] itemText = new String[]{Messages.getString("TreeShowCase.0"), Messages.getString("TreeShowCase.1"), Messages.getString("TreeShowCase.2")};
    private Vector itemType;
    private Vector itemsInTree;
    private boolean overlapped = false;
    private Shell shell;
    private Display display;
    private Tree tree;
    private Command commandExit;
    private Command commandRemove;
    private Command commandAdd;
    private Command commandLabel;
    private Image imageRoot;
    private Image imageNode;
    private Image imageLeave;
    private ImageData rootImageData;
    private ImageData nodeImageData;
    private ImageData leaveImageData;

    public String getName() {
        return Messages.getString("TreeShowCase.3");
    }

    private void quit() {
        this.shell.dispose();
        this.imageRoot.dispose();
        this.imageNode.dispose();
        this.imageLeave.dispose();
        super.dispose();
    }

    protected void show() {
        this.shell = new Shell(this.getComposite().getShell(), 2080);
        this.shell.setBounds(this.getComposite().getShell().getBounds());
        this.shell.setText(Messages.getString("TreeShowCase.4"));
        this.display = this.getComposite().getShell().getDisplay();
        this.commandLabel = new Command((Control)this.shell, 1, 1);
        this.commandLabel.setText(Messages.getString("TreeShowCase.5"));
        this.commandLabel.addSelectionListener((SelectionListener)this);
        this.commandAdd = new Command((Control)this.shell, 1, 1);
        this.commandAdd.setText(Messages.getString("TreeShowCase.6"));
        this.commandAdd.addSelectionListener((SelectionListener)this);
        this.commandRemove = new Command((Control)this.shell, 1, 1);
        this.commandRemove.setText(Messages.getString("TreeShowCase.7"));
        this.commandRemove.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.shell, 7, 1);
        this.commandExit.setText(Messages.getString("TreeShowCase.8"));
        this.commandExit.setLongLabel(Messages.getString("TreeShowCase.9"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.tree = new Tree((Composite)this.shell, 2820);
        this.rootImageData = new ImageData(this.getClass().getResourceAsStream("/res/folderRoot.png"));
        this.nodeImageData = new ImageData(this.getClass().getResourceAsStream("/res/folder.png"));
        this.leaveImageData = new ImageData(this.getClass().getResourceAsStream("/res/file.png"));
        if (this.display.getDPI().equals((Object)new Point(192, 192))) {
            this.rootImageData = this.rootImageData.scaledTo(32, 32);
            this.nodeImageData = this.nodeImageData.scaledTo(32, 32);
            this.leaveImageData = this.leaveImageData.scaledTo(32, 32);
        }
        this.imageRoot = new Image((Device)this.display, this.rootImageData);
        this.imageNode = new Image((Device)this.display, this.nodeImageData);
        this.imageLeave = new Image((Device)this.display, this.leaveImageData);
        this.resetTree();
        this.tree.addKeyListener((KeyListener)this);
        this.tree.addSelectionListener((SelectionListener)this);
        this.shell.setText(Messages.getString("TreeShowCase.13"));
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
        this.shell.layout();
    }

    private void changeCommands() {
        if (!this.overlapped) {
            this.commandExit.setText(Messages.getString("TreeShowCase.14"));
            this.commandExit.setLongLabel(Messages.getString("TreeShowCase.15"));
            this.commandAdd.setText(Messages.getString("TreeShowCase.16"));
            this.commandRemove.setText(Messages.getString("TreeShowCase.17"));
            this.commandLabel.setText(Messages.getString("TreeShowCase.18"));
        } else {
            this.commandExit.setText(Messages.getString("TreeShowCase.19"));
            this.commandExit.setLongLabel(Messages.getString("TreeShowCase.20"));
            this.commandAdd.setText(Messages.getString("TreeShowCase.29"));
            this.commandRemove.setText(Messages.getString("TreeShowCase.22"));
            this.commandLabel.setText(Messages.getString("TreeShowCase.23"));
        }
    }

    private void ShowResult(String text) {
        TimedMessageBox timedMessageBox = new TimedMessageBox(this.shell);
        timedMessageBox.setText(text);
        timedMessageBox.open();
    }

    private void displayError(String errorText) {
        MessageBox messagebox = new MessageBox(this.shell, 33);
        messagebox.setMessage(errorText);
        messagebox.open();
    }

    private void SetTreeInVectors() {
        if (this.itemsInTree == null) {
            this.itemsInTree = new Vector();
        }
        if (this.itemType == null) {
            this.itemType = new Vector();
        }
        this.itemsInTree.add(0, this.tree);
        this.itemType.add(0, new Integer(3));
    }

    private void removeAndClear() {
        if (this.tree != null) {
            this.tree.removeAll();
        }
        if (this.itemsInTree != null) {
            this.itemsInTree.clear();
        }
        if (this.itemType != null) {
            this.itemType.clear();
        }
    }

    private void resetTree() {
        this.removeAndClear();
        this.SetTreeInVectors();
        TreeItem root = (TreeItem)this.insertItem(this.tree, 0, 1);
        TreeItem node = (TreeItem)this.insertItem(root, 1, 2);
        TreeItem cfr_ignored_0 = (TreeItem)this.insertItem(node, 2, 3);
        TreeItem cfr_ignored_1 = (TreeItem)this.insertItem(node, 2, 4);
        TreeItem cfr_ignored_2 = (TreeItem)this.insertItem(node, 2, 5);
        root = (TreeItem)this.insertItem(this.tree, 0, 6);
        node = (TreeItem)this.insertItem(root, 1, 7);
        node = (TreeItem)this.insertItem(root, 2, 8);
        root = (TreeItem)this.insertItem(this.tree, 0, 9);
        node = (TreeItem)this.insertItem(root, 1, 10);
        node = (TreeItem)this.insertItem(root, 1, 11);
        node = (TreeItem)this.insertItem(node, 1, 12);
        node = (TreeItem)this.insertItem(node, 1, 13);
        TreeItem cfr_ignored_3 = (TreeItem)this.insertItem(node, 2, 14);
    }

    private int findIndexOfItem(Object item) {
        if (this.itemsInTree == null) {
            return -1;
        }
        return this.itemsInTree.indexOf(item);
    }

    private void removeAllItemsFrom(TreeItem start, int startIndex) {
        int index = startIndex + 1;
        block0 : switch ((Integer)this.itemType.get(startIndex)) {
            case 0: {
                index = startIndex + 1;
                while (index < this.itemsInTree.size()) {
                    TreeItem currentParent = ((TreeItem)this.itemsInTree.get(index)).getParentItem();
                    if (currentParent == null) break block0;
                    ++index;
                }
                break;
            }
            case 1: {
                TreeItem parentOfStart = ((TreeItem)this.itemsInTree.get(startIndex)).getParentItem();
                index = startIndex + 1;
                while (index < this.itemsInTree.size()) {
                    TreeItem parentOfCurrent = ((TreeItem)this.itemsInTree.get(index)).getParentItem();
                    if (parentOfStart.equals(parentOfCurrent) || parentOfCurrent == null) break block0;
                    ++index;
                }
                break;
            }
            default: {
                SWT.error((int)6);
            }
        }
        start.dispose();
        int counter = 0;
        while (counter < index - startIndex) {
            this.itemType.removeElementAt(startIndex);
            this.itemsInTree.removeElementAt(startIndex);
            ++counter;
        }
    }

    void removeItem() {
        if (this.tree == null) {
            return;
        }
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 0) {
            this.displayError(Messages.getString("TreeShowCase.24"));
            return;
        }
        int indexofSelected = this.itemsInTree.indexOf(selection[0]);
        switch ((Integer)this.itemType.get(indexofSelected)) {
            case 2: {
                selection[0].dispose();
                this.itemType.removeElementAt(indexofSelected);
                this.itemsInTree.removeElementAt(indexofSelected);
                break;
            }
            case 0: {
                this.removeAllItemsFrom(selection[0], indexofSelected);
                break;
            }
            case 1: {
                this.removeAllItemsFrom(selection[0], indexofSelected);
            }
        }
        if (this.tree.getItemCount() != 0) {
            TreeItem[] newSelection = indexofSelected != 1 ? new TreeItem[]{(TreeItem)this.itemsInTree.get(indexofSelected - 1)} : new TreeItem[]{(TreeItem)this.itemsInTree.get(1)};
            this.tree.setSelection(newSelection);
            this.tree.showSelection();
        }
    }

    private void add(int type) {
        if (this.tree == null) {
            return;
        }
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 0 && this.tree.getItemCount() != 0) {
            this.displayError(Messages.getString("TreeShowCase.25"));
            return;
        }
        int indexOfSelected = 0;
        if (this.tree.getItemCount() != 0) {
            indexOfSelected = this.itemsInTree.indexOf(selection[0]);
            int typeSelected = (Integer)this.itemType.get(indexOfSelected);
            if (typeSelected == 2 && type == 2 || typeSelected == 2 && type == 1 || typeSelected == 1 && type == 0) {
                this.displayError(Messages.getString("TreeShowCase.26"));
                return;
            }
        } else if (type != 0) {
            this.displayError(Messages.getString("TreeShowCase.27"));
            return;
        }
        TreeItem newItem = null;
        switch (type) {
            case 0: {
                int rankOfnew = 0;
                int indexOfNewInVector = 1;
                String label = this.changeLabel(itemText[0]);
                if (label == null) break;
                if (this.tree.getItemCount() == 0) {
                    newItem = new TreeItem(this.tree, 2048);
                } else {
                    rankOfnew = this.rankUnderRoot(indexOfSelected);
                    indexOfNewInVector = this.findIndexOfNextItemUnderRoot(indexOfSelected);
                    newItem = new TreeItem(this.tree, 2048, rankOfnew);
                }
                newItem.setImage(this.imageRoot);
                newItem.setText(label);
                this.itemsInTree.insertElementAt(newItem, indexOfNewInVector);
                this.itemType.insertElementAt(new Integer(0), indexOfNewInVector);
                break;
            }
            case 1: {
                Object parent = this.itemsInTree.get(indexOfSelected);
                String label = this.changeLabel(itemText[1]);
                if (label == null) break;
                newItem = new TreeItem((TreeItem)parent, 2048, 0);
                newItem.setImage(this.imageNode);
                newItem.setText(label);
                this.itemsInTree.insertElementAt(newItem, indexOfSelected + 1);
                this.itemType.insertElementAt(new Integer(1), indexOfSelected + 1);
                break;
            }
            case 2: {
                Object parent = this.itemsInTree.get(indexOfSelected);
                String label = this.changeLabel(itemText[2]);
                if (label == null) break;
                newItem = new TreeItem((TreeItem)parent, 2048, 0);
                newItem.setImage(this.imageLeave);
                newItem.setText(label);
                this.itemsInTree.insertElementAt(newItem, indexOfSelected + 1);
                this.itemType.insertElementAt(new Integer(2), indexOfSelected + 1);
            }
        }
        this.tree.setSelection(new TreeItem[]{newItem});
        this.tree.showSelection();
    }

    private int findRootOfItemIndex(int current) {
        if ((Integer)this.itemType.get(current) == 0) {
            return current;
        }
        int index = current - 1;
        while (index > 0) {
            if ((Integer)this.itemType.get(current) == 0) {
                return index;
            }
            --index;
        }
        return -1;
    }

    int findIndexOfNextItemUnderRoot(int current) {
        int index = current + 1;
        while (index < this.itemType.size()) {
            if (((TreeItem)this.itemsInTree.get(current)).getParentItem() == null) break;
            ++current;
        }
        return index;
    }

    private void changeLabel() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 0) {
            return;
        }
        String newLabel = this.changeLabel(selection[0].getText());
        if (newLabel != null) {
            selection[0].setText(newLabel);
        }
    }

    private String changeLabel(String label) {
        QueryDialog queryD = new QueryDialog(this.shell, 65536);
        queryD.setMaximum(15);
        queryD.setPromptText(Messages.getString("TreeShowCase.28"), label);
        String result = queryD.open();
        return result;
    }

    private int rankUnderRoot(int start) {
        int result = 0;
        int index = start;
        while (index > 0) {
            if (((TreeItem)this.itemsInTree.get(index)).getParentItem() == null) {
                ++result;
            }
            --index;
        }
        return result;
    }

    private int nodeRank(int start) {
        int result = 0;
        TreeItem parent = ((TreeItem)this.itemsInTree.get(start)).getParentItem();
        int index = start;
        while (index > 0) {
            if (parent.equals((TreeItem)this.itemsInTree.get(index))) break;
            ++result;
            --index;
        }
        return result;
    }

    private int leaveRank(int start) {
        int result = 1;
        if (((TreeItem)this.itemsInTree.get(start)).getParentItem() == null) {
            return this.rankUnderRoot(start);
        }
        int index = start - 1;
        while (index > 0) {
            int type = (Integer)this.itemType.get(index);
            if (type == 0 || type == 1) break;
            if ((Integer)this.itemType.get(index) == 1) {
                ++result;
            }
            --index;
        }
        return result;
    }

    private Object insertItem(Object parent, int type, int itemIndex) {
        TreeItem newItem = parent.equals(this.tree) ? new TreeItem((Tree)parent, 2048) : new TreeItem((TreeItem)parent, 2048);
        switch (type) {
            case 0: {
                newItem.setImage(this.imageRoot);
                newItem.setText(itemText[0]);
                break;
            }
            case 1: {
                newItem.setImage(this.imageNode);
                newItem.setText(itemText[1]);
                break;
            }
            case 2: {
                newItem.setImage(this.imageLeave);
                newItem.setText(itemText[2]);
                break;
            }
            default: {
                newItem.setImage(this.imageLeave);
                newItem.setText(itemText[2]);
                type = 2;
            }
        }
        this.itemsInTree.add(itemIndex, newItem);
        this.itemType.add(itemIndex, new Integer(type));
        return newItem;
    }

    private void cancel() {
        this.overlapped = false;
        this.changeCommands();
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (e.widget != this.tree) {
                if (e.widget == this.commandLabel) {
                    if (this.overlapped) {
                        this.add(0);
                    } else {
                        this.changeLabel();
                    }
                } else if (e.widget == this.commandAdd) {
                    if (this.overlapped) {
                        this.add(1);
                    } else {
                        this.overlapped = true;
                        this.changeCommands();
                    }
                } else if (e.widget == this.commandRemove) {
                    if (this.overlapped) {
                        this.add(2);
                    } else {
                        this.removeItem();
                    }
                } else if (e.widget == this.commandExit) {
                    if (this.overlapped) {
                        this.cancel();
                    } else {
                        this.quit();
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

