/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public class EclipseDebugTrace
implements DebugTrace {
    public static final String PROP_TRACE_SIZE_MAX = "eclipse.trace.size.max";
    public static final String PROP_TRACE_FILE_MAX = "eclipse.trace.backup.max";
    protected static final String MESSAGE_THREAD_DUMP = "Thread Stack dump: ";
    protected static final String MESSAGE_EXIT_METHOD_WITH_RESULTS = "Exiting method with result: ";
    protected static final String MESSAGE_EXIT_METHOD_NO_RESULTS = "Exiting method with a void return";
    protected static final String MESSAGE_ENTER_METHOD_WITH_PARAMS = "Entering method with parameters: (";
    protected static final String MESSAGE_ENTER_METHOD_NO_PARAMS = "Entering method with no parameters";
    protected static final String TRACE_FILE_VERSION_COMMENT = "version: ";
    protected static final String TRACE_FILE_VERSION = "1.0";
    protected static final String TRACE_NEW_SESSION = "!SESSION ";
    protected static final String TRACE_FILE_DATE = "Time of creation: ";
    protected static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final String TRACE_COMMENT = "#";
    protected static final String TRACE_ELEMENT_DELIMITER = "|";
    protected static final String LINE_SEPARATOR;
    public static final String NULL_VALUE = "<null>";
    private static final SecureAction secureAction;
    protected static final Object writeLock;
    public static final int DEFAULT_TRACE_FILE_SIZE = 1000;
    public static final int DEFAULT_TRACE_FILES = 10;
    public static final int DEFAULT_TRACE_FILE_MIN_SIZE = 10;
    public static final String TRACE_FILE_EXTENSION = ".trace";
    public static final String BACKUP_MARK = ".bak_";
    protected int maxTraceFileSize = 1000;
    protected int maxTraceFiles = 10;
    protected int backupTraceFileIndex = 0;
    protected Class traceClass = null;
    protected String bundleSymbolicName = null;
    protected static boolean newSession;
    protected DebugOptions debugOptions = null;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
        secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
        writeLock = new Object();
        newSession = true;
    }

    public EclipseDebugTrace(String bundleSymbolicName, DebugOptions debugOptions) {
        this(bundleSymbolicName, debugOptions, null);
    }

    public EclipseDebugTrace(String bundleSymbolicName, DebugOptions debugOptions, Class traceClass) {
        this.traceClass = traceClass;
        this.debugOptions = debugOptions;
        this.bundleSymbolicName = bundleSymbolicName;
        this.readLogProperties();
    }

    protected final boolean isDebuggingEnabled(String optionPath) {
        if (optionPath == null) {
            return true;
        }
        boolean debugEnabled = false;
        if (this.debugOptions.isDebugEnabled()) {
            String option = String.valueOf(this.bundleSymbolicName) + optionPath;
            debugEnabled = this.debugOptions.getBooleanOption(option, false);
        }
        return debugEnabled;
    }

    public void trace(String optionPath, String message) {
        if (this.isDebuggingEnabled(optionPath)) {
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, message, this.traceClass);
            this.writeRecord(record);
        }
    }

    public void trace(String optionPath, String message, Throwable error) {
        if (this.isDebuggingEnabled(optionPath)) {
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, message, error, this.traceClass);
            this.writeRecord(record);
        }
    }

    public void traceEntry(String optionPath) {
        if (this.isDebuggingEnabled(optionPath)) {
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, MESSAGE_ENTER_METHOD_NO_PARAMS, this.traceClass);
            this.writeRecord(record);
        }
    }

    public void traceEntry(String optionPath, Object methodArgument) {
        if (this.isDebuggingEnabled(optionPath)) {
            this.traceEntry(optionPath, new Object[]{methodArgument});
        }
    }

    public void traceEntry(String optionPath, Object[] methodArguments) {
        if (this.isDebuggingEnabled(optionPath)) {
            StringBuffer messageBuffer = new StringBuffer(MESSAGE_ENTER_METHOD_WITH_PARAMS);
            if (methodArguments != null) {
                int i = 0;
                while (i < methodArguments.length) {
                    if (methodArguments[i] != null) {
                        messageBuffer.append(methodArguments[i].toString());
                    } else {
                        messageBuffer.append(NULL_VALUE);
                    }
                    messageBuffer.append(" ");
                    ++i;
                }
                messageBuffer.append(")");
            }
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, messageBuffer.toString(), this.traceClass);
            this.writeRecord(record);
        }
    }

    public void traceExit(String optionPath) {
        if (this.isDebuggingEnabled(optionPath)) {
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, MESSAGE_EXIT_METHOD_NO_RESULTS, this.traceClass);
            this.writeRecord(record);
        }
    }

    public void traceExit(String optionPath, Object result) {
        if (this.isDebuggingEnabled(optionPath)) {
            StringBuffer messageBuffer = new StringBuffer(MESSAGE_EXIT_METHOD_WITH_RESULTS);
            if (result == null) {
                messageBuffer.append(NULL_VALUE);
            } else {
                messageBuffer.append(result.toString());
            }
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, messageBuffer.toString(), this.traceClass);
            this.writeRecord(record);
        }
    }

    public void traceDumpStack(String optionPath) {
        if (this.isDebuggingEnabled(optionPath)) {
            StringBuffer messageBuffer = new StringBuffer(MESSAGE_THREAD_DUMP);
            StackTraceElement[] elements = new Exception().getStackTrace();
            int firstIndex = this.traceClass == null ? 1 : 2;
            int endIndex = elements.length - firstIndex;
            StackTraceElement[] newElements = new StackTraceElement[endIndex];
            int i = 0;
            while (i < endIndex) {
                newElements[i] = elements[firstIndex];
                ++i;
                ++firstIndex;
            }
            messageBuffer.append(this.convertStackTraceElementsToString(newElements));
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, messageBuffer.toString(), this.traceClass);
            this.writeRecord(record);
        }
    }

    protected final String convertStackTraceElementsToString(StackTraceElement[] elements) {
        StringBuffer buffer = new StringBuffer();
        if (elements != null) {
            buffer.append("java.lang.Throwable: ");
            buffer.append(LINE_SEPARATOR);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] != null) {
                    buffer.append("\tat ");
                    buffer.append(elements[i].toString());
                    buffer.append(LINE_SEPARATOR);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeRecord(FrameworkDebugTraceEntry entry) {
        if (entry == null) return;
        Object object = writeLock;
        synchronized (object) {
            File tracingFile = this.debugOptions.getFile();
            Writer traceWriter = null;
            try {
                try {
                    this.checkTraceFileSize(tracingFile);
                    traceWriter = this.openWriter(tracingFile);
                    if (newSession) {
                        this.writeSession(traceWriter);
                        newSession = false;
                    }
                    this.writeMessage(traceWriter, entry);
                    traceWriter.flush();
                }
                catch (Exception ex) {
                    System.err.println("An exception occurred while writing to the platform trace file: ");
                    ex.printStackTrace(System.err);
                }
                Object var6_8 = null;
                if (tracingFile == null) return;
                this.closeWriter(traceWriter);
                return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (tracingFile == null) throw throwable;
                this.closeWriter(traceWriter);
                throw throwable;
            }
        }
    }

    protected void readLogProperties() {
        String newMaxLogFiles;
        String newMaxTraceFileSize = secureAction.getProperty(PROP_TRACE_SIZE_MAX);
        if (newMaxTraceFileSize != null) {
            this.maxTraceFileSize = Integer.parseInt(newMaxTraceFileSize);
            if (this.maxTraceFileSize != 0 && this.maxTraceFileSize < 10) {
                this.maxTraceFileSize = 10;
            }
        }
        if ((newMaxLogFiles = secureAction.getProperty(PROP_TRACE_FILE_MAX)) != null) {
            this.maxTraceFiles = Integer.parseInt(newMaxLogFiles);
            if (this.maxTraceFiles < 1) {
                this.maxTraceFiles = 10;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkTraceFileSize(File traceFile) {
        boolean isBackupOK = true;
        if (this.maxTraceFileSize > 0 && traceFile != null && traceFile.exists() && traceFile.length() >> 10 > (long)this.maxTraceFileSize) {
            boolean isRenameOK;
            String traceFileName = traceFile.getAbsolutePath();
            String backupFilename = "";
            backupFilename = traceFileName.toLowerCase().endsWith(TRACE_FILE_EXTENSION) ? String.valueOf(traceFileName.substring(0, traceFileName.length() - TRACE_FILE_EXTENSION.length())) + BACKUP_MARK + this.backupTraceFileIndex + TRACE_FILE_EXTENSION : String.valueOf(traceFileName) + BACKUP_MARK + this.backupTraceFileIndex;
            File backupFile = new File(backupFilename);
            if (backupFile.exists() && !backupFile.delete()) {
                System.err.println("Error when trying to delete old trace file: " + backupFile.getName());
                if (backupFile.renameTo(new File(String.valueOf(backupFile.getAbsolutePath()) + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + backupFile.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    isBackupOK = false;
                }
            }
            if (!(isRenameOK = traceFile.renameTo(backupFile))) {
                System.err.println("Error when trying to rename trace file to backup one.");
                isBackupOK = false;
            }
            Writer traceWriter = null;
            try {
                try {
                    traceWriter = this.openWriter(traceFile);
                    this.writeComment(traceWriter, "This is a continuation of trace file " + backupFile.getAbsolutePath());
                    this.writeComment(traceWriter, TRACE_FILE_DATE + TRACE_FILE_DATE_FORMATTER.format(new Date(System.currentTimeMillis())));
                    traceWriter.flush();
                }
                catch (IOException ioEx) {
                    ioEx.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (traceFile != null) {
                    this.closeWriter(traceWriter);
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (traceFile != null) {
                    this.closeWriter(traceWriter);
                }
                ++this.backupTraceFileIndex;
                this.backupTraceFileIndex %= this.maxTraceFiles;
            }
        }
        return isBackupOK;
    }

    protected void writeComment(Writer traceWriter, String comment) throws IOException {
        StringBuffer commentText = new StringBuffer(TRACE_COMMENT);
        commentText.append(" ");
        commentText.append(comment);
        commentText.append(LINE_SEPARATOR);
        traceWriter.write(commentText.toString());
    }

    protected final String getFormattedDate() {
        return this.getFormattedDate(System.currentTimeMillis());
    }

    protected final String getFormattedDate(long timestamp) {
        return TRACE_FILE_DATE_FORMATTER.format(new Date(timestamp));
    }

    protected void writeSession(Writer traceWriter) throws IOException {
        this.writeComment(traceWriter, TRACE_NEW_SESSION + this.getFormattedDate());
        this.writeComment(traceWriter, "version: 1.0");
        this.writeComment(traceWriter, "The following option strings are specified for this debug session:");
        String[] allOptions = FrameworkDebugOptions.getDefault().getAllOptions();
        int i = 0;
        while (i < allOptions.length) {
            this.writeComment(traceWriter, "\t" + allOptions[i]);
            ++i;
        }
    }

    protected void writeMessage(Writer traceWriter, FrameworkDebugTraceEntry entry) throws IOException {
        StringBuffer message = new StringBuffer(entry.getThreadName());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(this.getFormattedDate(entry.getTimestamp()));
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getBundleSymbolicName());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getOptionPath());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getClassName());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getMethodName());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getLineNumber());
        message.append(" ");
        message.append(TRACE_ELEMENT_DELIMITER);
        message.append(" ");
        message.append(entry.getMessage());
        if (entry.getThrowable() != null) {
            message.append(TRACE_ELEMENT_DELIMITER);
            message.append(" ");
            message.append(entry.getThrowable());
        }
        message.append(LINE_SEPARATOR);
        if (traceWriter != null && message != null) {
            traceWriter.write(message.toString());
        }
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    protected Writer openWriter(File traceFile) {
        Writer traceWriter = null;
        if (traceFile != null) {
            try {
                traceWriter = this.logForStream(secureAction.getFileOutputStream(traceFile, true));
            }
            catch (IOException iOException) {
                traceWriter = this.logForStream(System.out);
            }
        } else {
            traceWriter = this.logForStream(System.out);
        }
        return traceWriter;
    }

    protected void closeWriter(Writer traceWriter) {
        if (traceWriter != null) {
            try {
                traceWriter.close();
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            traceWriter = null;
        }
    }
}

