/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.EclipseDebugTrace;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer {
    private static final String OSGI_DEBUG = "osgi.debug";
    public static final String PROP_TRACEFILE = "osgi.tracefile";
    private Properties options = null;
    private static FrameworkDebugOptions singleton = null;
    private static final String OPTIONS = ".options";
    protected static final Map debugTraceCache = new HashMap();
    protected File outFile = null;
    private volatile BundleContext context;
    private volatile ServiceTracker listenerTracker;
    static /* synthetic */ Class class$0;

    private FrameworkDebugOptions() {
        this.loadOptions();
    }

    public void start(BundleContext bc) {
        this.context = bc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(bc, clazz.getName(), (ServiceTrackerCustomizer)this);
        this.listenerTracker.open();
    }

    public void stop(BundleContext bc) {
        this.listenerTracker.close();
        this.listenerTracker = null;
        this.context = null;
    }

    public static FrameworkDebugOptions getDefault() {
        if (singleton == null) {
            singleton = new FrameworkDebugOptions();
        }
        return singleton;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null && optionValue.equalsIgnoreCase("true") || defaultValue;
    }

    public String[] getOptionsForBundle(String bundleName) {
        List<String> optionsList = null;
        if (this.options != null) {
            optionsList = new ArrayList();
            Iterator<Map.Entry<Object, Object>> entrySetIterator = this.options.entrySet().iterator();
            int i = 0;
            String key = null;
            while (entrySetIterator.hasNext()) {
                int firstOptionPathIndex;
                Map.Entry<Object, Object> entry = entrySetIterator.next();
                key = (String)entry.getKey();
                if (!key.substring(0, firstOptionPathIndex = key.indexOf("/")).equals(bundleName)) continue;
                optionsList.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                ++i;
            }
        }
        if (optionsList == null) {
            optionsList = Collections.EMPTY_LIST;
        }
        String[] optionsArray = optionsList.toArray(new String[optionsList.size()]);
        return optionsArray;
    }

    public String getOption(String option) {
        return this.options != null ? this.options.getProperty(option) : null;
    }

    public String getOption(String option, String defaultValue) {
        return this.options != null ? this.options.getProperty(option, defaultValue) : defaultValue;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    String[] getAllOptions() {
        String[] optionsArray = null;
        if (this.options != null) {
            optionsArray = new String[this.options.size()];
            Iterator<Map.Entry<Object, Object>> entrySetIterator = this.options.entrySet().iterator();
            int i = 0;
            while (entrySetIterator.hasNext()) {
                Map.Entry<Object, Object> entry = entrySetIterator.next();
                optionsArray[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                ++i;
            }
        }
        if (optionsArray == null) {
            optionsArray = new String[1];
        }
        return optionsArray;
    }

    public void removeOption(String option) {
        if (option != null) {
            this.options.remove(option);
            int firstSlashIndex = option.indexOf("/");
            String symbolicName = option.substring(0, firstSlashIndex);
            this.optionsChanged(symbolicName);
        }
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            String currentValue = this.options.getProperty(option);
            boolean optionValueHasChanged = false;
            if (currentValue != null) {
                if (!currentValue.equals(value)) {
                    optionValueHasChanged = true;
                }
            } else if (value != null) {
                optionValueHasChanged = true;
            }
            if (optionValueHasChanged) {
                this.options.put(option, value.trim());
                int firstSlashIndex = option.indexOf("/");
                String symbolicName = option.substring(0, firstSlashIndex);
                this.optionsChanged(symbolicName);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        URL optionsFile;
        String debugOptionsFilename = FrameworkProperties.getProperty(OSGI_DEBUG);
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = new File(userDir, OPTIONS).toString();
        }
        if ((optionsFile = FrameworkDebugOptions.buildURL(debugOptionsFilename, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            return;
        }
        System.out.print("Debug options:\n    " + optionsFile.toExternalForm());
        try {
            InputStream input = optionsFile.openStream();
            try {
                this.options.load(input);
                System.out.println(" loaded");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                input.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException e) {
            System.out.println(" did not parse");
            e.printStackTrace(System.out);
        }
        Iterator<Object> i = this.options.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                if (this.options.size() == 0) {
                    this.options = null;
                }
                return;
            }
            Object key = i.next();
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
    }

    public boolean isDebugEnabled() {
        return FrameworkProperties.getProperty(OSGI_DEBUG) != null;
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            if (!this.isDebugEnabled()) {
                EclipseDebugTrace.newSession = true;
            }
            FrameworkProperties.setProperty(OSGI_DEBUG, "");
            if (this.options == null) {
                this.options = new Properties();
            }
        } else {
            FrameworkProperties.clearProperty(OSGI_DEBUG);
        }
    }

    public final DebugTrace newDebugTrace(String bundleSymbolicName) {
        return this.newDebugTrace(bundleSymbolicName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DebugTrace newDebugTrace(String bundleSymbolicName, Class traceEntryClass) {
        DebugTrace debugTrace = null;
        Map map = debugTraceCache;
        synchronized (map) {
            debugTrace = (DebugTrace)debugTraceCache.get(bundleSymbolicName);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(bundleSymbolicName, singleton, traceEntryClass);
                debugTraceCache.put(bundleSymbolicName, debugTrace);
            }
        }
        return debugTrace;
    }

    public final File getFile() {
        return this.outFile;
    }

    public synchronized void setFile(File traceFile) {
        this.outFile = traceFile;
        FrameworkProperties.setProperty(PROP_TRACEFILE, this.outFile.getAbsolutePath());
        EclipseDebugTrace.newSession = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void optionsChanged(String bundleSymbolicName) {
        BundleContext bc = this.context;
        if (bc == null) {
            return;
        }
        ServiceReference[] listenerRefs = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            listenerRefs = bc.getServiceReferences(clazz.getName(), "(listener.symbolic.name=" + bundleSymbolicName + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (listenerRefs == null) {
            return;
        }
        int i = 0;
        while (i < listenerRefs.length) {
            DebugOptionsListener service = (DebugOptionsListener)bc.getService(listenerRefs[i]);
            if (service != null) {
                Object var6_6;
                try {
                    try {
                        service.optionsChanged(this);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    bc.ungetService(listenerRefs[i]);
                    throw throwable;
                }
                {
                    var6_6 = null;
                    bc.ungetService(listenerRefs[i]);
                }
            }
            ++i;
        }
        return;
    }

    public Object addingService(ServiceReference reference) {
        DebugOptionsListener listener = (DebugOptionsListener)this.context.getService(reference);
        listener.optionsChanged(this);
        return listener;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }
}

