/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap servicesInUse;
    protected Map bundleEvent;
    protected Map bundleEventSync;
    protected Map frameworkEvent;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundle) {
        this.bundle = bundle;
        this.valid = true;
        this.framework = bundle.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.frameworkEvent = null;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry registry = this.framework.getServiceRegistry();
        registry.removeAllServiceListeners(this);
        Object object = this.framework.frameworkEvent;
        synchronized (object) {
            if (this.frameworkEvent != null) {
                this.framework.frameworkEvent.remove(this);
                this.frameworkEvent = null;
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent != null) {
                this.framework.bundleEvent.remove(this);
                this.bundleEvent = null;
            }
        }
        object = this.framework.bundleEventSync;
        synchronized (object) {
            if (this.bundleEventSync != null) {
                this.framework.bundleEventSync.remove(this);
                this.bundleEventSync = null;
            }
        }
        registry.unregisterServices(this);
        registry.releaseServicesInUse(this);
        object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.framework.getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.getBundleImpl();
    }

    public AbstractBundle getBundleImpl() {
        return this.bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(location, in);
    }

    public Bundle getBundle(long id) {
        return this.framework.getBundle(id);
    }

    public AbstractBundle getBundleByLocation(String location) {
        return this.framework.getBundleByLocation(location);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().addServiceListener(this, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().removeServiceListener(this, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        Map map;
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            map = this.framework.bundleEventSync;
            synchronized (map) {
                this.checkValid();
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new CopyOnWriteIdentityMap();
                    this.framework.bundleEventSync.put(this, this);
                }
                this.bundleEventSync.put(listener, listener);
            }
        }
        map = this.framework.bundleEvent;
        synchronized (map) {
            this.checkValid();
            if (this.bundleEvent == null) {
                this.bundleEvent = new CopyOnWriteIdentityMap();
                this.framework.bundleEvent.put(this, this);
            }
            this.bundleEvent.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        Map map;
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            map = this.framework.bundleEventSync;
            synchronized (map) {
                if (this.bundleEventSync != null) {
                    this.bundleEventSync.remove(listener);
                }
            }
        }
        map = this.framework.bundleEvent;
        synchronized (map) {
            if (this.bundleEvent != null) {
                this.bundleEvent.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        Map map = this.framework.frameworkEvent;
        synchronized (map) {
            this.checkValid();
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new CopyOnWriteIdentityMap();
                this.framework.frameworkEvent.put(this, this);
            }
            this.frameworkEvent.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        Map map = this.framework.frameworkEvent;
        synchronized (map) {
            if (this.frameworkEvent != null) {
                this.frameworkEvent.remove(listener);
            }
        }
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValid();
        return this.framework.getServiceRegistry().registerService(this, clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, clazz, filter, false);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, clazz, filter, true);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReference(this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        return this.framework.getServiceRegistry().getService(this, (ServiceReferenceImpl)reference);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValid();
        return this.framework.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)reference);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, filename);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void startActivator(BundleActivator bundleActivator) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 162->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        Thread currentThread = Thread.currentThread();
        ClassLoader previousTCCL = currentThread.getContextClassLoader();
        if (previousTCCL != (contextFinder = this.framework.getContextFinder())) {
            currentThread.setContextClassLoader(this.framework.getContextFinder());
            return previousTCCL;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Exception decompiling
                     */
                    public Object run() throws Exception {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 63->66)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t2);
                }
                String clazz = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, t2);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.activator = null;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.activator = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    /*
     * Exception decompiling
     */
    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 566->570)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return FilterImpl.newInstance(filter);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

