/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPreferenceNode
extends PreferenceNode
implements IPluginContribution {
    IConfigurationElement element;
    String nodeId;
    private ImageDescriptor imageDescriptor;

    public WorkbenchPreferenceNode(String nodeId, IConfigurationElement element) {
        super(nodeId);
        this.element = element;
    }

    public void createPage() {
        PreferencePage page;
        try {
            page = (PreferencePage)WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        }
        catch (CoreException coreException) {
            System.out.println("Error creating preference page extension");
            Object page2 = null;
            return;
        }
        page.setImageDescriptor(this.getImageDescriptor());
        page.setTitle(this.getLabelText());
        this.setPage((IPreferencePage)page);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getLocalId() {
        return this.nodeId;
    }

    public String getPluginId() {
        return this.getConfigurationElement().getNamespace();
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getLabelText() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String imageName = this.getConfigurationElement().getAttribute("icon");
        if (imageName != null) {
            String contributingPluginId = this.getConfigurationElement().getNamespace();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(contributingPluginId, imageName);
        }
        return this.imageDescriptor;
    }
}

