/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationDescriptor
implements IApplicationDescriptor,
IPluginContribution {
    private String id;
    private String pluginId;
    private String label;
    private String className;
    private String description;
    private boolean singleton;
    private ImageDescriptor image;
    private IConfigurationElement configElement;
    private Hashtable views = new Hashtable();
    private String icon;

    public ApplicationDescriptor(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public ApplicationDescriptor(String id, IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.id = id;
        if (this.getId() == null || this.getLabel() == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label, id or class name): " + this.getId(), null));
        }
    }

    public String getDescription() {
        return this.configElement == null ? this.description : RegistryReader.getDescription((IConfigurationElement)this.configElement);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.image == null && this.configElement != null) {
            String icon = this.configElement.getAttribute("icon");
            if (icon != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.configElement.getNamespace(), (String)icon);
            }
            if (this.image == null) {
                this.image = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
            }
        }
        return this.image;
    }

    public void setImage(String id, String icon) {
        this.icon = icon;
        if (id != null && icon != null) {
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)id, (String)icon);
        }
        if (this.image == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ApplicationDescriptor.this.image = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
                }
            });
        }
    }

    public String getLabel() {
        return this.configElement == null ? this.label : this.configElement.getAttribute("name");
    }

    public boolean isSingleton() {
        return this.configElement == null ? this.singleton : this.configElement.getAttributeAsIs("singleton") != null;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.configElement == null ? this.pluginId : this.configElement.getNamespace();
    }

    public String getClassName() {
        return this.configElement == null ? this.className : RegistryReader.getClassValue((IConfigurationElement)this.configElement, (String)"class");
    }

    public void setViewId(String type, String id) {
        this.views.put(type, id);
    }

    public String getViewId(String type) {
        return (String)this.views.get(type);
    }
}

