/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationRegistry;
import org.eclipse.ercp.eworkbench.Messages;
import org.eclipse.ercp.eworkbench.eWorkbenchPlugin;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.IViewRegistry;

public class DefaultView
extends ViewPart
implements IOpenListener,
SelectionListener {
    public static final String ID_VIEW = "org.eclipse.ercp.eworkbench.DefaultView";
    public static final String ID_VIEW_2 = "org.eclipse.ercp.eworkbench.SimpleDefaultView";
    private Composite parent;
    private TableViewer viewer;
    private IViewRegistry viewReg;
    private Command launchCommand;
    private Command listCommand;
    private Command exitCommand;
    private Command preferenceCommand;
    private String currentPrefPage = null;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        IApplicationRegistry appReg = eWorkbenchPlugin.getDefault().getApplicationRegistry();
        this.viewReg = eWorkbenchPlugin.getDefault().getWorkbench().getViewRegistry();
        this.viewer = new TableViewer(parent, 768);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(false));
        this.viewer.setInput((Object)appReg);
        this.viewer.addOpenListener((IOpenListener)this);
        this.enableLaunchCommand(true);
        this.exitCommand = new Command((Control)parent.getShell(), 7, 0);
        this.exitCommand.setText(Messages.getString("DefaultView.1"));
        this.exitCommand.addSelectionListener((SelectionListener)this);
    }

    private void enablePreferencesCommand(boolean enable) {
        if (enable) {
            this.preferenceCommand = new Command((Control)this.parent.getShell(), 2, 10);
            this.preferenceCommand.setText(Messages.getString("DefaultView.2"));
            this.preferenceCommand.addSelectionListener((SelectionListener)this);
        } else if (this.preferenceCommand != null) {
            this.preferenceCommand.dispose();
        }
    }

    private void enableLaunchCommand(boolean enable) {
        if (enable) {
            this.launchCommand = new Command((Control)this.parent.getShell(), 2, 10);
            this.launchCommand.setText(Messages.getString("DefaultView.3"));
            this.launchCommand.setLongLabel(Messages.getString("DefaultView.4"));
            this.launchCommand.addSelectionListener((SelectionListener)this);
        } else if (this.launchCommand != null) {
            this.launchCommand.dispose();
        }
    }

    private void enableListCommand(boolean enable) {
        if (enable) {
            this.listCommand = new Command((Control)this.parent.getShell(), 2, 1);
            this.listCommand.setText(Messages.getString("DefaultView.5"));
            this.listCommand.setLongLabel(Messages.getString("DefaultView.6"));
            this.listCommand.addSelectionListener((SelectionListener)this);
        } else if (this.listCommand != null) {
            this.listCommand.dispose();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void open(OpenEvent event) {
        this.launchSelection(event.getSelection());
    }

    private void launchSelection(ISelection selection) {
        String viewName;
        ApplicationDescriptor desc;
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            desc = (ApplicationDescriptor)ss.getFirstElement();
        } else if (selection instanceof ApplicationDescriptor) {
            desc = (ApplicationDescriptor)selection;
        } else {
            return;
        }
        String viewId = null;
        Point size = this.parent.getSize();
        if (size.x >= size.y && size.x > 640 && size.y > 480 || size.x < size.y && size.y > 640 && size.x > 480) {
            viewId = desc.getViewId("large");
        }
        if (viewId == null) {
            viewId = desc.getViewId("normal");
        }
        if ((viewName = desc.getLabel()) != null) {
            this.parent.getShell().setText(viewName);
        }
        try {
            eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
            this.enablePreferencesCommand(this.hasPrefs(desc));
            this.enableLaunchCommand(false);
            this.enableListCommand(true);
        }
        catch (PartInitException ex) {
            System.out.println((Object)ex);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.launchCommand) {
            this.launchSelection(this.viewer.getSelection());
        } else if (e.widget == this.listCommand) {
            try {
                this.parent.getShell().setText(Messages.getString("eRCP_Workbench"));
                eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID_VIEW);
                this.enableLaunchCommand(true);
                this.enableListCommand(false);
                this.enablePreferencesCommand(false);
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        } else if (e.widget == this.exitCommand) {
            eWorkbenchPlugin.getDefault().getWorkbench().close();
            eWorkbenchPlugin.getDefault().getWorkbench().getDisplay().dispose();
        } else if (e.widget == this.preferenceCommand) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)this.currentPrefPage, null, null);
            dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private boolean hasPrefs(ApplicationDescriptor desc) {
        List nodes = ((WorkbenchPreferenceManager)PlatformUI.getWorkbench().getPreferenceManager()).getElements(0);
        if (nodes != null && nodes.size() > 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)i.next();
                if (!node.getPluginId().equals(desc.getPluginId())) continue;
                this.currentPrefPage = node.getId();
                return true;
            }
        }
        return false;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof IApplicationRegistry) {
                return ((IApplicationRegistry)element).getApplications();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HashMap imageCache = new HashMap(5);
        private boolean markDefault;

        public ViewLabelProvider() {
            this(true);
        }

        public ViewLabelProvider(boolean markDefault) {
            this.markDefault = markDefault;
        }

        public final Image getImage(Object element) {
            if (element instanceof IApplicationDescriptor) {
                Image image;
                IApplicationDescriptor desc = (IApplicationDescriptor)element;
                ImageDescriptor imageDescriptor = desc.getImageDescriptor();
                if (imageDescriptor == null) {
                    imageDescriptor = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
                }
                if ((image = (Image)this.imageCache.get(imageDescriptor)) == null) {
                    image = imageDescriptor.createImage();
                    this.imageCache.put(imageDescriptor, image);
                }
                return image;
            }
            return null;
        }

        public final void dispose() {
            Iterator i = this.imageCache.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageCache.clear();
        }

        public final String getText(Object element) {
            if (element instanceof IApplicationDescriptor) {
                IApplicationDescriptor desc = (IApplicationDescriptor)element;
                String label = desc.getLabel();
                return label;
            }
            return Messages.getString("AppNameUnknown");
        }

        public final Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public final String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }
    }
}

