/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.CommandButton;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbsScreen
implements SelectionListener,
ControlListener {
    protected final int NONE = 0;
    protected final int BACK = 1;
    protected final int CANCEL = 2;
    protected final int NEXT = 3;
    protected final int FINISHED = 4;
    NormalView view;
    Composite screen;
    Composite screenPane;
    WrappedLabel titleLabel;
    CommandButton backButton;
    CommandButton cancelButton;
    CommandButton nextButton;
    Composite buttonPane;

    public AbsScreen() {
    }

    public AbsScreen(NormalView view) {
        this.view = view;
    }

    public void show(boolean refreshIt) {
        if (this.screen == null) {
            this.createScreen();
        }
        if (refreshIt) {
            this.refresh();
            this.setVisible(true);
            this.action();
        } else {
            this.setVisible(true);
        }
    }

    public void setVisible(boolean bVis) {
        this.screen.setVisible(bVis);
        if (bVis) {
            this.setDefaultFocus();
        }
    }

    protected abstract void createScreen();

    protected abstract void refresh();

    protected abstract void action();

    protected abstract void setDefaultFocus();

    protected void init(String title) {
        this.init(title, false);
    }

    protected Composite init(String title, boolean scrollable) {
        if (scrollable) {
            this.screen = new Composite(this.view.parent, 512);
            this.screen.getVerticalBar().setVisible(false);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = new Composite(this.screen, 0);
            this.screenPane.setLayout((Layout)new GridLayout(1, false));
            this.screenPane.setLayoutData((Object)new GridData(1808));
        } else {
            this.screen = new Composite(this.view.parent, 0);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = this.screen;
        }
        if (title != null) {
            this.titleLabel = new WrappedLabel(this.screenPane, 0, 0);
            if (3 == this.view.osType) {
                this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 7, 1));
            } else {
                this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 10, 1));
            }
            this.titleLabel.setText(title);
        }
        return this.screenPane;
    }

    protected void fillSpace() {
        new Composite(this.screenPane, 0).setLayoutData((Object)new GridData(1040));
    }

    protected void separator() {
        if (3 == this.view.osType) {
            return;
        }
        new Label(this.screenPane, 258).setLayoutData((Object)new GridData(768));
    }

    protected void setButtons(int back, int cancel, int next) {
        if (9 == this.view.runtimeType && this.view.isDPI192Device) {
            this.setButtons_onSprintRafael(back, cancel, next);
            return;
        }
        this.buttonPane = new Composite(this.screenPane, 0);
        GridData gd = new GridData(768);
        this.buttonPane.setLayoutData((Object)gd);
        RowLayout paneLayout = new RowLayout(256);
        paneLayout.justify = true;
        paneLayout.wrap = false;
        this.buttonPane.setLayout((Layout)paneLayout);
        int commandAttribute = 1;
        if (this.view.osType == 3) {
            commandAttribute = 8;
        }
        if (back == 1) {
            this.backButton = this.view.inputType == 4097 ? new CommandButton(this.screen, commandAttribute, 12) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.backButton.setFont(this.view.fontOnS60);
            }
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener(this);
        }
        if (cancel == 2) {
            this.cancelButton = this.view.inputType == 4097 ? new CommandButton(this.screen, commandAttribute, 11) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.cancelButton.setFont(this.view.fontOnS60);
            }
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener(this);
        }
        if (next != 0) {
            this.nextButton = this.view.inputType == 4097 ? new CommandButton(this.screen, commandAttribute, 13) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.nextButton.setFont(this.view.fontOnS60);
            }
            if (next == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener(this);
        }
        this.buttonPane.layout();
        if (this.view.inputType != 4097 && this.nextButton != null && this.nextButton.getLocation().x > this.screenPane.getSize().x) {
            paneLayout.wrap = true;
            this.buttonPane.setLayoutData((Object)new GridData(768));
            this.screen.layout();
        }
    }

    public abstract void widgetSelected(SelectionEvent var1);

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
    }

    private void setButtons_onSprintRafael(int back, int cancel, int next) {
        int totalButtonCount = 0;
        int buttonIdx = 0;
        this.buttonPane = new Composite(this.screenPane, 0);
        this.buttonPane.setLayoutData((Object)new GridData(768));
        this.buttonPane.setLayout((Layout)new FormLayout());
        if (back == 1) {
            ++totalButtonCount;
        }
        if (cancel == 2) {
            ++totalButtonCount;
        }
        if (next != 0) {
            ++totalButtonCount;
        }
        FormData[] fdButtons = new FormData[totalButtonCount];
        if (totalButtonCount == 1) {
            fdButtons[0] = new FormData();
            fdButtons[0].top = new FormAttachment(0, 0);
            fdButtons[0].bottom = new FormAttachment(100, -5);
            fdButtons[0].left = new FormAttachment(35, 0);
            fdButtons[0].right = new FormAttachment(65, 0);
        } else if (totalButtonCount == 2) {
            fdButtons[0] = new FormData();
            fdButtons[0].top = new FormAttachment(0, 0);
            fdButtons[0].bottom = new FormAttachment(100, -5);
            fdButtons[0].left = new FormAttachment(5, 0);
            fdButtons[0].right = new FormAttachment(35, 0);
            fdButtons[1] = new FormData();
            fdButtons[1].top = new FormAttachment(0, 0);
            fdButtons[1].bottom = new FormAttachment(100, -5);
            fdButtons[1].left = new FormAttachment(65, 0);
            fdButtons[1].right = new FormAttachment(95, 0);
        } else if (totalButtonCount == 3) {
            fdButtons[0] = new FormData();
            fdButtons[0].top = new FormAttachment(0, 0);
            fdButtons[0].bottom = new FormAttachment(100, -5);
            fdButtons[0].left = new FormAttachment(6, 0);
            fdButtons[0].right = new FormAttachment(30, 0);
            fdButtons[1] = new FormData();
            fdButtons[1].top = new FormAttachment(0, 0);
            fdButtons[1].bottom = new FormAttachment(100, -5);
            fdButtons[1].left = new FormAttachment(38, 0);
            fdButtons[1].right = new FormAttachment(62, 0);
            fdButtons[2] = new FormData();
            fdButtons[2].top = new FormAttachment(0, 0);
            fdButtons[2].bottom = new FormAttachment(100, -5);
            fdButtons[2].left = new FormAttachment(70, 0);
            fdButtons[2].right = new FormAttachment(94, 0);
        }
        if (back == 1) {
            this.backButton = new CommandButton(this.buttonPane, 8);
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener(this);
            this.backButton.setLayoutData(fdButtons[buttonIdx++]);
        }
        if (cancel == 2) {
            this.cancelButton = new CommandButton(this.buttonPane, 8);
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener(this);
            this.cancelButton.setLayoutData(fdButtons[buttonIdx++]);
        }
        if (next != 0) {
            this.nextButton = new CommandButton(this.buttonPane, 8);
            if (next == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener(this);
            this.nextButton.setLayoutData(fdButtons[buttonIdx++]);
        }
        this.buttonPane.layout();
    }
}

