/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;

public class AddRemoteScreen
extends AbsScreen
implements ModifyListener {
    Button remoteButton;
    Button localButton;
    Text name;
    Text url;
    Vector bookmarks = new Vector();
    Composite screenPane;
    ScrollBar scrollBarV;
    Rectangle screenPaneBounds;

    public AddRemoteScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.screenPane = this.init(UIMessages.YouSelectedRemote, true);
        this.scrollBarV = this.screen.getVerticalBar();
        this.scrollBarV.addSelectionListener((SelectionListener)this);
        WrappedLabel nameLabel = new WrappedLabel(this.screenPane, 0, 0);
        if (3 == this.view.osType) {
            nameLabel.setText(UIMessages.EnterName2);
        } else {
            nameLabel.setText(UIMessages.EnterName);
        }
        this.name = new Text(this.screenPane, 2048);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener((ModifyListener)this);
        WrappedLabel addrLabel = new WrappedLabel(this.screenPane, 0, 0);
        if (3 == this.view.osType) {
            addrLabel.setText(UIMessages.EnterURL2);
        } else {
            addrLabel.setText(UIMessages.EnterURL);
        }
        this.url = new Text(this.screenPane, 2048);
        this.url.setSelection(7, 7);
        this.url.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        this.separator();
        this.setButtons(1, 0, 4);
        if (3 == this.view.osType) {
            nameLabel.label.setFont(this.view.fontOnS60);
            this.name.setFont(this.view.fontOnS60);
            addrLabel.label.setFont(this.view.fontOnS60);
            this.url.setFont(this.view.fontOnS60);
        }
        this.screen.pack();
        this.screen.layout();
    }

    protected void refresh() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        BookmarkUtil.load(this.view.bookmarkFile, this.bookmarks);
        this.name.setText("");
        this.url.setText("http://");
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.name.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(5, false);
        } else if (e.widget == this.nextButton.widget) {
            BookmarkSite newBookmark = new BookmarkSite(this.name.getText(), this.url.getText(), false, true, false, "");
            this.bookmarks.add(newBookmark);
            BookmarkUtil.store(this.view.bookmarkFile, this.bookmarks);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (e.widget == this.scrollBarV) {
            this.screenPane.setBounds(this.screenPaneBounds.x, this.screenPaneBounds.y - this.scrollBarV.getSelection(), this.screenPaneBounds.width, this.screenPaneBounds.height + this.scrollBarV.getSelection());
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.name.getText().length() == 0 || BookmarkUtil.searchByName(this.bookmarks, this.name.getText()) >= 0) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    public void controlResized(ControlEvent e) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
        if (this.buttonPane == null) {
            return;
        }
        this.screenPaneBounds = this.screenPane.getBounds();
        int buttonFloor = this.buttonPane.getLocation().y + this.buttonPane.getSize().y;
        int screenFloor = this.screenPane.getSize().y;
        if (buttonFloor > screenFloor) {
            this.scrollBarV.setMaximum(buttonFloor - screenFloor);
            this.scrollBarV.setSelection(0);
            if (!this.scrollBarV.getVisible()) {
                this.scrollBarV.setVisible(true);
            }
        } else if (this.scrollBarV.getVisible()) {
            this.scrollBarV.setVisible(false);
        }
    }
}

