/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;

public class EditBookmarkScreen
extends AbsScreen
implements ModifyListener {
    Text name;
    Text url;
    Button changeUrlButton;
    Vector bookmarks = new Vector();
    BookmarkSite selectedBookmark = null;

    public EditBookmarkScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(UIMessages.EditBookmark);
        CaptionedControl namecc = new CaptionedControl(this.screen, 0);
        this.name = new Text((Composite)namecc, 2048);
        this.name.addModifyListener((ModifyListener)this);
        namecc.setText(UIMessages.BookmarkName);
        namecc.setLayoutData((Object)new GridData(768));
        CaptionedControl urlcc = new CaptionedControl(this.screen, 0);
        this.url = new Text((Composite)urlcc, 2048);
        urlcc.setText(UIMessages.BookmarkURL);
        urlcc.setLayoutData((Object)new GridData(768));
        this.changeUrlButton = new Button(this.screen, 8);
        this.changeUrlButton.setLayoutData((Object)new GridData(128));
        this.changeUrlButton.setText(UIMessages.ChangeURL);
        this.changeUrlButton.addSelectionListener((SelectionListener)this);
        this.fillSpace();
        this.separator();
        this.setButtons(1, 0, 4);
        if (3 == this.view.osType) {
            namecc.setFont(this.view.fontOnS60);
            this.name.setFont(this.view.fontOnS60);
            urlcc.setFont(this.view.fontOnS60);
            this.url.setFont(this.view.fontOnS60);
            this.changeUrlButton.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    protected void refresh() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        if (this.view.currentName != null && this.view.bookmarkFile != null) {
            BookmarkUtil.load(this.view.bookmarkFile, this.bookmarks);
            int i = 0;
            while (i < this.bookmarks.size()) {
                this.selectedBookmark = (BookmarkSite)this.bookmarks.elementAt(i);
                if (this.view.currentName.equals(this.selectedBookmark.getName())) {
                    this.name.setText(this.selectedBookmark.getName());
                    this.url.setText(this.selectedBookmark.getURL().toString());
                    this.url.setEditable(!this.selectedBookmark.getLocal());
                    this.changeUrlButton.setVisible(this.selectedBookmark.getLocal());
                    break;
                }
                ++i;
            }
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.name.setSelection(this.name.getCharCount());
        this.name.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, false);
        } else if (e.widget == this.nextButton.widget) {
            this.selectedBookmark.setName(this.name.getText());
            this.selectedBookmark.setURL(this.url.getText());
            BookmarkUtil.store(this.view.bookmarkFile, this.bookmarks);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (e.widget == this.changeUrlButton) {
            FileDialog fd = new FileDialog(this.view.parent.getShell(), 0);
            if (3 == this.view.osType) {
                fd.setText(UIMessages.SelectSite2);
            } else {
                fd.setText(UIMessages.SelectSite);
            }
            String[] extensions = new String[]{65 == this.view.wmType ? "*.xml" : "site.xml"};
            fd.setFilterExtensions(extensions);
            String[] names = new String[]{UIMessages.SiteXMLfiles};
            fd.setFilterNames(names);
            if (fd.open() != null) {
                if (2 == this.view.osType) {
                    this.url.setText("file://" + fd.getFilterPath() + fd.getFileName());
                } else if (1 == this.view.osType) {
                    this.url.setText("file:///" + fd.getFilterPath() + fd.getFileName());
                } else if (3 == this.view.osType) {
                    this.url.setText("file:/" + fd.getFilterPath() + "/" + fd.getFileName());
                }
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (!(this.name.getText().equals(this.view.currentName) || this.name.getText().length() != 0 && BookmarkUtil.searchByName(this.bookmarks, this.name.getText()) < 0)) {
            this.nextButton.setEnabled(false);
            return;
        }
        this.nextButton.setEnabled(true);
    }
}

