/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.util.FeatureWrap;

public class LicenseScreen
extends AbsScreen {
    SortedList featureList;
    Text licenseArea;
    Button acceptButton;
    Button noAcceptButton;
    Label acceptText;
    Label noAcceptText;
    Composite pane;
    Composite namePane;
    FormData fdFeatures;
    FormData fdLicense;
    FormData fdAcceptButton;
    FormData fdNoAcceptButton;

    public LicenseScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayout((Layout)new FormLayout());
        this.pane.setLayoutData((Object)new GridData(1808));
        this.featureList = new SortedList(this.pane, 2560);
        this.featureList.addSelectionListener((SelectionListener)this);
        this.licenseArea = new Text(this.pane, 2626);
        this.licenseArea.setEditable(false);
        this.acceptButton = new Button(this.pane, 80);
        this.acceptButton.setText(UIMessages.Accept);
        this.acceptButton.addSelectionListener((SelectionListener)this);
        this.noAcceptButton = new Button(this.pane, 80);
        this.noAcceptButton.setText(UIMessages.NoAccept);
        this.noAcceptButton.addSelectionListener((SelectionListener)this);
        this.setButtons(0, 0, 0);
        this.fdFeatures = new FormData();
        this.fdLicense = new FormData();
        this.fdAcceptButton = new FormData();
        this.fdNoAcceptButton = new FormData();
        if (3 == this.view.osType) {
            this.featureList.setFont(this.view.fontOnS60);
            this.licenseArea.setFont(this.view.fontOnS60);
            this.acceptButton.setFont(this.view.fontOnS60);
            this.noAcceptButton.setFont(this.view.fontOnS60);
        }
    }

    protected void refresh() {
        this.acceptButton.setSelection(false);
        this.noAcceptButton.setSelection(false);
        this.featureList.removeAll();
        this.licenseArea.setText("");
        FeatureWrap fw = null;
        int i = 0;
        while (i < this.view.availableFeatures.size()) {
            fw = (FeatureWrap)this.view.availableFeatures.elementAt(i);
            if (fw.isSelected()) {
                this.featureList.add(fw.getShowedName());
                if (this.licenseArea.getText().length() < 1) {
                    this.featureList.select(fw.getShowedName());
                    this.licenseArea.setText(fw.getLicense());
                }
            }
            ++i;
        }
        int rateTop = 20;
        int rateMed = 40;
        int rateFoot = 100 - rateTop - rateMed;
        if (this.view.parent.getClientArea().width > this.view.parent.getClientArea().height) {
            this.fdFeatures.top = new FormAttachment(0, 0);
            this.fdFeatures.bottom = new FormAttachment(rateTop + rateMed, -5);
            this.fdFeatures.left = new FormAttachment(0, 0);
            this.fdFeatures.right = new FormAttachment(50, -2);
            this.fdLicense.top = new FormAttachment(0, 0);
            this.fdLicense.bottom = new FormAttachment(rateTop + rateMed, -5);
            this.fdLicense.left = new FormAttachment(50, 2);
            this.fdLicense.right = new FormAttachment(100, 0);
        } else {
            this.fdFeatures.top = new FormAttachment(0, 0);
            this.fdFeatures.bottom = new FormAttachment(rateTop, 0);
            this.fdFeatures.left = new FormAttachment(0, 0);
            this.fdFeatures.right = new FormAttachment(100, 0);
            this.fdLicense.top = new FormAttachment(rateTop, 5);
            this.fdLicense.bottom = new FormAttachment(rateTop + rateMed, -5);
            this.fdLicense.left = new FormAttachment(0, 0);
            this.fdLicense.right = new FormAttachment(100, 0);
        }
        this.fdAcceptButton.top = new FormAttachment(100 - rateFoot, 0);
        this.fdAcceptButton.bottom = new FormAttachment(100 - rateFoot / 2, 0);
        this.fdAcceptButton.left = new FormAttachment(0, 0);
        this.fdAcceptButton.right = new FormAttachment(100, 0);
        this.fdNoAcceptButton.top = new FormAttachment(100 - rateFoot / 2, 0);
        this.fdNoAcceptButton.bottom = new FormAttachment(100, 0);
        this.fdNoAcceptButton.left = new FormAttachment(0, 0);
        this.fdNoAcceptButton.right = new FormAttachment(100, 0);
        this.featureList.setLayoutData((Object)this.fdFeatures);
        this.licenseArea.setLayoutData((Object)this.fdLicense);
        this.acceptButton.setLayoutData((Object)this.fdAcceptButton);
        this.noAcceptButton.setLayoutData((Object)this.fdNoAcceptButton);
        this.screen.layout();
    }

    protected void action() {
        this.setDefaultFocus();
    }

    protected void setDefaultFocus() {
        this.acceptButton.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        String[] selectedStrings;
        if (e.widget == this.featureList && (selectedStrings = this.featureList.getSelection()).length > 0) {
            int i = 0;
            while (i < this.view.availableFeatures.size()) {
                FeatureWrap fw = (FeatureWrap)this.view.availableFeatures.elementAt(i);
                if (fw.isSelected() && selectedStrings[0].equals(fw.getShowedName())) {
                    this.licenseArea.setText(fw.getLicense());
                }
                ++i;
            }
        }
        if (e.widget == this.acceptButton) {
            if (this.acceptButton.getSelection()) {
                this.setVisible(false);
                ((Object)((Object)this.view)).getClass();
                ((Object)((Object)this.view)).getClass();
                this.view.showScreen(4, true);
            }
        } else if (e.widget == this.noAcceptButton && this.noAcceptButton.getSelection()) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        }
    }
}

