/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class PropertiesScreen
extends AbsScreen {
    private Composite namePane;
    private Label featureLabel;
    private Label featureName;
    private SortedList menuList;
    private Text propertiesArea;
    IFeature selectedFeature;
    StringBuffer generalContent = null;
    StringBuffer pluginsContent = null;
    StringBuffer requiredByContent = null;

    public PropertiesScreen(NormalView view) {
        super(view);
    }

    public void createScreen() {
        this.init(null);
        this.namePane = new Composite(this.screen, 0);
        this.namePane.setLayoutData((Object)new GridData(768));
        this.namePane.setLayout((Layout)new RowLayout(256));
        this.featureLabel = new Label(this.namePane, 0);
        this.featureLabel.setText(UIMessages.PropertiesOf);
        this.featureName = new Label(this.namePane, 0);
        if (3 == this.view.osType) {
            this.featureLabel.setFont(this.view.fontOnS60);
            this.featureName.setFont(this.view.fontOnS60);
        }
        Composite subPane = new Composite(this.screen, 0);
        subPane.setLayout((Layout)new FormLayout());
        subPane.setLayoutData((Object)new GridData(1808));
        FormData fdMenu = new FormData();
        FormData fdProperty = new FormData();
        if (this.view.parent.getClientArea().width > this.view.parent.getClientArea().height) {
            fdMenu.top = new FormAttachment(0, 0);
            fdMenu.bottom = new FormAttachment(100, 0);
            fdMenu.left = new FormAttachment(0, 0);
            fdMenu.right = new FormAttachment(50, -2);
            fdProperty.top = new FormAttachment(0, 0);
            fdProperty.bottom = new FormAttachment(100, 0);
            fdProperty.left = new FormAttachment(50, 2);
            fdProperty.right = new FormAttachment(100, 0);
        } else {
            fdMenu.top = new FormAttachment(0, 0);
            fdMenu.bottom = new FormAttachment(50, -2);
            fdMenu.left = new FormAttachment(0, 0);
            fdMenu.right = new FormAttachment(100, 0);
            fdProperty.top = new FormAttachment(50, 2);
            fdProperty.bottom = new FormAttachment(100, 0);
            fdProperty.left = new FormAttachment(0, 0);
            fdProperty.right = new FormAttachment(100, 0);
        }
        this.menuList = new SortedList(subPane, 512);
        this.menuList.setLayoutData((Object)fdMenu);
        this.menuList.addSelectionListener((SelectionListener)this);
        this.menuList.add(UIMessages.Copyright);
        this.menuList.add(UIMessages.GeneralInfo);
        this.menuList.add(UIMessages.License);
        this.menuList.add(UIMessages.Status);
        this.menuList.add(UIMessages.IncludedPlugins);
        this.menuList.add(UIMessages.RequiredBy);
        this.propertiesArea = new Text(subPane, 2626);
        this.propertiesArea.setLayoutData((Object)fdProperty);
        this.propertiesArea.setEditable(false);
        this.separator();
        this.setButtons(1, 0, 0);
        if (3 == this.view.osType) {
            this.menuList.setFont(this.view.fontOnS60);
            this.propertiesArea.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    protected void refresh() {
        this.selectedFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        this.generalContent = null;
        this.pluginsContent = null;
        this.requiredByContent = null;
        this.featureName.setText(this.selectedFeature.getLabel());
        this.namePane.layout();
        this.menuList.select(UIMessages.Copyright);
        this.menuList.showSelection();
        this.showCopyright();
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
        this.screen.layout();
    }

    protected void setDefaultFocus() {
        this.menuList.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.menuList) {
            String[] selectedStrings = this.menuList.getSelection();
            if (UIMessages.Copyright.equals(selectedStrings[0])) {
                this.showCopyright();
            } else if (UIMessages.GeneralInfo.equals(selectedStrings[0])) {
                this.showGeneralInfo();
            } else if (UIMessages.License.equals(selectedStrings[0])) {
                this.showLicense();
            } else if (UIMessages.Status.equals(selectedStrings[0])) {
                this.showStatus();
            } else if (UIMessages.IncludedPlugins.equals(selectedStrings[0])) {
                this.showIncludingPlugins();
            } else if (UIMessages.RequiredBy.equals(selectedStrings[0])) {
                this.showRequiredBy();
            }
            this.propertiesArea.setSelection(0, 0);
        }
        if (e.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(10, false);
        }
    }

    private void showCopyright() {
        IURLEntry copyright = this.selectedFeature.getCopyright();
        if (copyright != null) {
            this.propertiesArea.setText(copyright.getAnnotation());
        } else {
            this.propertiesArea.setText("");
        }
    }

    private void showGeneralInfo() {
        if (this.generalContent != null) {
            this.propertiesArea.setText(this.generalContent.toString());
            return;
        }
        this.generalContent = new StringBuffer();
        this.generalContent.append(UIMessages.Name).append(this.selectedFeature.getLabel()).append("\n");
        VersionedIdentifier featureVId = this.selectedFeature.getVersionedIdentifier();
        if (featureVId != null) {
            this.generalContent.append(String.valueOf(UIMessages.Identifier) + featureVId.getIdentifier()).append("\n");
            this.generalContent.append(UIMessages.Version).append(featureVId.getVersion()).append("\n");
        } else {
            this.generalContent.append(UIMessages.Identifier).append("\n");
            this.generalContent.append(UIMessages.Version).append("\n");
        }
        this.generalContent.append(UIMessages.Provider).append(this.selectedFeature.getProvider()).append("\n");
        this.generalContent.append(UIMessages.Size).append(this.selectedFeature.getInstallSize()).append("\n");
        this.generalContent.append("\n");
        this.generalContent.append(UIMessages.SupportedPlatforms).append("\n");
        this.generalContent.append("   ").append(UIMessages.OperatingSystem).append(this.selectedFeature.getOS() != null ? this.selectedFeature.getOS() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.CPUArchitecture).append(this.selectedFeature.getOSArch() != null ? this.selectedFeature.getOSArch() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.WindowingSystem).append(this.selectedFeature.getWS() != null ? this.selectedFeature.getWS() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.Languages).append(this.selectedFeature.getNL() != null ? this.selectedFeature.getNL() : "").append("\n");
        this.generalContent.append("\n");
        this.generalContent.append(UIMessages.Description).append("\n");
        IURLEntry description = this.selectedFeature.getDescription();
        if (description != null) {
            this.generalContent.append("   ").append(description.getAnnotation()).append("\n");
        } else {
            this.generalContent.append("");
        }
        this.propertiesArea.setText(this.generalContent.toString());
    }

    private void showLicense() {
        IURLEntry license = this.selectedFeature.getLicense();
        if (license != null) {
            this.propertiesArea.setText(license.getAnnotation());
        } else {
            this.propertiesArea.setText("");
        }
    }

    private void showStatus() {
        try {
            switch (SiteManager.getLocalSite().getFeatureStatus(this.selectedFeature).getCode()) {
                case 0: 
                case 1: {
                    this.propertiesArea.setText(UIMessages.StatusHappy);
                    break;
                }
                case -1: {
                    this.propertiesArea.setText(UIMessages.StatusDisabled);
                    break;
                }
                default: {
                    this.propertiesArea.setText(UIMessages.StatusUnhappy);
                    break;
                }
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    private void showIncludingPlugins() {
        if (this.pluginsContent != null) {
            this.propertiesArea.setText(this.pluginsContent.toString());
            return;
        }
        this.pluginsContent = new StringBuffer();
        IPluginEntry[] plugins = this.selectedFeature.getPluginEntries();
        int i = 0;
        while (i < plugins.length) {
            VersionedIdentifier pluginVId = plugins[i].getVersionedIdentifier();
            if (pluginVId != null) {
                this.pluginsContent.append(String.valueOf(pluginVId.getIdentifier()) + " (" + pluginVId.getVersion() + ")");
                this.pluginsContent.append("\n");
            }
            ++i;
        }
        this.propertiesArea.setText(this.pluginsContent.toString());
    }

    private void showRequiredBy() {
        if (this.requiredByContent != null) {
            this.propertiesArea.setText(this.requiredByContent.toString());
            return;
        }
        this.requiredByContent = new StringBuffer();
        IPluginEntry[] selectedPlugins = this.selectedFeature.getPluginEntries();
        IFeature checkedFeature = null;
        boolean sureRequired = false;
        int i = 0;
        while (i < this.view.installedFeatures.size()) {
            try {
                IImport[] importedPlugins;
                IFeatureReference installedFeature = (IFeatureReference)this.view.installedFeatures.get(i);
                sureRequired = false;
                if (!this.selectedFeature.getVersionedIdentifier().equals((Object)installedFeature.getVersionedIdentifier()) && (importedPlugins = (checkedFeature = installedFeature.getFeature(null)).getImports()).length != 0) {
                    int j = 0;
                    while (j < importedPlugins.length && !sureRequired) {
                        int k = 0;
                        while (k < selectedPlugins.length) {
                            if (importedPlugins[j].getVersionedIdentifier().getIdentifier().equals(selectedPlugins[k].getVersionedIdentifier().getIdentifier())) {
                                this.requiredByContent.append(String.valueOf(checkedFeature.getLabel()) + " (" + checkedFeature.getVersionedIdentifier().getVersion() + ")\n");
                                sureRequired = true;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            ++i;
        }
        this.propertiesArea.setText(this.requiredByContent.toString());
    }
}

