/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.UIImage;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.ScrolledText;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.util.CategoryWrap;
import org.eclipse.update.util.FeatureWrap;
import org.eclipse.update.util.INode;
import org.eclipse.update.util.SiteWrap;
import org.osgi.framework.Bundle;

public class SelectFeaturesScreen
extends AbsScreen
implements TreeListener {
    private Tree featureList;
    private ScrolledText description;
    private Label requiredSpace;
    private Label freeSpace;
    private Command readDescription;
    private int checkedCount;
    private Vector taggedFeatures = new Vector();
    private UpdateMonitor downloadFeatureJarMonitor;
    private DownloadFeatureJarThread downloadFeatureJarThread;
    private boolean enableEnvFilter = true;
    private Image IMAGE_ICON_SITE = null;
    private Image IMAGE_ICON_CATEGORY = null;
    private Image IMAGE_ICON_FEATURE = null;
    private Image IMAGE_ICON_INCOMPATIBLE_FEATURE = null;
    private Image IMAGE_ICON_BROKEN_FEATURE = null;
    private Bundle[] runtime_bundles = null;

    public SelectFeaturesScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectFeaturesToInstall);
        this.IMAGE_ICON_SITE = UIImage.createImage(UIImage.ICON_SITE);
        this.IMAGE_ICON_CATEGORY = UIImage.createImage(UIImage.ICON_CATEGORY);
        this.IMAGE_ICON_FEATURE = UIImage.createImage(UIImage.ICON_FEATURE);
        this.IMAGE_ICON_INCOMPATIBLE_FEATURE = UIImage.createImage(UIImage.ICON_INCOMPATIBLE_FEATURE);
        this.IMAGE_ICON_BROKEN_FEATURE = UIImage.createImage(UIImage.ICON_BROKEN_FEATURE);
        Composite subPane = new Composite(this.screen, 0);
        subPane.setLayout((Layout)new FormLayout());
        subPane.setLayoutData((Object)new GridData(1808));
        FormData fdMenu = new FormData();
        FormData fdProperty = new FormData();
        if (this.view.parent.getClientArea().height * 2 < this.view.parent.getClientArea().width) {
            fdMenu.top = new FormAttachment(0, 0);
            fdMenu.bottom = new FormAttachment(100, 0);
            fdMenu.left = new FormAttachment(0, 0);
            fdMenu.right = new FormAttachment(70, -2);
            fdProperty.top = new FormAttachment(0, 0);
            fdProperty.bottom = new FormAttachment(100, 0);
            fdProperty.left = new FormAttachment(70, 2);
            fdProperty.right = new FormAttachment(100, 0);
        } else {
            fdMenu.top = new FormAttachment(0, 0);
            fdMenu.bottom = new FormAttachment(70, -2);
            fdMenu.left = new FormAttachment(0, 0);
            fdMenu.right = new FormAttachment(100, 0);
            fdProperty.top = new FormAttachment(70, 2);
            fdProperty.bottom = new FormAttachment(100, 0);
            fdProperty.left = new FormAttachment(0, 0);
            fdProperty.right = new FormAttachment(100, 0);
        }
        this.featureList = new Tree(subPane, 32);
        this.featureList.addSelectionListener((SelectionListener)this);
        this.featureList.addTreeListener((TreeListener)this);
        this.featureList.setLayoutData((Object)fdMenu);
        this.description = new ScrolledText(subPane, 0, 0, -1);
        this.description.setLayoutData(fdProperty);
        Composite spaceInfoPane = new Composite(this.screen, 0);
        spaceInfoPane.setLayoutData((Object)new GridData(768));
        spaceInfoPane.setLayout((Layout)new FillLayout(256));
        this.requiredSpace = new Label(spaceInfoPane, 0);
        this.freeSpace = new Label(spaceInfoPane, 0);
        spaceInfoPane.layout();
        this.setButtons(1, 2, 3);
        if (4097 == this.view.inputType) {
            this.readDescription = new Command((Control)this.screen, 1, 10);
            this.readDescription.setText(UIMessages.ReadDescription);
            this.readDescription.setLongLabel(UIMessages.ReadDescription);
            this.readDescription.addSelectionListener((SelectionListener)this);
        }
        if (3 == this.view.osType) {
            this.description.text.setFont(this.view.fontOnS60);
            this.requiredSpace.setFont(this.view.fontOnS60);
            this.freeSpace.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
        if (Boolean.valueOf(System.getProperty("org.eclipse.ercp.update.disableEnvFilter")).booleanValue()) {
            this.enableEnvFilter = false;
        }
    }

    protected void refresh() {
        this.checkedCount = 0;
        this.featureList.removeAll();
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.description.setText("");
        int i = 0;
        while (i < this.view.viewedTree.size()) {
            SiteWrap sw = (SiteWrap)this.view.viewedTree.elementAt(i);
            CategoryWrap[] cws = sw.getChildren();
            if (cws.length != 0) {
                TreeItem siteBranch = new TreeItem(this.featureList, 0);
                if (3 == this.view.osType) {
                    siteBranch.setFont(this.view.fontOnS60);
                }
                siteBranch.setText(sw.getName());
                siteBranch.setImage(this.IMAGE_ICON_SITE);
                sw.setUiObject(siteBranch);
                int j = 0;
                while (j < cws.length) {
                    CategoryWrap cw = cws[j];
                    TreeItem categoryBranch = new TreeItem((TreeItem)sw.getUiObject(), 0);
                    if (3 == this.view.osType) {
                        categoryBranch.setFont(this.view.fontOnS60);
                    }
                    categoryBranch.setText(cw.getLabel());
                    categoryBranch.setImage(this.IMAGE_ICON_CATEGORY);
                    cw.setUiObject(categoryBranch);
                    FeatureWrap[] fws = cw.getChildren();
                    int k = 0;
                    while (k < fws.length) {
                        FeatureWrap fw = fws[k];
                        TreeItem leaf = new TreeItem((TreeItem)cw.getUiObject(), 0);
                        if (3 == this.view.osType) {
                            leaf.setFont(this.view.fontOnS60);
                        }
                        leaf.setText(fw.getShowedName());
                        leaf.setImage(this.IMAGE_ICON_FEATURE);
                        fw.addUiObject(leaf);
                        ++k;
                    }
                    ++j;
                }
                if (cws.length == 0) {
                    siteBranch.setGrayed(true);
                }
            }
            ++i;
        }
        this.updateSpaceIndicators();
        if (9 == this.view.runtimeType) {
            this.runtime_bundles = AppPlugin.getDefault().getBundle().getBundleContext().getBundles();
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.featureList.setFocus();
    }

    private boolean updateSpaceIndicators() {
        Object[] requiredArgs = new Object[2];
        Object[] freeArgs = new Object[2];
        long requiredSize = 0L;
        this.checkedCount = 0;
        this.nextButton.setEnabled(false);
        int k = 0;
        while (k < this.view.availableFeatures.size()) {
            FeatureWrap fw = (FeatureWrap)this.view.availableFeatures.elementAt(k);
            if (fw.isSelected()) {
                ++this.checkedCount;
                requiredSize += fw.getFeatureSize();
                this.nextButton.setEnabled(true);
            }
            ++k;
        }
        if (requiredSize > 1024L) {
            requiredArgs[0] = new Long(requiredSize >> 10).toString();
            requiredArgs[1] = UIMessages.MegaBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])requiredArgs));
        } else {
            requiredArgs[0] = new Long(requiredSize).toString();
            requiredArgs[1] = UIMessages.KiloBytes;
            this.requiredSpace.setText(NLS.bind((String)UIMessages.RequiredSpace, (Object[])requiredArgs));
        }
        if ((3 == this.view.osType || 9 == this.view.runtimeType) && requiredSize > 10240L) {
            MessageBox mb1 = new MessageBox(this.screen.getShell(), 40);
            mb1.setMessage(UIMessages.ExceedLimitedSize);
            if (mb1.open() == 32) {
                return false;
            }
        }
        long availableSize = -1L;
        try {
            availableSize = Long.valueOf(System.getProperty("wed.eUpdate.availableSpace")) >> 10;
            if (availableSize <= requiredSize) {
                this.nextButton.setEnabled(false);
            }
            if (availableSize > 1024L) {
                freeArgs[0] = new Long(availableSize >> 10).toString();
                freeArgs[1] = UIMessages.MegaBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])freeArgs));
            } else {
                freeArgs[0] = new Long(availableSize).toString();
                freeArgs[1] = UIMessages.KiloBytes;
                this.freeSpace.setText(NLS.bind((String)UIMessages.FreeSpace, (Object[])freeArgs));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.freeSpace.setText("");
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.featureList) {
            if (this.downloadFeatureJarThread != null && this.downloadFeatureJarThread.getStatus() == 1) {
                return;
            }
            TreeItem item = (TreeItem)e.item;
            if (item == null) {
                this.description.setText("");
                return;
            }
            INode selectedNode = null;
            int i = 0;
            while (i < this.view.viewedTree.size()) {
                selectedNode = ((INode)this.view.viewedTree.elementAt(i)).findByUiObject(item);
                if (selectedNode != null) break;
                ++i;
            }
            if (e.detail == 32) {
                this.taggedFeatures.removeAllElements();
                if (item.getChecked()) {
                    this.rememberCurrentChecks();
                }
                if (selectedNode instanceof SiteWrap) {
                    this.checkSiteNode((SiteWrap)selectedNode, item.getChecked());
                } else if (selectedNode instanceof CategoryWrap) {
                    this.checkCategoryNode((CategoryWrap)selectedNode, item.getChecked());
                } else if (selectedNode instanceof FeatureWrap) {
                    if (item.getGrayed()) {
                        this.description.setText(UIMessages.FeatureIsIncompatible);
                        this.description.setSelection(0, 0);
                        item.setChecked(false);
                        return;
                    }
                    this.checkFeatureNode((FeatureWrap)selectedNode, item.getChecked());
                }
                this.downloadNeededFeatureInfo();
            } else {
                this.description.setText(selectedNode.getDescription());
                this.screen.layout();
                this.description.setSelection(0, 0);
            }
            return;
        }
        if (e.widget == this.backButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, false);
        } else if (e.widget == this.cancelButton.widget) {
            if (this.downloadFeatureJarMonitor != null) {
                this.downloadFeatureJarMonitor.setCanceled(true);
            }
        } else if (e.widget == this.nextButton.widget) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(3, true);
        } else if (e.widget == this.readDescription) {
            this.description.setFocus();
            this.description.setSelection(0, 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.featureList) {
            this.widgetSelected(e);
        }
    }

    private boolean isIncompatibleFeature(FeatureWrap fw) {
        if (this.enableEnvFilter) {
            IFeature f = fw.getFeature();
            if (f.getOS() != null && this.isNotInSupportedList(f.getOS(), Platform.getOS())) {
                return true;
            }
            if (f.getWS() != null && this.isNotInSupportedList(f.getWS(), Platform.getWS())) {
                return true;
            }
            if (f.getOSArch() != null && this.isNotInSupportedList(f.getOSArch(), Platform.getOSArch())) {
                return true;
            }
            if (f.getNL() != null && this.isNotInSupportedLanguageList(f.getNL(), Platform.getNL())) {
                return true;
            }
            if (9 == this.view.runtimeType && this.isThereDuplicatePlugins(fw)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedList(String supportList, String checked) {
        st = new StringTokenizer(supportList.trim(), ",");
        if (st.countTokens() != 0) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (!checked.equalsIgnoreCase(st.nextToken().trim())) continue;
            return false;
lbl6:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl7:
        // 1 sources

        return true;
    }

    private boolean isThereDuplicatePlugins(FeatureWrap fw) {
        if (fw.getFeatureUniquenessStatus() == 17) {
            IPluginEntry[] pes = fw.getFeature().getPluginEntries();
            int i = 0;
            while (i < pes.length) {
                int j = 80;
                while (j < this.runtime_bundles.length) {
                    if (this.runtime_bundles[j].getSymbolicName() != null && this.runtime_bundles[j].getSymbolicName().startsWith(pes[i].getVersionedIdentifier().getIdentifier()) && InstallRegistry.getInstance().get((Object)("plugin_" + pes[i].getVersionedIdentifier())) == null) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotInSupportedLanguageList(String supportList, String checked) {
        st = new StringTokenizer(supportList.trim(), ",");
        if (st.countTokens() != 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            token = st.nextToken().trim();
            if (!(token.indexOf(95) > -1 ? checked.equals(token) != false : checked.startsWith(token) != false)) continue;
            return false;
lbl7:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl8:
        // 1 sources

        return true;
    }

    private void checkSiteNode(SiteWrap sw, boolean checked) {
        TreeItem siteyNode = (TreeItem)sw.getUiObject();
        siteyNode.setChecked(checked);
        if (checked) {
            siteyNode.setExpanded(true);
        }
        sw.setSelected(checked);
        CategoryWrap[] cws = sw.getChildren();
        int i = 0;
        while (i < cws.length) {
            this.checkCategoryNode(cws[i], checked);
            ++i;
        }
    }

    private void checkCategoryNode(CategoryWrap cw, boolean checked) {
        TreeItem categoryNode = (TreeItem)cw.getUiObject();
        categoryNode.setChecked(checked);
        if (checked) {
            categoryNode.setExpanded(true);
        }
        cw.setSelected(checked);
        FeatureWrap[] fws = cw.getChildren();
        int i = 0;
        while (i < fws.length) {
            this.checkFeatureNode(fws[i], checked);
            ++i;
        }
    }

    private void checkFeatureNode(FeatureWrap fw, boolean checked) {
        if (checked && !fw.isFeatureReady()) {
            this.taggedFeatures.add(fw);
        }
        if (fw.isFeatureReady() && this.isIncompatibleFeature(fw)) {
            fw.setSelected(false);
            return;
        }
        fw.setSelected(checked);
        Vector featureNodes = fw.getUiObjects();
        int i = 0;
        while (i < featureNodes.size()) {
            ((TreeItem)featureNodes.elementAt(i)).setChecked(checked);
            ++i;
        }
    }

    private void finalizeAllCheckeds() {
        int i = 0;
        while (i < this.view.viewedTree.size()) {
            SiteWrap sw = (SiteWrap)this.view.viewedTree.elementAt(i);
            boolean siteFinalChecked = false;
            CategoryWrap[] cws = sw.getChildren();
            int j = 0;
            while (j < cws.length) {
                boolean categoryFinalChecked = false;
                FeatureWrap[] fws = cws[j].getChildren();
                int k = 0;
                while (k < fws.length) {
                    if (fws[k].isSelected()) {
                        categoryFinalChecked = true;
                        siteFinalChecked = true;
                        break;
                    }
                    ++k;
                }
                cws[j].setSelected(categoryFinalChecked);
                ((TreeItem)cws[j].getUiObject()).setChecked(categoryFinalChecked);
                ++j;
            }
            if (cws.length > 0) {
                sw.setSelected(siteFinalChecked);
                ((TreeItem)sw.getUiObject()).setChecked(siteFinalChecked);
            }
            ++i;
        }
    }

    private boolean isRequiredFeatureInstalled(VersionedIdentifier requiredVID) {
        int i = 0;
        while (i < this.view.installedFeatures.size()) {
            block4: {
                VersionedIdentifier installedVID;
                try {
                    installedVID = ((IFeatureReference)this.view.installedFeatures.get(i)).getVersionedIdentifier();
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    break block4;
                }
                if (installedVID.getIdentifier().equals(requiredVID.getIdentifier()) && installedVID.getVersion().isGreaterOrEqualTo(requiredVID.getVersion())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean addRequiredFeatureInto(VersionedIdentifier requiredVID) {
        int i = 0;
        while (i < this.view.availableFeatures.size()) {
            FeatureWrap fw = (FeatureWrap)this.view.availableFeatures.elementAt(i);
            VersionedIdentifier availableVID = fw.getVID();
            if (availableVID.getIdentifier().equals(requiredVID.getIdentifier()) && availableVID.getVersion().isGreaterOrEqualTo(requiredVID.getVersion())) {
                if (!fw.isSelected()) {
                    if (!this.isIncompatibleFeature(fw)) {
                        fw.setSelected(true);
                        Vector featureNodes = fw.getUiObjects();
                        int j = 0;
                        while (j < featureNodes.size()) {
                            ((TreeItem)featureNodes.elementAt(j)).setChecked(true);
                            ((TreeItem)featureNodes.elementAt(j)).setText(fw.getShowedName());
                            ++j;
                        }
                    }
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void resolveDependency() {
        StringBuffer dependencyLog = new StringBuffer();
        int i = 0;
        while (i < this.view.availableFeatures.size()) {
            block10: {
                FeatureWrap fw = (FeatureWrap)this.view.availableFeatures.elementAt(i);
                if (fw.isSelected()) {
                    IIncludedFeatureReference[] children;
                    try {
                        children = fw.getFeature().getIncludedFeatureReferences();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block10;
                    }
                    int j = 0;
                    while (j < children.length) {
                        try {
                            if (!this.isRequiredFeatureInstalled(children[j].getVersionedIdentifier()) && !this.addRequiredFeatureInto(children[j].getVersionedIdentifier())) {
                                Vector featureNodes = fw.getUiObjects();
                                int k = 0;
                                while (k < featureNodes.size()) {
                                    ((TreeItem)featureNodes.elementAt(k)).setImage(this.IMAGE_ICON_BROKEN_FEATURE);
                                    ++k;
                                }
                                dependencyLog.append(NLS.bind((String)UIMessages.NestedFeatureUnavailable, (Object[])new String[]{children[j].getName()})).append("\n");
                            }
                        }
                        catch (CoreException ce2) {
                            ce2.printStackTrace();
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (dependencyLog.length() > 0) {
            this.description.setText(dependencyLog.toString());
            this.description.setSelection(0, 0);
        }
    }

    private void rememberCurrentChecks() {
        int i = 0;
        while (i < this.view.viewedTree.size()) {
            SiteWrap sw = (SiteWrap)this.view.viewedTree.elementAt(i);
            sw.setPreviousSelected(sw.isSelected());
            CategoryWrap[] cws = sw.getChildren();
            int j = 0;
            while (j < cws.length) {
                CategoryWrap cw = cws[j];
                cw.setPreviousSelected(cw.isSelected());
                FeatureWrap[] fws = cw.getChildren();
                int k = 0;
                while (k < fws.length) {
                    FeatureWrap fw = fws[k];
                    fw.setPreviousSelected(fw.isSelected());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void recoverPreviousChecks() {
        int i = 0;
        while (i < this.view.viewedTree.size()) {
            SiteWrap sw = (SiteWrap)this.view.viewedTree.elementAt(i);
            sw.setSelected(sw.isPreviousSelected());
            ((TreeItem)sw.getUiObject()).setChecked(sw.isPreviousSelected());
            CategoryWrap[] cws = sw.getChildren();
            int j = 0;
            while (j < cws.length) {
                CategoryWrap cw = cws[j];
                cw.setSelected(cw.isPreviousSelected());
                ((TreeItem)cw.getUiObject()).setChecked(cw.isPreviousSelected());
                ((TreeItem)cw.getUiObject()).setExpanded(false);
                FeatureWrap[] fws = cw.getChildren();
                int k = 0;
                while (k < fws.length) {
                    FeatureWrap fw = fws[k];
                    fw.setSelected(fw.isPreviousSelected());
                    Vector treeItems = fw.getUiObjects();
                    int l = 0;
                    while (l < treeItems.size()) {
                        ((TreeItem)treeItems.elementAt(l)).setChecked(fw.isPreviousSelected());
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void downloadNeededFeatureInfo() {
        final boolean previousNextBoolean = this.nextButton.getEnabled();
        if (this.taggedFeatures.size() < 1) {
            this.resolveDependency();
            this.finalizeAllCheckeds();
            if (!this.updateSpaceIndicators()) {
                this.recoverPreviousChecks();
                this.nextButton.setEnabled(previousNextBoolean);
                this.updateSpaceIndicators();
            }
            return;
        }
        this.featureList.setEnabled(false);
        this.backButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        final TaskTip progress = new TaskTip(this.screen.getShell(), 2);
        progress.setText(UIMessages.DownloadFeatureInfo);
        progress.setVisible(true);
        if (this.view.inputType != 4097) {
            this.cancelButton.setFocus();
        } else {
            this.screen.setFocus();
        }
        this.downloadFeatureJarMonitor = new UpdateMonitor();
        this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
        this.downloadFeatureJarThread.start();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    progress.setVisible(false);
                    progress.dispose();
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() == 2) {
                        SelectFeaturesScreen.this.resolveDependency();
                        SelectFeaturesScreen.this.finalizeAllCheckeds();
                        if (!SelectFeaturesScreen.this.updateSpaceIndicators()) {
                            SelectFeaturesScreen.this.recoverPreviousChecks();
                            SelectFeaturesScreen.this.nextButton.setEnabled(previousNextBoolean);
                            SelectFeaturesScreen.this.updateSpaceIndicators();
                        }
                    } else {
                        SelectFeaturesScreen.this.recoverPreviousChecks();
                        SelectFeaturesScreen.this.nextButton.setEnabled(previousNextBoolean);
                    }
                    SelectFeaturesScreen.this.featureList.setEnabled(true);
                    SelectFeaturesScreen.this.backButton.setEnabled(true);
                    SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                    SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                    SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                    boolean isAnyoneUnchecked = false;
                    int i = 0;
                    while (i < SelectFeaturesScreen.this.taggedFeatures.size()) {
                        TreeItem tItem;
                        int j;
                        Vector treeItems;
                        FeatureWrap fw = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(i);
                        if (fw.isFeatureReady()) {
                            boolean isCompatible = true;
                            if (SelectFeaturesScreen.this.isIncompatibleFeature(fw)) {
                                isCompatible = false;
                                fw.setSelected(false);
                            }
                            treeItems = fw.getUiObjects();
                            j = 0;
                            while (j < treeItems.size()) {
                                tItem = (TreeItem)treeItems.elementAt(j);
                                tItem.setText(fw.getShowedName());
                                if (!isCompatible) {
                                    tItem.setChecked(false);
                                    tItem.setGrayed(true);
                                    tItem.setImage(SelectFeaturesScreen.this.IMAGE_ICON_INCOMPATIBLE_FEATURE);
                                    isAnyoneUnchecked = true;
                                }
                                ++j;
                            }
                        } else {
                            treeItems = fw.getUiObjects();
                            j = 0;
                            while (j < treeItems.size()) {
                                tItem = (TreeItem)treeItems.elementAt(j);
                                tItem.setChecked(false);
                                tItem.setGrayed(true);
                                tItem.setImage(SelectFeaturesScreen.this.IMAGE_ICON_BROKEN_FEATURE);
                                isAnyoneUnchecked = true;
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (isAnyoneUnchecked) {
                        SelectFeaturesScreen.this.finalizeAllCheckeds();
                        SelectFeaturesScreen.this.updateSpaceIndicators();
                    }
                    SelectFeaturesScreen.this.featureList.setFocus();
                }
            }
        });
    }

    public void treeCollapsed(TreeEvent te) {
    }

    public void treeExpanded(TreeEvent te) {
        final TreeItem item = (TreeItem)te.item;
        if (item == null) {
            return;
        }
        INode expandedNode = null;
        int i = 0;
        while (i < this.view.viewedTree.size()) {
            expandedNode = ((INode)this.view.viewedTree.elementAt(i)).findByUiObject(item);
            if (expandedNode != null) break;
            ++i;
        }
        if (expandedNode instanceof CategoryWrap) {
            this.taggedFeatures.removeAllElements();
            FeatureWrap[] fws = ((CategoryWrap)expandedNode).getChildren();
            int i2 = 0;
            while (i2 < fws.length) {
                if (!fws[i2].isFeatureReady()) {
                    this.taggedFeatures.add(fws[i2]);
                }
                ++i2;
            }
            if (this.taggedFeatures.size() < 1) {
                return;
            }
            if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                this.featureList.setEnabled(false);
            } else {
                this.featureList.setVisible(false);
            }
            this.backButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            final boolean previousNextBoolean = this.nextButton.getEnabled();
            this.nextButton.setEnabled(false);
            final TaskTip progress = new TaskTip(this.screen.getShell(), 2);
            progress.setText(UIMessages.DownloadFeatureInfo);
            progress.setVisible(true);
            if (this.view.inputType != 4097) {
                this.cancelButton.setFocus();
            } else {
                this.screen.setFocus();
            }
            this.downloadFeatureJarMonitor = new UpdateMonitor();
            this.downloadFeatureJarThread = new DownloadFeatureJarThread("", this.taggedFeatures, this.downloadFeatureJarMonitor);
            this.downloadFeatureJarThread.start();
            Display.getCurrent().timerExec(400, new Runnable(){

                public void run() {
                    if (SelectFeaturesScreen.this.downloadFeatureJarThread.isAlive()) {
                        Display.getCurrent().timerExec(400, (Runnable)this);
                    } else {
                        progress.setVisible(false);
                        progress.dispose();
                        if (SelectFeaturesScreen.this.downloadFeatureJarThread.getStatus() != 2) {
                            item.setExpanded(false);
                        }
                        if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                            SelectFeaturesScreen.this.featureList.setEnabled(true);
                        } else {
                            SelectFeaturesScreen.this.featureList.setVisible(true);
                        }
                        SelectFeaturesScreen.this.backButton.setEnabled(true);
                        SelectFeaturesScreen.this.cancelButton.setEnabled(false);
                        SelectFeaturesScreen.this.nextButton.setEnabled(previousNextBoolean);
                        SelectFeaturesScreen.this.downloadFeatureJarThread = null;
                        SelectFeaturesScreen.this.downloadFeatureJarMonitor = null;
                        boolean isCompatible = true;
                        int i = 0;
                        while (i < SelectFeaturesScreen.this.taggedFeatures.size()) {
                            FeatureWrap fw = (FeatureWrap)SelectFeaturesScreen.this.taggedFeatures.elementAt(i);
                            if (fw.isFeatureReady()) {
                                isCompatible = true;
                                if (SelectFeaturesScreen.this.isIncompatibleFeature(fw)) {
                                    isCompatible = false;
                                    fw.setSelected(false);
                                }
                                Vector treeItems = fw.getUiObjects();
                                int j = 0;
                                while (j < treeItems.size()) {
                                    TreeItem tItem = (TreeItem)treeItems.elementAt(j);
                                    tItem.setText(fw.getShowedName());
                                    if (!isCompatible) {
                                        tItem.setGrayed(true);
                                        tItem.setImage(SelectFeaturesScreen.this.IMAGE_ICON_INCOMPATIBLE_FEATURE);
                                        tItem.setChecked(false);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        SelectFeaturesScreen.this.featureList.setFocus();
                    }
                }
            });
        }
    }

    private class DownloadFeatureJarThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int ENDED = 3;
        private Vector tags;
        private IProgressMonitor monitor;
        private int currentStatus;

        public DownloadFeatureJarThread(String name, Vector taggs, IProgressMonitor downloadMonitor) {
            super(name);
            this.tags = taggs;
            this.monitor = downloadMonitor;
            this.currentStatus = 0;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 119->123)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int getStatus() {
            return this.currentStatus;
        }
    }
}

