/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.util.INode;

public class FeatureWrap
implements INode {
    public static final int UNKNOWN = 0;
    public static final int RESOLVED = 1;
    public static final int NO_RESOLVED = 2;
    public static final int FEATURE_UNKNOWN = 16;
    public static final int FEATURE_BRAND_NEW = 17;
    public static final int FEATURE_DUPLICATE = 18;
    public static final int FEATURE_UPDATES = 19;
    private VersionedIdentifier vid = null;
    private String showedName = "";
    private ISiteFeatureReference featureReference = null;
    private boolean selected = false;
    private IFeature feature = null;
    private String version = "?.?.?";
    private Vector uiObjects = new Vector();
    private boolean previousSelected = false;
    private int resolvedStatus = 0;
    private int featureUniquenessStatus = 16;

    public FeatureWrap() {
    }

    public FeatureWrap(ISiteFeatureReference featureReference) {
        this.featureReference = featureReference;
        try {
            this.vid = featureReference.getVersionedIdentifier();
            this.version = this.vid.getVersion().toString();
            this.showedName = "{" + this.vid.getIdentifier() + "}" + " (" + this.version + ")";
        }
        catch (CoreException coreException) {}
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Vector getUiObjects() {
        return this.uiObjects;
    }

    public void addUiObject(Object uiObject) {
        this.uiObjects.add(uiObject);
    }

    public String getShowedName() {
        return this.showedName;
    }

    public INode findByUiObject(Object uiObject) {
        int i = 0;
        while (i < this.uiObjects.size()) {
            if (this.uiObjects.elementAt(i).equals(uiObject)) {
                return this;
            }
            ++i;
        }
        return null;
    }

    public boolean isFeatureReady() {
        return this.feature != null;
    }

    public boolean downloadFeature(IProgressMonitor monitor) {
        if (this.feature == null) {
            try {
                this.feature = this.featureReference.getFeature(monitor);
                this.showedName = String.valueOf(this.feature.getLabel()) + " (" + this.version + ")";
                return true;
            }
            catch (CoreException coreException) {
                this.feature = null;
            }
        }
        return false;
    }

    public long getFeatureIncludeSize() {
        long totalSize;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (totalSize = this.feature.getDownloadSize() + this.feature.getInstallSize()) > 0L) {
            return totalSize;
        }
        return 0L;
    }

    public long getFeatureSize() {
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null) {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.feature.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.feature.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            long featureSize = 0L;
            try {
                featureSize = this.feature.getFeatureContentProvider().getDownloadSizeFor(totalPlugins, totalNonPlugins) + this.feature.getFeatureContentProvider().getInstallSizeFor(totalPlugins, totalNonPlugins);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (featureSize > 0L) {
                return featureSize;
            }
        }
        return 0L;
    }

    public String getDescription() {
        IURLEntry description;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (description = this.feature.getDescription()) != null) {
            return description.getAnnotation();
        }
        return "";
    }

    public String getLicense() {
        IURLEntry license;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (license = this.feature.getLicense()) != null) {
            return license.getAnnotation();
        }
        return "";
    }

    public IFeature getFeature() {
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        return this.feature;
    }

    public void releaseFeature() {
        this.feature = null;
    }

    public boolean isPreviousSelected() {
        return this.previousSelected;
    }

    public void setPreviousSelected(boolean previousSelected) {
        this.previousSelected = previousSelected;
    }

    public int getResolvedStatus() {
        return this.resolvedStatus;
    }

    public void setResolvedStatus(int resolvedStatus) {
        this.resolvedStatus = resolvedStatus;
    }

    public VersionedIdentifier getVID() {
        return this.vid;
    }

    public int getFeatureUniquenessStatus() {
        return this.featureUniquenessStatus;
    }

    public void setFeatureUniquenessStatus(int uniquenessStatus) {
        this.featureUniquenessStatus = uniquenessStatus;
    }
}

