/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Canvas
extends Composite {
    private Listener mouseListener;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
        final Canvas temp = this;
        this.mouseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == temp && event.type == 3) {
                    Canvas.this.postEvent(event.type, event);
                    temp.forceFocus();
                }
            }
        };
        parent.getDisplay().addFilter(3, this.mouseListener);
    }

    boolean isTrueComposite() {
        return false;
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        this.update();
        Rectangle clientArea = this.getClientArea();
        clientArea.x = 0;
        clientArea.y = 0;
        Rectangle originalRect = new Rectangle(x, y, width, height);
        Rectangle intersection = clientArea.intersection(originalRect);
        if (intersection.isEmpty() && !clientArea.intersects(intersection.x + deltaX, intersection.y + deltaY, intersection.width, intersection.height)) {
            this.redraw();
        } else {
            boolean disjoint;
            GC gc = new GC(this);
            gc.copyArea(intersection.x, intersection.y, intersection.width, intersection.height, intersection.x + deltaX, intersection.y + deltaY);
            gc.dispose();
            boolean bl = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                this.redraw(x, y, width, height, false);
            } else {
                if (deltaX != 0) {
                    int newX = deltaX < 0 ? Math.min(y + width, clientArea.width) + deltaX : Math.max(0, y);
                    this.redraw(newX, y, Math.abs(deltaX), height, false);
                }
                if (deltaY != 0) {
                    int newY = deltaY < 0 ? Math.min(y + height, clientArea.height) + deltaY : Math.max(0, y);
                    this.redraw(x, newY, width, Math.abs(deltaY), false);
                }
            }
        }
        if (all) {
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < this.children.length; ++i) {
                Control child = this.children[i];
                if (child == null) continue;
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) < Math.max(x, rect.x) || Math.min(y + height, rect.y + rect.height) < Math.max(y, rect.y)) continue;
                child.setLocation(rect.x + deltaX, rect.y + deltaY);
            }
        }
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }

    protected void removeInternalFilter() {
        if (this.mouseListener != null) {
            this.getDisplay().removeFilter(3, this.mouseListener);
        }
    }
}

