/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.expanded.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.RGBUtils;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree tree;
    TreeItem parentItem;
    int id;
    TreeItem[] children = new TreeItem[0];
    Font font = null;
    int fgRGB = -1;
    int bgRGB = -1;
    private int remainStart = 0;
    private int itemCount = 0;

    public TreeItem(Tree parent, int style) {
        super(parent, style);
        this.tree = parent;
        this.createWidget(-1);
        parent.addChild(this, -1);
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        if (index < 0) {
            TreeItem.error(6);
        }
        if (index > parent.getNumChildren()) {
            TreeItem.error(6);
        }
        this.tree = parent;
        this.createWidget(index);
        parent.addChild(this, index);
    }

    public TreeItem(TreeItem parent, int style) {
        super(TreeItem.checkNull(parent), style);
        this.parentItem = parent;
        this.tree = this.parentItem.tree;
        this.createWidget(-1);
        this.parentItem.addChild(this, -1);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            TreeItem.error(4);
        }
        return item;
    }

    static Control checkNull(Control tree) {
        if (tree == null) {
            TreeItem.error(4);
        }
        return tree;
    }

    public TreeItem(TreeItem parent, int style, int index) {
        super(TreeItem.checkNull(parent), style);
        if (index < 0) {
            TreeItem.error(6);
        }
        if (index > parent.getNumChildren()) {
            TreeItem.error(6);
        }
        this.parentItem = parent;
        this.tree = this.parentItem.tree;
        this.createWidget(index);
        this.parentItem.addChild(this, index);
    }

    void addChild(TreeItem item, int index) {
        int size = this.children.length;
        if (this.getNumChildren() == size) {
            TreeItem[] newItems = new TreeItem[size + 4];
            System.arraycopy(this.children, 0, newItems, 0, size);
            this.children = newItems;
        }
        if (index == -1) {
            int i = this.getNumChildren();
            this.children[i] = item;
        } else if (this.children[index] == null) {
            this.children[index] = item;
        } else {
            int num = this.getNumChildren();
            for (int i = num - 1; i >= index; --i) {
                this.children[i + 1] = this.children[i];
            }
            this.children[index] = item;
        }
    }

    void destroy() {
        this.destroyChildren();
        OS.TreeItem_Delete(this.internal_handle);
        TreeItem parent = this.getParentItem();
        if (parent == null) {
            this.getTree().removeChild(this);
        } else {
            parent.removeChild(this);
        }
        this.tree.itemDeleted(this);
    }

    void destroyChildren() {
        TreeItem[] childItems = this.getItems();
        for (int i = 0; i < childItems.length; ++i) {
            TreeItem item = childItems[i];
            item.dispose();
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bgRGB == -1) {
            return this.tree.getBackground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.bgRGB);
        return new Color(this.getDisplay(), rgbObject);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] rect = OS.TreeItem_GetTextBounds(this.internal_handle);
        return new Rectangle(rect[0], rect[1], rect[2], rect[3]);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.tree.internal_style & 0x20) == 0) {
            return false;
        }
        return OS.TreeItem_IsChecked(this.internal_handle);
    }

    public boolean getExpanded() {
        this.checkWidget();
        return OS.TreeItem_IsExpanded(this.internal_handle);
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == null ? this.getParent().getFont() : this.font;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fgRGB == -1) {
            return this.tree.getForeground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.fgRGB);
        return new Color(this.getDisplay(), rgbObject);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.tree.internal_style & 0x20) == 0) {
            return false;
        }
        return OS.TreeItem_IsGrayed(this.internal_handle);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.tree.isVirtual) {
            return this.itemCount;
        }
        return this.getNumChildren();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int size = this.getNumChildren();
        if (size == 0) {
            return new TreeItem[0];
        }
        TreeItem[] items = new TreeItem[size];
        System.arraycopy(this.children, 0, items, 0, size);
        return items;
    }

    int getNumChildren() {
        int size = 0;
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            ++size;
        }
        return size;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.tree;
    }

    Tree getTree() {
        return this.tree;
    }

    boolean hasNativeEvents() {
        return false;
    }

    protected void internal_createHandle(int index) {
        this.tree.assignId(this);
        int parentHandle = this.parentItem == null ? this.tree.internal_handle : this.parentItem.internal_handle;
        this.internal_handle = OS.TreeItem_New(this.tree.internal_handle, parentHandle, this.id, index);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    void internalClear() {
        this.parentItem = null;
        this.tree = null;
        this.image = null;
        this.releaseHandle();
    }

    void remove() {
        super.releaseWidget();
        this.destroy();
        this.internalClear();
    }

    protected void releaseHandle() {
        this.internal_handle = 0;
        this.display = null;
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.destroy();
        this.internalClear();
    }

    void removeChild(TreeItem item) {
        int childIndex = -1;
        int numChildren = this.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            if (this.children[i] != item) continue;
            childIndex = i;
            break;
        }
        if (childIndex == -1) {
            return;
        }
        int size = this.children.length;
        TreeItem[] newItems = new TreeItem[size];
        System.arraycopy(this.children, 0, newItems, 0, childIndex);
        System.arraycopy(this.children, childIndex + 1, newItems, childIndex, size - (childIndex + 1));
        this.children = newItems;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.bgRGB = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (color == null) {
            OS.TreeItem_SetBackground(this.internal_handle, 0);
        } else {
            OS.TreeItem_SetBackground(this.internal_handle, color.internal_handle);
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.tree.getStyle() & 0x20) == 0) {
            return;
        }
        OS.TreeItem_SetChecked(this.internal_handle, checked);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        OS.TreeItem_SetExpanded(this.internal_handle, expanded);
    }

    public void setFont(Font font) {
        int fontHandle;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            fontHandle = font.internal_handle;
        } else {
            fontHandle = 0;
        }
        OS.TreeItem_SetFont(this.internal_handle, fontHandle);
        this.font = font;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.fgRGB = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (color == null) {
            OS.TreeItem_SetForeground(this.internal_handle, 0);
        } else {
            OS.TreeItem_SetForeground(this.internal_handle, color.internal_handle);
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.tree.getStyle() & 0x20) == 0) {
            return;
        }
        OS.TreeItem_SetGrayed(this.internal_handle, grayed);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            TreeItem.error(5);
        }
        int imageHandle = image == null ? 0 : image.internal_handle;
        OS.TreeItem_SetImage(this.internal_handle, imageHandle);
        super.setImage(image);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            TreeItem.error(4);
        }
        OS.TreeItem_SetText(this.internal_handle, string);
        super.setText(string);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int itemCount = this.itemCount;
        if (count == itemCount) {
            return;
        }
        for (int index = count; index < itemCount; ++index) {
            TreeItem item = this.children[index];
            if (item == null || item.isDisposed()) continue;
            item.dispose();
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TreeItem[] newItems = new TreeItem[length];
        System.arraycopy(this.children, 0, newItems, 0, Math.min(count, itemCount));
        this.children = newItems;
        if (this.tree.isVirtual) {
            OS.TreeItem_SetItemCount(this.internal_handle, count);
            this.remainStart = itemCount;
        }
        this.itemCount = count;
    }

    void createRemainItem() {
        if (!this.tree.isVirtual) {
            return;
        }
        while (this.remainStart < this.itemCount) {
            this.children[this.remainStart] = new TreeItem(this, 2048);
            ++this.remainStart;
        }
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            TreeItem.error(4);
        }
        if (item.isDisposed()) {
            TreeItem.error(5);
        }
        int idx = -1;
        for (int i = 0; i < this.children.length && idx == -1; ++i) {
            if (this.children[i] == null) continue;
            TreeItem child = this.children[i];
            if (child.id == item.id) {
                return i;
            }
            idx = child.indexOf(item);
        }
        return idx;
    }
}

