/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.app.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.ercp.app.Messages;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class NormalView
extends ViewPart
implements ControlListener,
IOpenListener,
SelectionListener {
    private TableViewer viewer;
    private EmailTableModel model = new EmailTableModel();
    private Composite parent;
    private Composite c1;
    private Composite c2;
    private Composite current;
    private Command emaiListCommand;
    private Command viewMessageCommand;

    private void enableListCommand(boolean enable) {
        if (enable) {
            this.emaiListCommand = new Command((Control)this.c1, 2, 1);
            this.emaiListCommand.setText(Messages.getString("NormalView.9"));
            this.emaiListCommand.addSelectionListener((SelectionListener)this);
            this.current = this.c1;
            this.c1.setFocus();
        } else if (this.emaiListCommand != null) {
            this.emaiListCommand.dispose();
        }
    }

    private void enableLaunchCommand(boolean enable) {
        if (enable) {
            this.viewMessageCommand = new Command((Control)this.c2, 2, 1);
            this.viewMessageCommand.setText(Messages.getString("NormalView.10"));
            this.viewMessageCommand.addSelectionListener((SelectionListener)this);
            this.current = this.c2;
            this.c2.setFocus();
        } else {
            this.viewMessageCommand.dispose();
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.addControlListener((ControlListener)this);
        parent.setLayout(null);
        this.c2 = new Composite(parent, 0);
        this.c2.setLayout((Layout)new FillLayout());
        this.c2.setVisible(true);
        this.viewer = new TableViewer(this.c2, 772);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(Messages.getString("NormalView.11"));
        TableColumn tcDate = new TableColumn(table, 16384);
        tcDate.setText(Messages.getString("NormalView.12"));
        tc = new TableColumn(table, 16384);
        tc.setText(Messages.getString("NormalView.13"));
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.model.emails);
        this.viewer.addOpenListener((IOpenListener)this);
        int i = 0;
        int n = table.getColumnCount();
        while (i < n) {
            table.getColumn(i).pack();
            ++i;
        }
        tcDate.setWidth(0);
        table.setHeaderVisible(true);
        this.c1 = new Composite(parent, 0);
        this.c1.setLayout((Layout)new FillLayout());
        this.c1.setVisible(false);
        Text text = new Text(this.c1, 0);
        text.setText(Messages.getString("NormalView.14"));
        this.enableLaunchCommand(true);
        this.c1.layout();
        this.c2.layout();
    }

    public void setFocus() {
        this.c1.setSize(this.parent.getSize());
        this.c2.setSize(this.parent.getSize());
        this.current.setFocus();
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.c1.setSize(this.parent.getSize());
        this.c2.setSize(this.parent.getSize());
    }

    public void open(OpenEvent event) {
        this.launchSelection(event.getSelection());
    }

    private void launchSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.c1.setVisible(true);
        this.c2.setVisible(false);
        this.enableLaunchCommand(false);
        this.enableListCommand(true);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.viewMessageCommand) {
            this.launchSelection(this.viewer.getSelection());
        } else if (e.widget == this.emaiListCommand) {
            this.c1.setVisible(false);
            this.c2.setVisible(true);
            this.enableLaunchCommand(true);
            this.enableListCommand(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    class Email {
        private String date;
        private String name;
        private String subject;

        public Email(String name, String date, String subject) {
            this.setName(name);
            this.setDate(date);
            this.setSubject(subject);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }

    class EmailTableModel {
        Email[] emails = new Email[3];

        public EmailTableModel() {
            this.emails[0] = new Email("Markleo Ruben", this.getDate(2005, 9, 16, 9, 32), Messages.getString("NormalView.0"));
            this.emails[1] = new Email("Michelle Guang", this.getDate(2005, 9, 8, 4, 21), Messages.getString("NormalView.4"));
            this.emails[2] = new Email("Aggrawal Vijjay", this.getDate(2005, 8, 7, 19, 2), Messages.getString("NormalView.6"));
        }

        public String getDate(int year, int month, int date, int hour, int minute) {
            GregorianCalendar liftOffApollo11 = new GregorianCalendar(year, month, date, hour, minute);
            Date d = liftOffApollo11.getTime();
            SimpleDateFormat df1 = new SimpleDateFormat("MM/dd/yy");
            DateFormat df2 = DateFormat.getTimeInstance(3);
            String s1 = df1.format(d);
            String s2 = df2.format(d);
            return String.valueOf(s1) + " " + s2;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return (Email[])parent;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Email email = (Email)obj;
            String text = "";
            switch (index) {
                case 0: {
                    text = email.getName();
                    break;
                }
                case 1: {
                    text = email.getDate();
                    break;
                }
                case 2: {
                    text = email.getSubject();
                }
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public void addListener(ILabelProviderListener listener) {
        }
    }
}

