/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;

public class SimpleBufferedInputStream
extends InputStream {
    InputStream in;
    byte[] buf;
    int bytesAvailable;
    int pos;
    static final int DefaultBufferSize = 2048;

    public SimpleBufferedInputStream(InputStream in) throws IOException {
        this.in = in;
        this.pos = 0;
        this.buf = new byte[2048];
        this.fillByteBuffer();
    }

    public int read() throws IOException {
        if (this.pos < this.bytesAvailable) {
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.fillByteBuffer() != -1) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
            int required;
            if (length == 0) {
                return 0;
            }
            if (this.pos < this.bytesAvailable) {
                int copylength = this.bytesAvailable - this.pos >= length ? length : this.bytesAvailable - this.pos;
                System.arraycopy(this.buf, this.pos, buffer, offset, copylength);
                this.pos += copylength;
                if (copylength == length || this.in.available() == 0) {
                    return copylength;
                }
                offset += copylength;
                required = length - copylength;
            } else {
                required = length;
            }
            while (true) {
                int read;
                if (required >= this.buf.length) {
                    read = this.in.read(buffer, offset, required);
                    if (read == -1) {
                        return required == length ? -1 : length - required;
                    }
                } else {
                    if (this.fillByteBuffer() == -1) {
                        return required == length ? -1 : length - required;
                    }
                    read = this.bytesAvailable - this.pos >= required ? required : this.bytesAvailable - this.pos;
                    System.arraycopy(this.buf, this.pos, buffer, offset, read);
                    this.pos += read;
                }
                if ((required -= read) == 0) {
                    return length;
                }
                if (this.in.available() == 0) {
                    return length - required;
                }
                offset += read;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void unread(byte[] bytes, int length) {
        if (this.pos >= length) {
            this.pos -= length;
        } else {
            int bytesToRestore = length - this.pos;
            byte[] newBuffer = new byte[this.buf.length + bytesToRestore];
            System.arraycopy(bytes, 0, newBuffer, 0, bytesToRestore);
            System.arraycopy(this.buf, 0, newBuffer, bytesToRestore, this.buf.length);
            this.buf = newBuffer;
        }
    }

    int fillByteBuffer() throws IOException {
        int result = this.in.read(this.buf, 0, this.buf.length);
        this.bytesAvailable = result == -1 ? 0 : result;
        this.pos = 0;
        return result;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.buf = null;
    }

    public int available() throws IOException {
        return this.bytesAvailable - this.pos + this.in.available();
    }

    public synchronized long skip(long amount) throws IOException {
        if (amount < 1L) {
            return 0L;
        }
        if ((long)(this.bytesAvailable - this.pos) >= amount) {
            this.pos = (int)((long)this.pos + amount);
            return amount;
        }
        long read = this.bytesAvailable - this.pos;
        this.pos = this.bytesAvailable;
        return read + this.in.skip(amount - read);
    }
}

