/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.CommandButton;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbsScreen
implements SelectionListener,
ControlListener {
    protected final int NONE = 0;
    protected final int BACK = 1;
    protected final int CANCEL = 2;
    protected final int NEXT = 3;
    protected final int FINISHED = 4;
    NormalView view;
    Composite screen;
    Composite screenPane;
    WrappedLabel titleLabel;
    CommandButton backButton;
    CommandButton cancelButton;
    CommandButton nextButton;
    Composite buttonPane;

    public AbsScreen() {
    }

    public AbsScreen(NormalView normalView) {
        this.view = normalView;
    }

    public void show(boolean bl) {
        if (this.screen == null) {
            this.createScreen();
        }
        if (bl) {
            this.refresh();
            this.setVisible(true);
            this.action();
        } else {
            this.setVisible(true);
        }
    }

    public void setVisible(boolean bl) {
        this.screen.setVisible(bl);
        if (bl) {
            this.setDefaultFocus();
        }
    }

    protected abstract void createScreen();

    protected abstract void refresh();

    protected abstract void action();

    protected abstract void setDefaultFocus();

    protected void init(String string) {
        this.init(string, false);
    }

    protected Composite init(String string, boolean bl) {
        if (bl) {
            this.screen = new Composite(this.view.parent, 512);
            this.screen.getVerticalBar().setVisible(false);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = new Composite(this.screen, 0);
            this.screenPane.setLayout((Layout)new GridLayout(1, false));
            this.screenPane.setLayoutData((Object)new GridData(1808));
        } else {
            this.screen = new Composite(this.view.parent, 0);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = this.screen;
        }
        if (string != null) {
            this.titleLabel = new WrappedLabel(this.screenPane, 0, 0);
            if (3 == this.view.osType) {
                this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 7, 1));
            } else {
                this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 10, 1));
            }
            this.titleLabel.setText(string);
        }
        return this.screenPane;
    }

    protected void fillSpace() {
        new Composite(this.screenPane, 0).setLayoutData((Object)new GridData(1040));
    }

    protected void separator() {
        if (3 == this.view.osType) {
            return;
        }
        new Label(this.screenPane, 258).setLayoutData((Object)new GridData(768));
    }

    protected void setButtons(int n, int n2, int n3) {
        if (9 == this.view.runtimeType && this.view.isDPI192Device) {
            this.setButtons_onSprintRafael(n, n2, n3);
            return;
        }
        this.buttonPane = new Composite(this.screenPane, 0);
        GridData gridData = new GridData(768);
        this.buttonPane.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.justify = true;
        rowLayout.wrap = false;
        this.buttonPane.setLayout((Layout)rowLayout);
        int n4 = 1;
        if (this.view.osType == 3) {
            n4 = 8;
        }
        if (n == 1) {
            this.backButton = this.view.inputType == 4097 ? new CommandButton(this.screen, n4, 12) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.backButton.setFont(this.view.fontOnS60);
            }
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener(this);
        }
        if (n2 == 2) {
            this.cancelButton = this.view.inputType == 4097 ? new CommandButton(this.screen, n4, 11) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.cancelButton.setFont(this.view.fontOnS60);
            }
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener(this);
        }
        if (n3 != 0) {
            this.nextButton = this.view.inputType == 4097 ? new CommandButton(this.screen, n4, 13) : new CommandButton(this.buttonPane, 8);
            if (3 == this.view.osType) {
                this.nextButton.setFont(this.view.fontOnS60);
            }
            if (n3 == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener(this);
        }
        this.buttonPane.layout();
        if (this.view.inputType != 4097 && this.nextButton != null && this.nextButton.getLocation().x > this.screenPane.getSize().x) {
            rowLayout.wrap = true;
            this.buttonPane.setLayoutData((Object)new GridData(768));
            this.screen.layout();
        }
    }

    public abstract void widgetSelected(SelectionEvent var1);

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
    }

    private void setButtons_onSprintRafael(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        this.buttonPane = new Composite(this.screenPane, 0);
        this.buttonPane.setLayoutData((Object)new GridData(768));
        this.buttonPane.setLayout((Layout)new FormLayout());
        if (n == 1) {
            ++n4;
        }
        if (n2 == 2) {
            ++n4;
        }
        if (n3 != 0) {
            ++n4;
        }
        FormData[] formDataArray = new FormData[n4];
        if (n4 == 1) {
            formDataArray[0] = new FormData();
            formDataArray[0].top = new FormAttachment(0, 0);
            formDataArray[0].bottom = new FormAttachment(100, -5);
            formDataArray[0].left = new FormAttachment(35, 0);
            formDataArray[0].right = new FormAttachment(65, 0);
        } else if (n4 == 2) {
            formDataArray[0] = new FormData();
            formDataArray[0].top = new FormAttachment(0, 0);
            formDataArray[0].bottom = new FormAttachment(100, -5);
            formDataArray[0].left = new FormAttachment(5, 0);
            formDataArray[0].right = new FormAttachment(35, 0);
            formDataArray[1] = new FormData();
            formDataArray[1].top = new FormAttachment(0, 0);
            formDataArray[1].bottom = new FormAttachment(100, -5);
            formDataArray[1].left = new FormAttachment(65, 0);
            formDataArray[1].right = new FormAttachment(95, 0);
        } else if (n4 == 3) {
            formDataArray[0] = new FormData();
            formDataArray[0].top = new FormAttachment(0, 0);
            formDataArray[0].bottom = new FormAttachment(100, -5);
            formDataArray[0].left = new FormAttachment(6, 0);
            formDataArray[0].right = new FormAttachment(30, 0);
            formDataArray[1] = new FormData();
            formDataArray[1].top = new FormAttachment(0, 0);
            formDataArray[1].bottom = new FormAttachment(100, -5);
            formDataArray[1].left = new FormAttachment(38, 0);
            formDataArray[1].right = new FormAttachment(62, 0);
            formDataArray[2] = new FormData();
            formDataArray[2].top = new FormAttachment(0, 0);
            formDataArray[2].bottom = new FormAttachment(100, -5);
            formDataArray[2].left = new FormAttachment(70, 0);
            formDataArray[2].right = new FormAttachment(94, 0);
        }
        if (n == 1) {
            this.backButton = new CommandButton(this.buttonPane, 8);
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener(this);
            this.backButton.setLayoutData(formDataArray[n5++]);
        }
        if (n2 == 2) {
            this.cancelButton = new CommandButton(this.buttonPane, 8);
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener(this);
            this.cancelButton.setLayoutData(formDataArray[n5++]);
        }
        if (n3 != 0) {
            this.nextButton = new CommandButton(this.buttonPane, 8);
            if (n3 == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener(this);
            this.nextButton.setLayoutData(formDataArray[n5++]);
        }
        this.buttonPane.layout();
    }
}

