/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.internal.scheduler.ScheduledPluginUninstall;
import org.eclipse.update.internal.scheduler.ScheduledSiteInitialize;

public class RootScreen
extends AbsScreen {
    private Button installButton;
    private Button updateButton;
    private Button manageButton;
    private Button widestButton;

    public RootScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectOption);
        if (9 == this.view.runtimeType && this.view.isDPI192Device) {
            this.createScreen_onSprintRafael();
            return;
        }
        ((GridLayout)this.screen.getLayout()).verticalSpacing = "unknown".equals(Platform.getOS()) ? 10 : 20;
        this.installButton = new Button(this.screen, 8);
        this.installButton.setText(UIMessages.InstallFeatures);
        this.installButton.addSelectionListener((SelectionListener)this);
        this.updateButton = new Button(this.screen, 8);
        this.updateButton.setText(UIMessages.UpdateAllFeatures);
        this.updateButton.addSelectionListener((SelectionListener)this);
        this.manageButton = new Button(this.screen, 8);
        this.manageButton.setText(UIMessages.ManageFeatures);
        this.manageButton.addSelectionListener((SelectionListener)this);
        if (3 == this.view.osType) {
            this.installButton.setForeground(this.view.colorOnS60);
            this.updateButton.setForeground(this.view.colorOnS60);
            this.manageButton.setForeground(this.view.colorOnS60);
        }
        this.screen.layout();
        this.environmentInitialize();
        this.widestButton = this.installButton.getBounds().width > this.updateButton.getBounds().width ? this.installButton : this.updateButton;
        if (this.widestButton.getBounds().width < this.manageButton.getBounds().width) {
            this.widestButton = this.manageButton;
        }
    }

    protected void environmentInitialize() {
        ScheduledPluginUninstall.uninstallFeatures();
        try {
            this.view.targetSite = ScheduledSiteInitialize.createTargetSite();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (ScheduledSiteInitialize.isRestartNeeded()) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(UIMessages.ConfirmRestart);
            messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestartForMigration, (Object[])this.view.RuntimeName));
            if (messageBox.open() == 64) {
                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                PlatformUI.getWorkbench().close();
            }
        }
        if (System.getProperty("sun.net.client.defaultConnectTimeout") == null) {
            System.setProperty("sun.net.client.defaultConnectTimeout", "6000");
        }
    }

    public void refresh() {
        Font font = null;
        FontData fontData = null;
        int n = this.screen.getShell().getClientArea().width - this.widestButton.getBounds().x - 5;
        if (this.widestButton.getBounds().width > n && this.widestButton.getFont().getFontData().length > 0) {
            fontData = this.widestButton.getFont().getFontData()[0];
            font = new Font((Device)Display.getCurrent(), fontData);
            this.installButton.setFont(font);
            this.updateButton.setFont(font);
            this.manageButton.setFont(font);
            font = null;
            while (this.widestButton.computeSize((int)-1, (int)-1).x > n) {
                if (fontData.getHeight() < 6) break;
                fontData.setHeight(fontData.getHeight() - 1);
                font = new Font((Device)Display.getCurrent(), fontData);
                this.widestButton.setFont(font);
            }
            if (font != null) {
                this.installButton.setFont(font);
                this.updateButton.setFont(font);
                this.manageButton.setFont(font);
                this.screen.layout();
            }
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.screen.setFocus();
        this.installButton.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.installButton) {
            this.view.refreshInstalledFeatures();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (selectionEvent.widget == this.updateButton) {
            this.view.refreshInstalledFeatures();
            this.view.availableFeatures.removeAllElements();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(9, true);
        } else if (selectionEvent.widget == this.manageButton) {
            this.view.refreshInstalledFeatures();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(10, true);
        }
    }

    private void createScreen_onSprintRafael() {
        Composite composite = new Composite(this.screen, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(1808));
        FormData formData = new FormData();
        formData.top = new FormAttachment(10, 0);
        formData.bottom = new FormAttachment(26, 0);
        formData.left = new FormAttachment(0, 2);
        formData.right = new FormAttachment(100, -2);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(30, 0);
        formData2.bottom = new FormAttachment(46, 0);
        formData2.left = new FormAttachment(0, 2);
        formData2.right = new FormAttachment(100, -2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment(50, 0);
        formData3.bottom = new FormAttachment(66, 0);
        formData3.left = new FormAttachment(0, 2);
        formData3.right = new FormAttachment(100, -2);
        this.installButton = new Button(composite, 8);
        this.installButton.setText(UIMessages.InstallFeatures);
        this.installButton.addSelectionListener((SelectionListener)this);
        this.installButton.setLayoutData((Object)formData);
        this.updateButton = new Button(composite, 8);
        this.updateButton.setText(UIMessages.UpdateAllFeatures);
        this.updateButton.addSelectionListener((SelectionListener)this);
        this.updateButton.setLayoutData((Object)formData2);
        this.manageButton = new Button(composite, 8);
        this.manageButton.setText(UIMessages.ManageFeatures);
        this.manageButton.addSelectionListener((SelectionListener)this);
        this.manageButton.setLayoutData((Object)formData3);
        this.screen.layout();
        this.environmentInitialize();
        this.widestButton = this.installButton;
    }
}

