/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScrolledText
extends Composite {
    public Text text;
    private int maxTextHeight = Integer.MAX_VALUE;
    private boolean isScrollenabled = true;

    public ScrolledText(Composite composite, int n, int n2) {
        super(composite, n);
        this.init(n2, -1);
    }

    public ScrolledText(Composite composite, int n, int n2, int n3) {
        super(composite, n2);
        this.init(n2, n3);
    }

    private void init(int n, int n2) {
        if (n2 < 0) {
            this.isScrollenabled = false;
        }
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(768));
        this.text = new Text((Composite)this, n | 0x40 | 0x200);
        this.text.setEditable(false);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)formData);
        if (n2 >= 0) {
            this.text.setText("");
            this.maxTextHeight = this.text.computeSize((int)-1, (int)-1).y * n2;
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        if (!this.isScrollenabled) {
            return super.computeTrim(n, n2, n3, n4);
        }
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        if (rectangle.height > this.maxTextHeight) {
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width, this.maxTextHeight);
        }
        return rectangle;
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public void setForeground(Color color) {
        this.text.setForeground(color);
    }

    public void setSelection(int n, int n2) {
        this.text.setSelection(n, n2);
    }

    public void setText(String string) {
        this.text.setText(string);
    }
}

