/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UninstallScreen
extends AbsScreen {
    private static final int PROGRESS_MAX_VALUE = 20;
    private Composite pane;
    private Label featureLabel;
    private Label featureName;
    private ProgressBar featureProgress;
    private IFeature uninstalledFeature;
    boolean isThreadStarted = false;
    private boolean isMessageBoxOpening = false;

    UninstallScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new GridLayout(1, false));
        this.featureLabel = new Label(this.pane, 0);
        this.featureLabel.setText(UIMessages.Uninstalling);
        this.featureName = new Label(this.pane, 0);
        this.featureName.setLayoutData((Object)new GridData(768));
        this.featureProgress = new ProgressBar(this.screen, 65536);
        this.featureProgress.setMaximum(20);
        this.featureProgress.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        if (3 == this.view.osType) {
            this.featureLabel.setFont(this.view.fontOnS60);
            this.featureName.setFont(this.view.fontOnS60);
        }
        this.screen.layout();
    }

    public void refresh() {
        this.uninstalledFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        this.featureName.setText(this.uninstalledFeature.getLabel());
        this.screen.layout();
    }

    protected void action() {
        this.isThreadStarted = false;
        Display.getCurrent().timerExec(500, new Runnable(){

            public void run() {
                if (UninstallScreen.this.isThreadStarted) {
                    return;
                }
                UninstallScreen.this.isThreadStarted = true;
                UninstallScreen.this.action2();
            }
        });
        this.featureProgress.setSelection(4);
    }

    protected void setDefaultFocus() {
        this.pane.setFocus();
    }

    protected void action2() {
        ShowFinalDialogRunnable showFinalDialogRunnable = null;
        String string = null;
        if (this.uninstalledFeature == null) {
            this.uninstalledFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        }
        if (9 == this.view.runtimeType) {
            string = this.getImpactedShortcut();
            System.out.println("[eUpdate debug] Impacted application plugin is \"" + string + "\"");
        }
        IConfiguredSite iConfiguredSite = null;
        iConfiguredSite = this.uninstalledFeature.getSite().getCurrentConfiguredSite();
        this.featureProgress.setSelection(6);
        if (iConfiguredSite == null) {
            System.out.println("Error: error to get configured site for uninstallation.");
            return;
        }
        boolean bl = false;
        UnconfigureAndUninstallFeatureOperation unconfigureAndUninstallFeatureOperation = (UnconfigureAndUninstallFeatureOperation)((OperationFactory)OperationsManager.getOperationFactory()).createUnconfigureAndUninstallFeatureOperation(iConfiguredSite, this.uninstalledFeature);
        try {
            bl = unconfigureAndUninstallFeatureOperation.execute(null, null);
            SiteManager.getLocalSite().save();
            this.featureProgress.setSelection(20);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        this.view.enableRestartCommand = true;
        if (bl) {
            if (9 == this.view.runtimeType && string != null) {
                File file = new File("/Windows/Start Menu/Programs/Other/" + string + ".lnk");
                if (file.exists()) {
                    System.out.println("[eUpdate debug] will delete shortcut [" + file.getAbsolutePath() + "].");
                    file.delete();
                } else {
                    file = new File("/Windows/Start Menu/Other/" + string + ".lnk");
                    System.out.println("[eUpdate debug] will delete shortcut [" + file.getAbsolutePath() + "].");
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
            if (this.uninstalledFeature.getVersionedIdentifier().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                showFinalDialogRunnable = new ShowFinalDialogRunnable();
                showFinalDialogRunnable.setStatus(1);
                Display.getCurrent().timerExec(300, (Runnable)showFinalDialogRunnable);
            } else {
                showFinalDialogRunnable = new ShowFinalDialogRunnable();
                showFinalDialogRunnable.setStatus(0);
                Display.getCurrent().timerExec(300, (Runnable)showFinalDialogRunnable);
            }
        } else {
            showFinalDialogRunnable = new ShowFinalDialogRunnable();
            showFinalDialogRunnable.setStatus(2);
            Display.getCurrent().timerExec(300, (Runnable)showFinalDialogRunnable);
        }
    }

    private String getImpactedShortcut() {
        IPluginEntry[] iPluginEntryArray = this.uninstalledFeature.getPluginEntries();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.ercp.eworkbench", "applications");
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iPluginEntryArray.length) {
            int n2 = 0;
            while (n2 < iExtensionArray.length) {
                if (iPluginEntryArray[n].getVersionedIdentifier().getIdentifier().equalsIgnoreCase(iExtensionArray[n2].getNamespaceIdentifier())) {
                    return iExtensionArray[n2].getConfigurationElements()[0].getAttribute("name");
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    private class ShowFinalDialogRunnable
    implements Runnable {
        public static final int FINISHED_AUTO_RESTART = 0;
        public static final int FINISHED_MANUAL_RESTART = 1;
        public static final int FAILED = 2;
        private int status = 0;
        private int result = 0;

        private ShowFinalDialogRunnable() {
        }

        public void run() {
            if (UninstallScreen.this.isMessageBoxOpening) {
                return;
            }
            UninstallScreen.this.isMessageBoxOpening = true;
            if (this.status == 1) {
                MessageBox messageBox = new MessageBox(UninstallScreen.this.screen.getShell(), 194);
                messageBox.setText(UIMessages.ConfirmRestart);
                messageBox.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])UninstallScreen.this.view.RuntimeName));
                this.result = messageBox.open();
                UninstallScreen.this.isMessageBoxOpening = false;
                if (this.result == 64) {
                    if (9 != UninstallScreen.this.view.runtimeType) {
                        System.getProperties().put("eworkbench.returnCode", new Integer(0));
                        PlatformUI.getWorkbench().close();
                    } else {
                        UninstallScreen.this.view.deletedFeatures.add(UninstallScreen.this.uninstalledFeature.getVersionedIdentifier());
                        UninstallScreen.this.setVisible(false);
                        NormalView normalView = UninstallScreen.this.view;
                        ((Object)((Object)UninstallScreen.this.view)).getClass();
                        ((Object)((Object)UninstallScreen.this.view)).getClass();
                        normalView.showScreen(0, true);
                    }
                }
            } else if (this.status == 0) {
                MessageBox messageBox = new MessageBox(UninstallScreen.this.screen.getShell(), 194);
                messageBox.setText(UIMessages.ConfirmRestart);
                messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])UninstallScreen.this.view.RuntimeName));
                this.result = messageBox.open();
                UninstallScreen.this.isMessageBoxOpening = false;
                if (this.result == 64) {
                    if (9 != UninstallScreen.this.view.runtimeType) {
                        System.getProperties().put("eworkbench.returnCode", new Integer(1));
                        PlatformUI.getWorkbench().close();
                    } else {
                        UninstallScreen.this.view.deletedFeatures.add(UninstallScreen.this.uninstalledFeature.getVersionedIdentifier());
                        UninstallScreen.this.setVisible(false);
                        NormalView normalView = UninstallScreen.this.view;
                        ((Object)((Object)UninstallScreen.this.view)).getClass();
                        ((Object)((Object)UninstallScreen.this.view)).getClass();
                        normalView.showScreen(0, true);
                    }
                } else {
                    UninstallScreen.this.view.deletedFeatures.add(UninstallScreen.this.uninstalledFeature.getVersionedIdentifier());
                    UninstallScreen.this.setVisible(false);
                    NormalView normalView = UninstallScreen.this.view;
                    ((Object)((Object)UninstallScreen.this.view)).getClass();
                    ((Object)((Object)UninstallScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                }
            } else if (this.status == 2) {
                MessageBox messageBox = new MessageBox(UninstallScreen.this.screen.getShell(), 33);
                messageBox.setText(UIMessages.UninstallStatus);
                messageBox.setMessage(UIMessages.UninstallNotCompleted);
                messageBox.open();
                UninstallScreen.this.isMessageBoxOpening = false;
                UninstallScreen.this.setVisible(false);
                NormalView normalView = UninstallScreen.this.view;
                ((Object)((Object)UninstallScreen.this.view)).getClass();
                ((Object)((Object)UninstallScreen.this.view)).getClass();
                normalView.showScreen(0, true);
            }
        }

        public void setStatus(int n) {
            this.status = n;
        }
    }
}

