/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class ConnectionThreadManager {
    private static final String CONNECT_TIMEOUT = "60000";
    private static final String READ_TIMEOUT = "60000";
    private static final int MAX_COUNT = 9;
    private List threads = new ArrayList(9);

    public ConnectionThreadManager() {
        this.setIfNotDefaultProperty("sun.net.client.defaultConnectTimeout", "60000");
        this.setIfNotDefaultProperty("sun.net.client.defaultReadTimeout", "60000");
    }

    private void setIfNotDefaultProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null || string3.equals("-1")) {
            System.setProperty(string, string2);
        }
    }

    public Thread getConnectionThread(StreamRunnable streamRunnable) throws CoreException {
        this.validateExistingThreads();
        Thread thread = new Thread(streamRunnable);
        thread.setDaemon(true);
        this.threads.add(thread);
        return thread;
    }

    private void validateExistingThreads() throws CoreException {
        if (this.threads == null || this.threads.size() == 0) {
            return;
        }
        int n = this.purgeTerminatedThreads();
        if (n > 9) {
            ArrayList<Status> arrayList = new ArrayList<Status>();
            String string = UpdateCore.getPlugin().getBundle().getSymbolicName();
            int n2 = 0;
            while (n2 < this.threads.size()) {
                ConnectionThread connectionThread = (ConnectionThread)this.threads.get(n2);
                String string2 = connectionThread.getRunnable().getURL().toString();
                Status status = new Status(4, string, 0, NLS.bind((String)Messages.ConnectionThreadManager_unresponsiveURL, (Object[])new String[]{string2}), null);
                arrayList.add(status);
                ++n2;
            }
            MultiStatus multiStatus = new MultiStatus(string, 0, arrayList.toArray(new IStatus[arrayList.size()]), Messages.ConnectionThreadManager_tooManyConnections, null);
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private int purgeTerminatedThreads() {
        if (this.threads.size() == 0) {
            return 0;
        }
        int n = 0;
        Object[] objectArray = this.threads.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Thread thread = (Thread)objectArray[n2];
            if (!thread.isAlive()) {
                this.threads.remove(thread);
            } else {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void shutdown() {
        this.threads.clear();
    }

    class ConnectionThread
    extends Thread {
        private StreamRunnable runnable;

        public ConnectionThread(StreamRunnable streamRunnable) {
            super((Runnable)streamRunnable, "update-connection");
            this.runnable = streamRunnable;
        }

        public StreamRunnable getRunnable() {
            return this.runnable;
        }
    }

    public static class StreamRunnable
    implements Runnable {
        private URLConnection urlConnection;
        private IOException ioException;
        private Exception exception;
        private InputStream is;
        private boolean disconnected;

        public StreamRunnable(URLConnection uRLConnection) {
            this.urlConnection = uRLConnection;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public URL getURL() {
            return this.urlConnection.getURL();
        }

        public IOException getIOException() {
            return this.ioException;
        }

        public Exception getException() {
            return this.exception;
        }

        public void disconnect() {
            if (this.urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.urlConnection).disconnect();
            }
            this.disconnected = true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.is = this.urlConnection.getInputStream();
                if (!this.disconnected) return;
                if (this.is == null) return;
                try {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    this.is = null;
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    this.is = null;
                    return;
                }
            }
            catch (IOException iOException) {
                this.ioException = iOException;
                return;
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }
    }
}

