/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PreferenceDialog
extends MultiPageDialog
implements IPreferencePageContainer {
    protected PreferenceManager preferenceManager;
    private Command okCommand = null;
    private Command cancelCommand = null;
    private boolean bDialogClose;
    private static String lastPreferenceId = null;
    private IPreferenceStore preferenceStore;

    public PreferenceDialog(Shell shell) {
        super(shell, 131072);
    }

    public PreferenceDialog(Shell shell, PreferenceManager preferenceManager) {
        super(shell, 131072);
        this.preferenceManager = preferenceManager;
    }

    protected void checkSubclass() {
    }

    protected Control createContents(PreferenceDialog preferenceDialog) {
        Composite composite = null;
        Iterator iterator = this.preferenceManager.getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceNode iPreferenceNode = (IPreferenceNode)iterator.next();
            composite = this.createPage(iPreferenceNode);
        }
        return composite;
    }

    protected Composite createSubPages(IPreferenceNode iPreferenceNode) {
        Composite composite = this.createPage(iPreferenceNode);
        IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
        if (iPreferenceNodeArray != null) {
            int n = 0;
            while (n < iPreferenceNodeArray.length) {
                composite = this.createSubPages(iPreferenceNodeArray[n]);
                ++n;
            }
        }
        return composite;
    }

    protected Composite createPage(IPreferenceNode iPreferenceNode) {
        Composite composite = null;
        PreferencePage preferencePage = (PreferencePage)iPreferenceNode.getPage();
        if (preferencePage == null) {
            iPreferenceNode.createPage();
            preferencePage = (PreferencePage)iPreferenceNode.getPage();
        }
        if (preferencePage != null) {
            preferencePage.setContainer(this);
            Composite composite2 = this.createPage(preferencePage.getTitle(), preferencePage.getImage());
            this.createPageControl(preferencePage, composite2);
            composite = composite2.getParent();
        }
        return composite;
    }

    protected void createPageControl(PreferencePage preferencePage, Composite composite) {
        preferencePage.createControl(composite);
    }

    public void open() {
        this.setText(JFaceResources.getString("PreferenceDialog.title"));
        Control control = this.createContents(this);
        this.createCommands(control);
        this.bDialogClose = true;
        super.open();
        if (this.bDialogClose) {
            this.cancelPressed();
        }
    }

    public void close() {
        if (this.okCommand != null) {
            this.okCommand.dispose();
            this.okCommand = null;
        }
        if (this.cancelCommand != null) {
            this.cancelCommand.dispose();
            this.cancelCommand = null;
        }
        if (!this.bDialogClose) {
            super.close();
        }
    }

    private void createCommands(Control control) {
        if (this.okCommand == null) {
            this.okCommand = new Command(control, 3, 1);
            this.okCommand.setText(JFaceResources.getString("ok"));
            this.okCommand.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PreferenceDialog.this.bDialogClose = false;
                    PreferenceDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    PreferenceDialog.this.bDialogClose = false;
                    PreferenceDialog.this.okPressed();
                }
            });
        }
        if (this.cancelCommand == null) {
            this.cancelCommand = new Command(control, 4, 1);
            this.cancelCommand.setText(JFaceResources.getString("cancel"));
            this.cancelCommand.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PreferenceDialog.this.bDialogClose = false;
                    PreferenceDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    PreferenceDialog.this.bDialogClose = false;
                    PreferenceDialog.this.cancelPressed();
                }
            });
        }
    }

    protected void okPressed() {
        SafeRunnable.run(new SafeRunnable(){
            private boolean errorOccurred;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                boolean bl;
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                this.errorOccurred = false;
                                bl = false;
                                try {
                                    try {
                                        Iterator iterator = PreferenceDialog.this.preferenceManager.getElements(0).iterator();
                                        while (iterator.hasNext()) {
                                            PreferenceNode preferenceNode = (PreferenceNode)iterator.next();
                                            PreferencePage preferencePage = (PreferencePage)preferenceNode.getPage();
                                            if (preferencePage == null) continue;
                                            if (!preferencePage.performOk()) {
                                                bl = true;
                                                Object var5_6 = null;
                                                if (!bl && !this.errorOccurred) {
                                                    PreferenceDialog.this.handleSave();
                                                }
                                                if (!bl) break block16;
                                                break block17;
                                            }
                                            preferenceNode.setPage(null);
                                        }
                                        break block18;
                                    }
                                    catch (Exception exception) {
                                        this.errorOccurred = true;
                                        this.handleException(exception);
                                        break block18;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var5_7 = null;
                                    if (!bl && !this.errorOccurred) {
                                        PreferenceDialog.this.handleSave();
                                    }
                                    if (bl && !PreferenceDialog.this.bDialogClose) {
                                        PreferenceDialog.this.bDialogClose = true;
                                        throw throwable;
                                    }
                                    PreferenceDialog.this.close();
                                    throw throwable;
                                }
                            }
                            if (!PreferenceDialog.this.bDialogClose) break block19;
                        }
                        PreferenceDialog.this.close();
                        return;
                    }
                    PreferenceDialog.this.bDialogClose = true;
                    return;
                }
                Object var5_8 = null;
                if (!bl && !this.errorOccurred) {
                    PreferenceDialog.this.handleSave();
                }
                if (bl && !PreferenceDialog.this.bDialogClose) {
                    PreferenceDialog.this.bDialogClose = true;
                    return;
                }
                PreferenceDialog.this.close();
            }
        });
    }

    protected void cancelPressed() {
        SafeRunnable.run(new SafeRunnable(){

            public void run() {
                Iterator iterator = PreferenceDialog.this.preferenceManager.getElements(0).iterator();
                while (iterator.hasNext()) {
                    PreferenceNode preferenceNode = (PreferenceNode)iterator.next();
                    if (preferenceNode == null) {
                        return;
                    }
                    PreferencePage preferencePage = (PreferencePage)preferenceNode.getPage();
                    if (preferencePage == null) continue;
                    if (!preferencePage.performCancel()) {
                        return;
                    }
                    preferenceNode.setPage(null);
                }
                PreferenceDialog.this.close();
            }
        });
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        Assert.isNotNull(iPreferenceStore);
        this.preferenceStore = iPreferenceStore;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void updateButtons() {
        System.out.println("PreferenceDialog: updateButtons not impl");
    }

    public void updateMessage() {
        System.out.println("PreferenceDialog: updateMessage not impl");
    }

    public void updateTitle() {
        System.out.println("PreferenceDialog: updateTitle not impl");
    }

    protected void handleSave() {
        Iterator iterator = this.preferenceManager.getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceStore iPreferenceStore;
            IPreferenceNode iPreferenceNode = (IPreferenceNode)iterator.next();
            IPreferencePage iPreferencePage = iPreferenceNode.getPage();
            if (!(iPreferencePage instanceof PreferencePage) || (iPreferenceStore = ((PreferencePage)iPreferencePage).getPreferenceStore()) == null || !iPreferenceStore.needsSaving() || !(iPreferenceStore instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)iPreferenceStore).save();
            }
            catch (IOException iOException) {
                MessageBox messageBox = new MessageBox(null, 1);
                messageBox.setText(JFaceResources.getString("PreferenceDialog.saveErrorTitle"));
                messageBox.setMessage(JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{iPreferencePage.getTitle(), iOException.getMessage()}));
                messageBox.open();
            }
        }
    }

    public void setSelectedNode(String string) {
        lastPreferenceId = string;
    }
}

