/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class URIUtil {
    private static final String JAR_SUFFIX = "!/";
    private static final String UNC_PREFIX = "//";
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final boolean decodeResolved = URI.create("foo:/a%20b/").resolve("c").getSchemeSpecificPart().indexOf(37) > 0;

    private URIUtil() {
    }

    public static URI append(URI uRI, String string) {
        try {
            URI uRI2;
            String string2 = uRI.getPath();
            if (string2 == null) {
                return URIUtil.appendOpaque(uRI, string);
            }
            if (string2.endsWith("/")) {
                uRI2 = uRI.resolve(new URI(null, string, null));
                if (decodeResolved) {
                    uRI2 = new URI(URIUtil.toUnencodedString(uRI2));
                }
            } else {
                string2 = String.valueOf(string2) + '/' + string;
                uRI2 = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), string2, uRI.getQuery(), uRI.getFragment());
            }
            uRI2 = uRI2.normalize();
            String string3 = uRI2.getPath();
            if (URIUtil.isFileURI(uRI) && string2 != null && string2.startsWith(UNC_PREFIX) && (string3 == null || !string3.startsWith(UNC_PREFIX))) {
                uRI2 = new URI(uRI2.getScheme(), URIUtil.ensureUNCPath(uRI2.getSchemeSpecificPart()), uRI2.getFragment());
            }
            return uRI2;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private static URI appendOpaque(URI uRI, String string) throws URISyntaxException {
        String string2 = uRI.getSchemeSpecificPart();
        string2 = string2.endsWith("/") ? String.valueOf(string2) + string : String.valueOf(string2) + "/" + string;
        return new URI(uRI.getScheme(), string2, uRI.getFragment());
    }

    private static String ensureUNCPath(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < 4) {
            if (n2 >= n || string.charAt(n2) != '/') {
                stringBuffer.append('/');
            }
            ++n2;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static URI fromString(String string) throws URISyntaxException {
        String string2;
        boolean bl;
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(35);
        boolean bl2 = bl = n2 < 0;
        if (bl) {
            n2 = string.length();
        }
        String string3 = n < 0 ? null : string.substring(0, n);
        String string4 = string.substring(n + 1, n2);
        String string5 = string2 = bl ? null : string.substring(n2 + 1);
        if (string3 != null && string3.equals(SCHEME_FILE)) {
            File file = new File(string4);
            if (file.isAbsolute()) {
                return file.toURI();
            }
            if (File.separatorChar != '/') {
                string4 = string4.replace(File.separatorChar, '/');
            }
            if (!string4.startsWith("/")) {
                string3 = null;
            }
        }
        return new URI(string3, string4, string2);
    }

    public static boolean isFileURI(URI uRI) {
        return SCHEME_FILE.equalsIgnoreCase(uRI.getScheme());
    }

    public static String lastSegment(URI uRI) {
        String string = uRI.getPath();
        if (string == null) {
            return new Path(uRI.getSchemeSpecificPart()).lastSegment();
        }
        return new Path(string).lastSegment();
    }

    public static URI removeFileExtension(URI uRI) {
        String string = URIUtil.lastSegment(uRI);
        if (string == null) {
            return uRI;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return uRI;
        }
        String string2 = uRI.toString();
        n = string2.lastIndexOf(46);
        string2 = string2.substring(0, n);
        return URI.create(string2);
    }

    public static boolean sameURI(URI uRI, URI uRI2) {
        if (uRI == uRI2) {
            return true;
        }
        if (uRI == null || uRI2 == null) {
            return false;
        }
        if (uRI.equals(uRI2)) {
            return true;
        }
        if (URIUtil.sameString(uRI.getScheme(), uRI2.getScheme()) && URIUtil.sameString(uRI.getSchemeSpecificPart(), uRI2.getSchemeSpecificPart()) && URIUtil.sameString(uRI.getFragment(), uRI2.getFragment())) {
            return true;
        }
        if (uRI.isAbsolute() != uRI2.isAbsolute()) {
            return false;
        }
        File file = URIUtil.toFile(uRI);
        return file == null ? false : file.equals(URIUtil.toFile(uRI2));
    }

    private static boolean sameString(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public static File toFile(URI uRI) {
        if (!URIUtil.isFileURI(uRI)) {
            return null;
        }
        return new File(uRI.getSchemeSpecificPart());
    }

    public static URI toJarURI(URI uRI, IPath iPath) {
        try {
            if (iPath == null) {
                iPath = Path.EMPTY;
            }
            return new URI(SCHEME_JAR, String.valueOf(uRI.getScheme()) + ':' + uRI.getSchemeSpecificPart() + JAR_SUFFIX + iPath.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public static URI toURI(URL uRL) throws URISyntaxException {
        if (SCHEME_FILE.equals(uRL.getProtocol())) {
            String string = uRL.toExternalForm().substring(5);
            if (string.indexOf(47) != 0) {
                string = String.valueOf('/') + string;
            } else if (string.startsWith(UNC_PREFIX) && !string.startsWith(UNC_PREFIX, 2)) {
                string = URIUtil.ensureUNCPath(string);
            }
            return new URI(SCHEME_FILE, string, null);
        }
        try {
            return new URI(uRL.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
    }

    public static URL toURL(URI uRI) throws MalformedURLException {
        return new URL(uRI.toString());
    }

    public static String toUnencodedString(URI uRI) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = uRI.getScheme();
        if (string != null) {
            stringBuffer.append(string).append(':');
        }
        stringBuffer.append(uRI.getSchemeSpecificPart());
        String string2 = uRI.getFragment();
        if (string2 != null) {
            stringBuffer.append('#').append(string2);
        }
        return stringBuffer.toString();
    }

    public static URI makeAbsolute(URI uRI, URI uRI2) {
        if (uRI.isAbsolute()) {
            return uRI;
        }
        return URIUtil.append(uRI2, URIUtil.toUnencodedString(uRI));
    }

    public static URI makeRelative(URI uRI, URI uRI2) {
        if (!SCHEME_FILE.equals(uRI.getScheme()) || !SCHEME_FILE.equals(uRI2.getScheme())) {
            return uRI2.relativize(uRI);
        }
        Path path = new Path(uRI.getSchemeSpecificPart());
        Path path2 = new Path(uRI2.getSchemeSpecificPart());
        if (!path2.isAbsolute()) {
            return uRI;
        }
        IPath iPath = path.makeRelativeTo(path2);
        if (iPath == path) {
            return uRI;
        }
        try {
            return new URI(null, iPath.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRI;
        }
    }
}

