/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public class EclipseAppHandle
extends ApplicationHandle
implements ApplicationRunnable,
IApplicationContext {
    private static final int FLAG_STARTING = 1;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STOPPING = 4;
    private static final int FLAG_STOPPED = 8;
    private static final String STARTING = "org.eclipse.equinox.app.starting";
    private static final String STOPPED = "org.eclipse.equinox.app.stopped";
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private volatile ServiceRegistration handleRegistration;
    private int status = 1;
    private final Map arguments;
    private Object application;
    private final Boolean defaultAppInstance;
    private Object result;
    private boolean setResult = false;
    private final boolean[] registrationLock = new boolean[]{true};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    EclipseAppHandle(String string, Map map, EclipseAppDescriptor eclipseAppDescriptor) {
        super(string, eclipseAppDescriptor);
        this.defaultAppInstance = map == null || map.get("eclipse.application.default") == null ? Boolean.FALSE : (Boolean)map.remove("eclipse.application.default");
        this.arguments = map == null ? new HashMap(2) : new HashMap(map);
    }

    public synchronized String getState() {
        switch (this.status) {
            case 1: {
                return STARTING;
            }
            case 2: {
                return "RUNNING";
            }
            case 4: {
                return "STOPPING";
            }
        }
        if (this.getServiceRegistration() == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.application_error_state_stopped, (Object)this.getInstanceId()));
        }
        return STOPPED;
    }

    protected void destroySpecific() {
        this.setAppStatus(4);
        IApplication iApplication = this.getApplication();
        if (iApplication != null) {
            iApplication.stop();
        }
        this.setAppStatus(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration serviceRegistration) {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            this.handleRegistration = serviceRegistration;
            this.registrationLock[0] = serviceRegistration != null;
            this.registrationLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            if (this.handleRegistration == null && this.registrationLock[0]) {
                try {
                    this.registrationLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.handleRegistration;
        }
    }

    ServiceReference getServiceReference() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        try {
            return serviceRegistration.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    Dictionary getServiceProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(6);
        ((Dictionary)hashtable).put("service.pid", this.getInstanceId());
        ((Dictionary)hashtable).put("application.state", this.getState());
        ((Dictionary)hashtable).put("application.descriptor", this.getApplicationDescriptor().getApplicationId());
        ((Dictionary)hashtable).put("eclipse.application.type", ((EclipseAppDescriptor)this.getApplicationDescriptor()).getThreadTypeString());
        ((Dictionary)hashtable).put("application.supports.exitvalue", Boolean.TRUE);
        if (this.defaultAppInstance.booleanValue()) {
            ((Dictionary)hashtable).put("eclipse.application.default", this.defaultAppInstance);
        }
        return hashtable;
    }

    private synchronized void setAppStatus(int n) {
        if (this.status == n) {
            return;
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Cannot set app status to starting");
        }
        if ((n & 4) != 0 && (this.status & 0xC) != 0) {
            return;
        }
        this.status = n;
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.setProperties(this.getServiceProperties());
        if ((this.status & 8) != 0) {
            ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().unlock(this);
            serviceRegistration.unregister();
            this.setServiceRegistration(null);
        }
    }

    public Map getArguments() {
        return this.arguments;
    }

    /*
     * Exception decompiling
     */
    public Object run(Object var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 258->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        try {
            this.destroy();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void applicationRunning() {
        this.setAppStatus(2);
        final ServiceReference[] serviceReferenceArray = this.getStartupMonitors();
        if (serviceReferenceArray == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable throwable) {
            }

            public void run() throws Exception {
                int n = 0;
                while (n < serviceReferenceArray.length) {
                    StartupMonitor startupMonitor = (StartupMonitor)Activator.getContext().getService(serviceReferenceArray[n]);
                    if (startupMonitor != null) {
                        startupMonitor.applicationRunning();
                        Activator.getContext().ungetService(serviceReferenceArray[n]);
                    }
                    ++n;
                }
            }
        });
    }

    private ServiceReference[] getStartupMonitors() {
        ServiceReference[] serviceReferenceArray = null;
        try {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.runnable.StartupMonitor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferenceArray == null || serviceReferenceArray.length == 0) {
            return null;
        }
        Arrays.sort(serviceReferenceArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                ServiceReference serviceReference = (ServiceReference)object;
                ServiceReference serviceReference2 = (ServiceReference)object2;
                Object object3 = serviceReference.getProperty("service.ranking");
                int n2 = object3 instanceof Integer ? (Integer)object3 : 0;
                object3 = serviceReference2.getProperty("service.ranking");
                int n3 = n = object3 instanceof Integer ? (Integer)object3 : 0;
                if (n2 != n) {
                    return n2 > n ? -1 : 1;
                }
                long l = (Long)serviceReference.getProperty("service.id");
                long l2 = (Long)serviceReference2.getProperty("service.id");
                return l2 > l ? -1 : 1;
            }
        });
        return serviceReferenceArray;
    }

    private synchronized IApplication getApplication() {
        if (this.handleRegistration != null && this.application == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (IApplication)(this.application instanceof IApplication ? this.application : null);
    }

    private IConfigurationElement getConfiguration() {
        IExtension iExtension = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAppExtension(this.getApplicationDescriptor().getApplicationId());
        if (iExtension == null) {
            throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)this.getApplicationDescriptor().getApplicationId(), (Object)((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAvailableAppsMsg()));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        if (iConfigurationElementArray.length == 0) {
            throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)this.getApplicationDescriptor().getApplicationId()));
        }
        return iConfigurationElementArray[0];
    }

    public String getBrandingApplication() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getApplication();
    }

    public Bundle getBrandingBundle() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getDefiningBundle();
    }

    public String getBrandingDescription() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getDescription();
    }

    public String getBrandingId() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getId();
    }

    public String getBrandingName() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getName();
    }

    public String getBrandingProperty(String string) {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getProperty(string);
    }

    boolean isDefault() {
        return this.defaultAppInstance;
    }

    public synchronized Object waitForResult(int n) {
        try {
            return this.getExitValue(n);
        }
        catch (ApplicationException applicationException) {
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public synchronized Object getExitValue(long l) throws ApplicationException, InterruptedException {
        if (this.handleRegistration == null && this.application == null) {
            return this.result;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l;
        while (!this.setResult && l3 > 0L) {
            this.wait(l3);
            l3 -= System.currentTimeMillis() - l2;
        }
        if (this.result == null) {
            throw new ApplicationException(6);
        }
        return this.result;
    }
}

