/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExpressionConverter {
    private ElementHandler[] fHandlers;
    private static final ExpressionConverter INSTANCE = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault()});

    public static ExpressionConverter getDefault() {
        return INSTANCE;
    }

    public ExpressionConverter(ElementHandler[] elementHandlerArray) {
        Assert.isNotNull((Object)elementHandlerArray);
        this.fHandlers = elementHandlerArray;
    }

    public Expression perform(IConfigurationElement iConfigurationElement) throws CoreException {
        int n = 0;
        while (n < this.fHandlers.length) {
            ElementHandler elementHandler = this.fHandlers[n];
            Expression expression = elementHandler.create(this, iConfigurationElement);
            if (expression != null) {
                return expression;
            }
            ++n;
        }
        return null;
    }

    public Expression perform(Element element) throws CoreException {
        int n = 0;
        while (n < this.fHandlers.length) {
            ElementHandler elementHandler = this.fHandlers[n];
            Expression expression = elementHandler.create(this, element);
            if (expression != null) {
                return expression;
            }
            ++n;
        }
        return null;
    }

    void processChildren(IConfigurationElement iConfigurationElement, CompositeExpression compositeExpression) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        if (iConfigurationElementArray != null) {
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                Expression expression = this.perform(iConfigurationElementArray[n]);
                if (expression == null) {
                    throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, this.getDebugPath(iConfigurationElementArray[n])), null));
                }
                compositeExpression.add(expression);
                ++n;
            }
        }
    }

    private String getDebugPath(IConfigurationElement iConfigurationElement) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iConfigurationElement.getName());
        Object object = iConfigurationElement.getParent();
        while (object != null) {
            IExtension iExtension;
            if (object instanceof IConfigurationElement) {
                stringBuffer.append(" > ");
                iExtension = (IConfigurationElement)object;
                stringBuffer.append(iExtension.getName());
                String string = iExtension.getAttribute("id");
                if (string != null) {
                    stringBuffer.append(" (id=").append(string).append(')');
                }
                object = iExtension.getParent();
                continue;
            }
            if (object instanceof IExtension) {
                iExtension = (IExtension)object;
                stringBuffer.append(" : ");
                stringBuffer.append(iExtension.getExtensionPointUniqueIdentifier());
                stringBuffer.append(" @ ");
                stringBuffer.append(iExtension.getContributor().getName());
                object = null;
                continue;
            }
            object = null;
        }
        return stringBuffer.toString();
    }

    void processChildren(Element element, CompositeExpression compositeExpression) throws CoreException {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Expression expression = this.perform((Element)node);
                if (expression == null) {
                    throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, node.getNodeName()), null));
                }
                compositeExpression.add(expression);
            }
            node = node.getNextSibling();
        }
    }
}

