/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.Collection;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class CountExpression
extends Expression {
    private static final int GREATER_THAN = 7;
    private static final int LESS_THAN = 6;
    private static final int ANY_NUMBER = 5;
    private static final int EXACT = 4;
    private static final int ONE_OR_MORE = 3;
    private static final int NONE_OR_ONE = 2;
    private static final int NONE = 1;
    private static final int UNKNOWN = 0;
    private static final int HASH_INITIAL;
    private int fMode;
    private int fSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.CountExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public CountExpression(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("value");
        this.initializeSize(string);
    }

    public CountExpression(Element element) {
        String string = element.getAttribute("value");
        this.initializeSize(string.length() > 0 ? string : null);
    }

    public CountExpression(String string) {
        this.initializeSize(string);
    }

    private void initializeSize(String string) {
        if (string == null) {
            string = "*";
        }
        if (string.equals("*")) {
            this.fMode = 5;
        } else if (string.equals("?")) {
            this.fMode = 2;
        } else if (string.equals("!")) {
            this.fMode = 1;
        } else if (string.equals("+")) {
            this.fMode = 3;
        } else if (string.charAt(0) == '-' && string.charAt(string.length() - 1) == ')') {
            try {
                this.fMode = 6;
                this.fSize = Integer.parseInt(string.substring(1, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                this.fMode = 0;
            }
        } else if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == '-') {
            try {
                this.fMode = 7;
                this.fSize = Integer.parseInt(string.substring(1, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                this.fMode = 0;
            }
        } else {
            try {
                this.fSize = Integer.parseInt(string);
                this.fMode = 4;
            }
            catch (NumberFormatException numberFormatException) {
                this.fMode = 0;
            }
        }
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        int n;
        Object object = iEvaluationContext.getDefaultVariable();
        if (object instanceof Collection) {
            n = ((Collection)object).size();
        } else {
            ICountable iCountable = Expressions.getAsICountable(object, this);
            if (iCountable == null) {
                return EvaluationResult.NOT_LOADED;
            }
            n = iCountable.count();
        }
        switch (this.fMode) {
            case 0: {
                return EvaluationResult.FALSE;
            }
            case 1: {
                return EvaluationResult.valueOf(n == 0);
            }
            case 2: {
                return EvaluationResult.valueOf(n == 0 || n == 1);
            }
            case 3: {
                return EvaluationResult.valueOf(n >= 1);
            }
            case 4: {
                return EvaluationResult.valueOf(this.fSize == n);
            }
            case 5: {
                return EvaluationResult.TRUE;
            }
            case 6: {
                return EvaluationResult.valueOf(n < this.fSize);
            }
            case 7: {
                return EvaluationResult.valueOf(n > this.fSize);
            }
        }
        return EvaluationResult.FALSE;
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CountExpression)) {
            return false;
        }
        CountExpression countExpression = (CountExpression)object;
        return this.fMode == countExpression.fMode && this.fSize == countExpression.fSize;
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fMode * 89 + this.fSize;
    }
}

