/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class ListView
extends Scrollable {
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    private int density = 2;
    private Vector items;
    private static Object fLock = new Object();
    private static boolean isInit = false;
    private Color disabledcolor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = fLock;
        synchronized (object) {
            if (!isInit) {
                com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 33, "org/eclipse/ercp/swt/mobile/ListView", "ListViewCallback");
                isInit = true;
            }
        }
    }

    public ListView(Composite parent, int style) {
        this(parent, style, 2);
    }

    public ListView(Composite parent, int style, int density) {
        super(parent, ListView.checkStyle(style));
        if (parent == null) {
            SWT.error(4);
        }
        this.init();
        this.items = new Vector();
        this.setLayoutDensity(density);
    }

    private static int checkStyle(int style) {
        int nStyle = style;
        if ((style & 0x200) != 512) {
            nStyle |= 0x100;
        }
        if ((style & 4) != 4) {
            nStyle |= 2;
        }
        return nStyle;
    }

    public int getLayoutDensity() {
        this.checkWidget();
        return this.density;
    }

    public int getLayout() {
        this.checkWidget();
        if (256 == (this.internal_style & 0x100)) {
            return 256;
        }
        return 512;
    }

    public void add(String item, Image icon) {
        ListViewItem lvItem;
        boolean success;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (success = OS.ListView_Add(this.internal_handle, (lvItem = new ListViewItem(item, icon)).getText(), lvItem.getIconHandle(), this.items.size())) {
            this.items.add(lvItem);
        }
    }

    public void add(String string, Image icon, int index) {
        ListViewItem item;
        boolean success;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (index < 0 || index > this.items.size()) {
            SWT.error(6);
        }
        if (success = OS.ListView_Add(this.internal_handle, (item = new ListViewItem(string, icon)).getText(), item.getIconHandle(), index)) {
            this.items.add(index, item);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size()) {
            return;
        }
        OS.ListView_Select(this.internal_handle, index, false);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        for (int i = start; i < end + 1; ++i) {
            OS.ListView_Select(this.internal_handle, i, false);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (null == indices) {
            SWT.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            OS.ListView_Select(this.internal_handle, indices[i], false);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        OS.ListView_Select(this.internal_handle, -1, false);
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.ListView_GetFocusIndex(this.internal_handle);
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        return ((ListViewItem)this.items.elementAt(index)).getText();
    }

    public Image getIcon(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        return ((ListViewItem)this.items.elementAt(index)).getIcon();
    }

    public Point getIconSize(int style) {
        this.checkWidget();
        if (style != 3 && style != 2 && style != 1) {
            SWT.error(5);
        }
        int width = OS.ListView_GetIconSize(this.internal_handle, style);
        return new Point(width, width);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public String[] getItems() {
        this.checkWidget();
        String[] array = new String[this.items.size()];
        for (int i = 0; i < array.length; ++i) {
            ListViewItem item = (ListViewItem)this.items.elementAt(i);
            array[i] = item.getText();
        }
        return array;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] selectionIndices = this.getSelectionIndices();
        int selectionCount = selectionIndices.length;
        String[] result = new String[this.getSelectionCount()];
        for (int i = 0; i < selectionCount; ++i) {
            ListViewItem item = (ListViewItem)this.items.elementAt(selectionIndices[i]);
            result[i] = item.getText();
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.ListView_GetSelectionCount(this.internal_handle);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return OS.ListView_GetSelectionIndices(this.internal_handle);
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.ListView_GetTopItemIndex(this.internal_handle);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (start < 0 || start >= this.items.size()) {
            return -1;
        }
        for (int i = start; i < this.items.size(); ++i) {
            ListViewItem item = (ListViewItem)this.items.elementAt(i);
            if (!item.getText().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        return OS.ListView_IsSelected(this.internal_handle, index);
    }

    public void remove(int index) {
        boolean success;
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        if (success = OS.ListView_Delete(this.internal_handle, index)) {
            this.items.remove(index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start < 0 || start >= this.items.size()) {
            SWT.error(6);
        }
        if (end < 0 || end >= this.items.size()) {
            SWT.error(6);
        }
        if (start > end) {
            int temp = end;
            end = start;
            start = temp;
        }
        for (int i = end; i >= start; --i) {
            boolean success = OS.ListView_Delete(this.internal_handle, i);
            if (!success) continue;
            this.items.remove(i);
        }
    }

    public void remove(String string) {
        boolean success;
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if ((index = this.indexOf(string)) < 0) {
            SWT.error(5);
        }
        if (success = OS.ListView_Delete(this.internal_handle, index)) {
            this.items.remove(index);
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (null == indices) {
            SWT.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0 && indices[i] < this.items.size()) continue;
            SWT.error(6);
        }
        int[] tmp = new int[indices.length];
        System.arraycopy(indices, 0, tmp, 0, indices.length);
        Arrays.sort(tmp);
        for (int i = tmp.length - 1; i >= 0; --i) {
            boolean success = OS.ListView_Delete(this.internal_handle, tmp[i]);
            if (!success) continue;
            this.items.remove(tmp[i]);
        }
    }

    public void removeAll() {
        this.checkWidget();
        OS.ListView_DeleteAll(this.internal_handle);
        this.items.clear();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        OS.ListView_Select(this.internal_handle, index, true);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start > this.items.size()) {
            return;
        }
        int itemCount = this.items.size();
        if ((this.internal_style & 4) != 0) {
            if (start == end && start >= 0 && end < itemCount) {
                OS.ListView_Select(this.internal_handle, start, true);
            }
        } else {
            start = Math.max(0, start);
            end = Math.min(itemCount - 1, end);
            for (int i = start; i <= end; ++i) {
                OS.ListView_Select(this.internal_handle, i, true);
            }
        }
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        if ((this.internal_style & 4) != 0 && indices.length > 1) {
            for (int i = 1; i < indices.length; ++i) {
                if (indices[i] == indices[0]) continue;
                return;
            }
            if (indices[0] != -1) {
                this.select(indices[0]);
            }
            return;
        }
        int itemCount = this.items.size();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index < 0 || index >= itemCount) continue;
            OS.ListView_Select(this.internal_handle, index, true);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.internal_style & 4) != 0) {
            return;
        }
        OS.ListView_Select(this.internal_handle, -1, true);
    }

    public void setItem(int index, String string, Image icon) {
        ListViewItem newItem;
        boolean success;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        if (success = OS.ListView_Set(this.internal_handle, (newItem = new ListViewItem(string, icon)).getText(), newItem.getIconHandle(), index)) {
            ListViewItem item = (ListViewItem)this.items.elementAt(index);
            item.setText(string);
            item.setIcon(icon);
        }
        newItem = null;
    }

    public void setItems(String[] items, Image[] icons) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        if (items.length != icons.length) {
            SWT.error(6);
        }
        this.removeAll();
        this.items.clear();
        for (int i = 0; i < items.length; ++i) {
            ListViewItem item;
            boolean success;
            if (items[i] == null) {
                SWT.error(4);
            }
            if (!(success = OS.ListView_Add(this.internal_handle, (item = new ListViewItem(items[i], icons[i])).getText(), item.getIconHandle(), i))) continue;
            this.items.add(item);
        }
    }

    public void setLayout(int style) {
        this.checkWidget();
        if (style != 512 && style != 256) {
            SWT.error(5);
        }
        this.internal_style &= 0xFFFFFDFF;
        this.internal_style &= 0xFFFFFEFF;
        this.internal_style |= style;
        if (this.density == 3 || this.density == 2) {
            return;
        }
        int nativeStyle = this.internal_getNativeStyle();
        OS.ListView_SetLayoutDensity(this.internal_handle, nativeStyle, this.density);
    }

    public void setLayoutDensity(int style) {
        int tmpStyle;
        this.checkWidget();
        if (style != 1 && style != 2 && style != 3) {
            SWT.error(5);
        }
        if ((tmpStyle = style) == 2) {
            tmpStyle = 3;
        }
        OS.ListView_SetLayoutDensity(this.internal_handle, this.internal_getNativeStyle(), tmpStyle);
        this.density = style;
    }

    public void setSelection(int index) {
        this.checkWidget();
        OS.ListView_Select(this.internal_handle, -1, false);
        if (index < 0 || index > this.items.size()) {
            return;
        }
        OS.ListView_Select(this.internal_handle, index, true);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        OS.ListView_Select(this.internal_handle, -1, false);
        if (this.isSingleStyle() && end - start != 0) {
            return;
        }
        if (start > this.items.size()) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            OS.ListView_Select(this.internal_handle, i, true);
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        OS.ListView_Select(this.internal_handle, -1, false);
        if (indices == null) {
            SWT.error(4);
        }
        if ((this.internal_style & 4) != 0 && indices.length > 1) {
            for (int i = 1; i < indices.length; ++i) {
                if (indices[i] == indices[0]) continue;
                return;
            }
            if (indices[0] != -1) {
                this.deselectAll();
                this.select(indices[0]);
            }
            return;
        }
        int size = this.items.size();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index < 0 || index > size) continue;
            OS.ListView_Select(this.internal_handle, index, true);
        }
    }

    public void setSelection(String[] items) {
        int i;
        this.checkWidget();
        OS.ListView_Select(this.internal_handle, -1, false);
        if (items == null) {
            SWT.error(4);
        }
        if (this.isSingleStyle() && items.length != 1) {
            return;
        }
        Vector<String> v = new Vector<String>();
        int size = this.items.size();
        for (i = 0; i < size; ++i) {
            ListViewItem item = (ListViewItem)this.items.elementAt(i);
            v.add(item.getText());
        }
        size = items.length;
        for (i = 0; i < size; ++i) {
            int index;
            if (items[i] == null) {
                SWT.error(4);
            }
            if ((index = v.indexOf(items[i])) == -1) continue;
            OS.ListView_Select(this.internal_handle, index, true);
        }
    }

    public void showSelection() {
        this.checkWidget();
        OS.ListView_MakeSelectionVisible(this.internal_handle);
    }

    public void internal_createHandle(int index) {
        this.internal_handle = OS.ListView_New(this.internal_parent.internal_handle, this.internal_getNativeStyle(), this.density);
        if (this.internal_handle == 0) {
            throw new OutOfMemoryError();
        }
    }

    public int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        nativeStyle = (this.internal_style & 0x200) == 512 ? (nativeStyle |= 8) : (nativeStyle |= 0x10);
        if ((this.internal_style & 0x800) == 2048) {
            nativeStyle |= 0x800;
        }
        nativeStyle = (this.internal_style & 4) == 4 ? (nativeStyle |= 0x400000) : (nativeStyle |= 0x800000);
        return nativeStyle;
    }

    private void ListViewCallback(int type) {
        if (type == 0) {
            this.internal_sendEvent(13);
        } else if (type == 1) {
            this.internal_sendEvent(14);
        }
    }

    private boolean isSingleStyle() {
        return (this.internal_style & 4) == 4;
    }

    int getFlags() {
        int bits = 1350565891;
        return bits;
    }

    public boolean allowTraverseByArrowKey(Event event) {
        int size = this.items.size();
        if (size == 0) {
            return true;
        }
        int[] dimension = OS.ListView_GetDimension(this.internal_handle);
        int focus = this.getFocusIndex();
        switch (event.keyCode) {
            case 0x1000003: {
                if (!(this.density == 1 && (this.internal_style & 0x100) == 256 ? focus % dimension[0] == 0 : focus < dimension[1])) break;
                return true;
            }
            case 0x1000004: {
                if (focus == size - 1) {
                    return true;
                }
                if (!(this.density == 1 && (this.internal_style & 0x100) == 256 ? (focus + 1) % dimension[0] == 0 : focus >= size - dimension[1])) break;
                return true;
            }
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            if (this.disabledcolor != null) {
                super.setBackground(null);
            } else {
                this.disabledcolor = super.getBackground();
                super.setBackground(null);
            }
        } else if (this.disabledcolor != null) {
            super.setBackground(this.disabledcolor);
            this.disabledcolor = null;
        }
    }

    public void setBackground(Color color) {
        if (this.isEnabled()) {
            super.setBackground(color);
        } else {
            if (this.disabledcolor != null && !this.disabledcolor.isDisposed()) {
                this.disabledcolor.dispose();
            }
            this.disabledcolor = color;
        }
    }

    public Color getBackground() {
        if (this.isEnabled()) {
            return super.getBackground();
        }
        return this.disabledcolor;
    }

    public void dispose() {
        if (this.disabledcolor != null && !this.disabledcolor.isDisposed()) {
            this.disabledcolor.dispose();
            this.disabledcolor = null;
        }
        super.dispose();
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }

    public class ListViewItem {
        private String text;
        private Image icon;
        private int iconHandle;

        public ListViewItem(String text) {
            this(text, null);
        }

        public ListViewItem(String text, Image icon) {
            this.text = text;
            this.setIcon(icon);
        }

        public int getIconHandle() {
            return this.iconHandle;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setIcon(Image icon) {
            this.iconHandle = icon == null ? 0 : icon.internal_handle;
            this.icon = icon;
        }

        public Image getIcon() {
            return this.icon;
        }
    }
}

