/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.ListBox;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ListBox;
import org.eclipse.ercp.swt.mobile.ListBoxItem;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ListBoxShowCase
extends ShowCase
implements SelectionListener {
    Command commandChangeLayout = null;
    Command commandExit = null;
    ListBox listbox = null;
    ListBoxItem[] listboxitems = null;
    Image lb1details = null;
    Image lb1heading = null;
    Image lb2details = null;
    Image lb2heading = null;
    Image lb3details = null;
    Image lb3heading = null;
    int[] modes;
    int activemode;

    public ListBoxShowCase() {
        int[] nArray = new int[6];
        nArray[0] = 98;
        nArray[1] = 97;
        nArray[2] = 113;
        nArray[3] = 81;
        nArray[4] = 64;
        this.modes = nArray;
        this.activemode = 0;
    }

    public String getName() {
        return Messages.getString("ListBoxShowCase.0");
    }

    public void show() {
        this.createListBoxItems();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.createListbox(this.modes[this.activemode]);
        this.getComposite().layout();
        this.commandChangeLayout = new Command((Control)this.getComposite(), 1, 3);
        this.commandChangeLayout.setText(Messages.getString("ListBoxShowCase.1"));
        this.commandChangeLayout.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.getComposite(), 7, 0);
        this.commandExit.setText(Messages.getString("ListBoxShowCase.2"));
        this.commandExit.setLongLabel(Messages.getString("ListBoxShowCase.3"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.getComposite().setFocus();
    }

    private void quit() {
        this.commandChangeLayout.dispose();
        this.commandExit.dispose();
        this.dispose();
        this.lb1details.dispose();
        this.lb1heading.dispose();
        this.lb2details.dispose();
        this.lb2heading.dispose();
        this.lb3details.dispose();
        this.lb3heading.dispose();
        if (this.listboxitems != null) {
            int n = 0;
            while (n < this.listboxitems.length) {
                if (this.listboxitems[n] != null) {
                    this.listboxitems[n] = null;
                }
                ++n;
            }
            this.listboxitems = null;
        }
        if (this.listbox != null) {
            if (!this.listbox.isDisposed()) {
                this.listbox.dispose();
            }
            this.listbox = null;
        }
    }

    private void createListBoxItems() {
        this.listboxitems = new ListBoxItem[3];
        this.lb1details = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb1details.png"));
        this.lb1heading = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb1heading.png"));
        this.lb2details = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb2details.png"));
        this.lb2heading = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb2heading.png"));
        this.lb3details = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb3details.png"));
        this.lb3heading = new Image((Device)this.getComposite().getDisplay(), this.getClass().getResourceAsStream("/res/lb3heading.png"));
        this.listboxitems[0] = new ListBoxItem(Messages.getString("ListBoxShowCase.10"), this.lb1details, Messages.getString("ListBoxShowCase.11"), this.lb1heading);
        this.listboxitems[1] = new ListBoxItem(Messages.getString("ListBoxShowCase.12"), this.lb2details, Messages.getString("ListBoxShowCase.13"), this.lb2heading);
        this.listboxitems[2] = new ListBoxItem(Messages.getString("ListBoxShowCase.14"), this.lb3details, Messages.getString("ListBoxShowCase.15"), this.lb3heading);
    }

    private void createListbox(int n) {
        if (this.listbox != null) {
            if (!this.listbox.isDisposed()) {
                this.listbox.dispose();
            }
            this.listbox = null;
        }
        this.listbox = new ListBox(this.getComposite(), 4, n);
        this.listbox.setDataModel(this.listboxitems);
        this.listbox.forceFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandChangeLayout) {
            ++this.activemode;
            if (this.activemode == this.modes.length) {
                this.activemode = 0;
            }
            this.createListbox(this.modes[this.activemode]);
            this.getComposite().layout();
        } else if (selectionEvent.widget == this.commandExit) {
            this.quit();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

