/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private static final String POLICY_CONSOLE = "org.eclipse.osgi.framework.console";
    private PlatformAdmin platformAdmin;
    private BundleContext context;
    static /* synthetic */ Class class$0;

    public EclipseCommandProvider(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tenableBundle - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_ENABLE_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tdisableBundle - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DISABLE_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tdisabledBundles - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_LD_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        return stringBuffer.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String string) {
        try {
            long l = Long.parseLong(string);
            return state.getBundle(l);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] bundleDescriptionArray = state.getBundles(string);
            if (bundleDescriptionArray.length > 0) {
                return bundleDescriptionArray[0];
            }
            return null;
        }
    }

    private PlatformAdmin getPlatformAdmin(CommandInterpreter commandInterpreter) {
        if (this.platformAdmin == null) {
            ServiceReference serviceReference;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
                commandInterpreter.print("  ");
                commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
                return null;
            }
            this.platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
        }
        return this.platformAdmin;
    }

    private void ungetPlatformAdmin() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference serviceReference = this.context.getServiceReference(clazz.getName());
        this.context.ungetService(serviceReference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _diag(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            block3: while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                commandInterpreter.println(String.valueOf(bundleDescription.getLocation()) + " [" + bundleDescription.getBundleId() + "]");
                VersionConstraint[] versionConstraintArray = this.platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDescription);
                ResolverError[] resolverErrorArray = this.platformAdmin.getState(false).getResolverErrors(bundleDescription);
                int n = 0;
                while (true) {
                    if (n >= resolverErrorArray.length) {
                        if (versionConstraintArray.length == 0 && resolverErrorArray.length == 0) {
                            commandInterpreter.print("  ");
                            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                        }
                        if (versionConstraintArray.length > 0) {
                            commandInterpreter.print("  ");
                            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DIRECT_CONSTRAINTS);
                        }
                        break;
                    }
                    if ((resolverErrorArray[n].getType() & 0x8007) == 0) {
                        commandInterpreter.print("  ");
                        commandInterpreter.println(resolverErrorArray[n].toString());
                    }
                    ++n;
                }
                n = 0;
                while (true) {
                    if (n >= versionConstraintArray.length) break;
                    commandInterpreter.print("    ");
                    commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray[n]));
                    ++n;
                }
                VersionConstraint[] versionConstraintArray2 = this.platformAdmin.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{bundleDescription});
                boolean bl = false;
                int n2 = 0;
                while (true) {
                    if (n2 >= versionConstraintArray2.length) {
                        string = commandInterpreter.nextArgument();
                        continue block3;
                    }
                    if (versionConstraintArray2[n2].getBundle() != bundleDescription) {
                        if (!bl) {
                            bl = true;
                            commandInterpreter.print("  ");
                            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_LEAF_CONSTRAINTS);
                        }
                        commandInterpreter.print("    ");
                        commandInterpreter.println(String.valueOf(versionConstraintArray2[n2].getBundle().getLocation()) + " [" + versionConstraintArray2[n2].getBundle().getBundleId() + "]");
                        commandInterpreter.print("      ");
                        commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray2[n2]));
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.ungetPlatformAdmin();
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.ungetPlatformAdmin();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _enableBundle(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            block3: while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                DisabledInfo[] disabledInfoArray = state.getDisabledInfos(bundleDescription);
                int n = 0;
                while (true) {
                    if (n >= disabledInfoArray.length) {
                        string = commandInterpreter.nextArgument();
                        continue block3;
                    }
                    this.getPlatformAdmin(commandInterpreter).removeDisabledInfo(disabledInfoArray[n]);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.ungetPlatformAdmin();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.ungetPlatformAdmin();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _disableBundle(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                DisabledInfo disabledInfo = new DisabledInfo(POLICY_CONSOLE, EclipseAdaptorMsg.ECLIPSE_CONSOLE_BUNDLE_DISABLED_MESSAGE, bundleDescription);
                this.getPlatformAdmin(commandInterpreter).addDisabledInfo(disabledInfo);
                string = commandInterpreter.nextArgument();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.ungetPlatformAdmin();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.ungetPlatformAdmin();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _disabledBundles(CommandInterpreter commandInterpreter) throws Exception {
        try {
            State state = this.getPlatformAdmin(commandInterpreter).getState(false);
            BundleDescription[] bundleDescriptionArray = state.getDisabledBundles();
            commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_COUNT_MESSAGE, String.valueOf(bundleDescriptionArray.length)));
            if (bundleDescriptionArray.length > 0) {
                commandInterpreter.println();
            }
            int n = 0;
            block3: while (n < bundleDescriptionArray.length) {
                DisabledInfo[] disabledInfoArray = state.getDisabledInfos(bundleDescriptionArray[n]);
                commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_HEADER, this.formatBundleName(bundleDescriptionArray[n]), String.valueOf(bundleDescriptionArray[n].getBundleId())));
                commandInterpreter.print(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_REASON1, disabledInfoArray[0].getMessage(), disabledInfoArray[0].getPolicyName()));
                int n2 = 1;
                while (true) {
                    if (n2 >= disabledInfoArray.length) {
                        commandInterpreter.println();
                        ++n;
                        continue block3;
                    }
                    commandInterpreter.print(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_DISABLED_BUNDLE_REASON1, disabledInfoArray[n2].getMessage(), String.valueOf(disabledInfoArray[n2].getPolicyName())));
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.ungetPlatformAdmin();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.ungetPlatformAdmin();
            return;
        }
    }

    private String formatBundleName(BundleDescription bundleDescription) {
        String string = bundleDescription.getSymbolicName();
        string = string == null || string.length() == 0 ? bundleDescription.toString() : String.valueOf(string) + "_" + bundleDescription.getVersion();
        return string;
    }
}

