/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.ManifestElement;

public final class HookRegistry {
    public static final String HOOK_CONFIGURATORS_FILE = "hookconfigurators.properties";
    public static final String HOOK_CONFIGURATORS = "hook.configurators";
    public static final String PROP_HOOK_CONFIGURATORS_INCLUDE = "osgi.hook.configurators.include";
    public static final String PROP_HOOK_CONFIGURATORS_EXCLUDE = "osgi.hook.configurators.exclude";
    public static final String PROP_HOOK_CONFIGURATORS = "osgi.hook.configurators";
    private static final String BUILTIN_HOOKS = "builtin.hooks";
    private BaseAdaptor adaptor;
    private boolean readonly = false;
    private AdaptorHook[] adaptorHooks = new AdaptorHook[0];
    private BundleWatcher[] watchers = new BundleWatcher[0];
    private ClassLoadingHook[] classLoadingHooks = new ClassLoadingHook[0];
    private ClassLoadingStatsHook[] classLoadingStatsHooks = new ClassLoadingStatsHook[0];
    private ClassLoaderDelegateHook[] classLoaderDelegateHooks = new ClassLoaderDelegateHook[0];
    private StorageHook[] storageHooks = new StorageHook[0];
    private BundleFileFactoryHook[] bundleFileFactoryHooks = new BundleFileFactoryHook[0];
    private BundleFileWrapperFactoryHook[] bundleFileWrapperFactoryHooks = new BundleFileWrapperFactoryHook[0];

    public HookRegistry(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
    }

    public FrameworkLogEntry[] initialize() {
        ArrayList arrayList = new ArrayList(5);
        ArrayList arrayList2 = new ArrayList(0);
        this.mergeFileHookConfigurators(arrayList, arrayList2);
        this.mergePropertyHookConfigurators(arrayList);
        this.loadConfigurators(arrayList, arrayList2);
        this.readonly = true;
        return arrayList2.toArray(new FrameworkLogEntry[arrayList2.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeFileHookConfigurators(ArrayList arrayList, ArrayList arrayList2) {
        Enumeration<URL> enumeration;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            enumeration = classLoader != null ? classLoader.getResources(HOOK_CONFIGURATORS_FILE) : ClassLoader.getSystemResources(HOOK_CONFIGURATORS_FILE);
        }
        catch (IOException iOException) {
            arrayList2.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "getResources error on hookconfigurators.properties", 0, iOException, null));
            return;
        }
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object var13_15;
            URL uRL = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                try {
                    Properties properties = new Properties();
                    inputStream = uRL.openStream();
                    properties.load(inputStream);
                    String string = properties.getProperty(HOOK_CONFIGURATORS);
                    if (string == null) {
                        var13_15 = null;
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    boolean bl = Boolean.valueOf(properties.getProperty(BUILTIN_HOOKS));
                    String[] stringArray = ManifestElement.getArrayFromList(string, ",");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (!arrayList.contains(stringArray[n2])) {
                            if (bl) {
                                arrayList.add(n++, stringArray[n2]);
                            } else {
                                arrayList.add(stringArray[n2]);
                            }
                        }
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    arrayList2.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "error loading: " + uRL.toExternalForm(), 0, iOException, null));
                }
                var13_15 = null;
                if (inputStream == null) continue;
            }
            catch (Throwable throwable) {
                var13_15 = null;
                if (inputStream == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                inputStream.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
        }
    }

    private void mergePropertyHookConfigurators(ArrayList arrayList) {
        String[] stringArray = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(PROP_HOOK_CONFIGURATORS), ",");
        if (stringArray.length > 0) {
            arrayList.clear();
            int n = 0;
            while (n < stringArray.length) {
                if (!arrayList.contains(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            return;
        }
        String[] stringArray2 = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(PROP_HOOK_CONFIGURATORS_INCLUDE), ",");
        int n = 0;
        while (n < stringArray2.length) {
            if (!arrayList.contains(stringArray2[n])) {
                arrayList.add(stringArray2[n]);
            }
            ++n;
        }
        String[] stringArray3 = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(PROP_HOOK_CONFIGURATORS_EXCLUDE), ",");
        int n2 = 0;
        while (n2 < stringArray3.length) {
            arrayList.remove(stringArray3[n2]);
            ++n2;
        }
    }

    private void loadConfigurators(ArrayList arrayList, ArrayList arrayList2) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz = Class.forName(string);
                HookConfigurator hookConfigurator = (HookConfigurator)clazz.newInstance();
                hookConfigurator.addHooks(this);
            }
            catch (Throwable throwable) {
                arrayList2.add(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "error loading hook: " + string, 0, throwable, null));
            }
        }
    }

    public AdaptorHook[] getAdaptorHooks() {
        return this.adaptorHooks;
    }

    public BundleWatcher[] getWatchers() {
        return this.watchers;
    }

    public ClassLoadingHook[] getClassLoadingHooks() {
        return this.classLoadingHooks;
    }

    public ClassLoadingStatsHook[] getClassLoadingStatsHooks() {
        return this.classLoadingStatsHooks;
    }

    public ClassLoaderDelegateHook[] getClassLoaderDelegateHooks() {
        return this.classLoaderDelegateHooks;
    }

    public StorageHook[] getStorageHooks() {
        return this.storageHooks;
    }

    public BundleFileFactoryHook[] getBundleFileFactoryHooks() {
        return this.bundleFileFactoryHooks;
    }

    public BundleFileWrapperFactoryHook[] getBundleFileWrapperFactoryHooks() {
        return this.bundleFileWrapperFactoryHooks;
    }

    public void addAdaptorHook(AdaptorHook adaptorHook) {
        this.adaptorHooks = (AdaptorHook[])this.add(adaptorHook, this.adaptorHooks, new AdaptorHook[this.adaptorHooks.length + 1]);
    }

    public void addWatcher(BundleWatcher bundleWatcher) {
        this.watchers = (BundleWatcher[])this.add(bundleWatcher, this.watchers, new BundleWatcher[this.watchers.length + 1]);
    }

    public void addClassLoadingHook(ClassLoadingHook classLoadingHook) {
        this.classLoadingHooks = (ClassLoadingHook[])this.add(classLoadingHook, this.classLoadingHooks, new ClassLoadingHook[this.classLoadingHooks.length + 1]);
    }

    public void addClassLoadingStatsHook(ClassLoadingStatsHook classLoadingStatsHook) {
        this.classLoadingStatsHooks = (ClassLoadingStatsHook[])this.add(classLoadingStatsHook, this.classLoadingStatsHooks, new ClassLoadingStatsHook[this.classLoadingStatsHooks.length + 1]);
    }

    public void addClassLoaderDelegateHook(ClassLoaderDelegateHook classLoaderDelegateHook) {
        this.classLoaderDelegateHooks = (ClassLoaderDelegateHook[])this.add(classLoaderDelegateHook, this.classLoaderDelegateHooks, new ClassLoaderDelegateHook[this.classLoaderDelegateHooks.length + 1]);
    }

    public void addStorageHook(StorageHook storageHook) {
        this.storageHooks = (StorageHook[])this.add(storageHook, this.storageHooks, new StorageHook[this.storageHooks.length + 1]);
    }

    public void addBundleFileFactoryHook(BundleFileFactoryHook bundleFileFactoryHook) {
        this.bundleFileFactoryHooks = (BundleFileFactoryHook[])this.add(bundleFileFactoryHook, this.bundleFileFactoryHooks, new BundleFileFactoryHook[this.bundleFileFactoryHooks.length + 1]);
    }

    public void addBundleFileWrapperFactoryHook(BundleFileWrapperFactoryHook bundleFileWrapperFactoryHook) {
        this.bundleFileWrapperFactoryHooks = (BundleFileWrapperFactoryHook[])this.add(bundleFileWrapperFactoryHook, this.bundleFileWrapperFactoryHooks, new BundleFileWrapperFactoryHook[this.bundleFileWrapperFactoryHooks.length + 1]);
    }

    private Object[] add(Object object, Object[] objectArray, Object[] objectArray2) {
        if (this.readonly) {
            throw new IllegalStateException("Cannot add hooks dynamically.");
        }
        if (objectArray.length > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public BaseAdaptor getAdaptor() {
        return this.adaptor;
    }
}

