/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private final int op;
    private static final int EQUAL = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final int PRESENT = 5;
    private static final int SUBSTRING = 6;
    private static final int AND = 7;
    private static final int OR = 8;
    private static final int NOT = 9;
    private final String attr;
    private final Object value;
    private volatile transient String filterString;
    private static final Class[] constructorType;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        constructorType = classArray;
    }

    public static FilterImpl newInstance(String string) throws InvalidSyntaxException {
        return new Parser(string).parse();
    }

    public boolean match(ServiceReference serviceReference) {
        if (serviceReference instanceof ServiceReferenceImpl) {
            return this.match0(((ServiceReferenceImpl)serviceReference).getRegistration().getProperties());
        }
        return this.match0(new ServiceReferenceDictionary(serviceReference));
    }

    public boolean match(Dictionary dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return this.match0(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match0(dictionary);
    }

    public String toString() {
        String string = this.filterString;
        if (string == null) {
            this.filterString = string = this.normalize();
        }
        return string;
    }

    private String normalize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        switch (this.op) {
            case 7: {
                stringBuffer.append('&');
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                int n2 = filterImplArray.length;
                while (n < n2) {
                    stringBuffer.append(filterImplArray[n].normalize());
                    ++n;
                }
                break;
            }
            case 8: {
                stringBuffer.append('|');
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                int n3 = filterImplArray.length;
                while (n < n3) {
                    stringBuffer.append(filterImplArray[n].normalize());
                    ++n;
                }
                break;
            }
            case 9: {
                stringBuffer.append('!');
                FilterImpl filterImpl = (FilterImpl)this.value;
                stringBuffer.append(filterImpl.normalize());
                break;
            }
            case 6: {
                stringBuffer.append(this.attr);
                stringBuffer.append('=');
                String[] stringArray = (String[])this.value;
                int n = 0;
                int n4 = stringArray.length;
                while (n < n4) {
                    String string = stringArray[n];
                    if (string == null) {
                        stringBuffer.append('*');
                    } else {
                        stringBuffer.append(FilterImpl.encodeValue(string));
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                stringBuffer.append(this.attr);
                stringBuffer.append('=');
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 3: {
                stringBuffer.append(this.attr);
                stringBuffer.append(">=");
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 4: {
                stringBuffer.append(this.attr);
                stringBuffer.append("<=");
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 2: {
                stringBuffer.append(this.attr);
                stringBuffer.append("~=");
                stringBuffer.append(FilterImpl.encodeValue(FilterImpl.approxString((String)this.value)));
                break;
            }
            case 5: {
                stringBuffer.append(this.attr);
                stringBuffer.append("=*");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Filter)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    FilterImpl(int n, String string, Object object) {
        this.op = n;
        this.attr = string;
        this.value = object;
    }

    private boolean match0(Dictionary dictionary) {
        switch (this.op) {
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                int n2 = filterImplArray.length;
                while (n < n2) {
                    if (!filterImplArray[n].match0(dictionary)) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                int n3 = filterImplArray.length;
                while (n < n3) {
                    if (filterImplArray[n].match0(dictionary)) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 9: {
                FilterImpl filterImpl = (FilterImpl)this.value;
                return !filterImpl.match0(dictionary);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object var2_5 = dictionary == null ? null : dictionary.get(this.attr);
                return this.compare(this.op, var2_5, this.value);
            }
            case 5: {
                Object var2_6;
                if (Debug.DEBUG_FILTER) {
                    Debug.println("PRESENT(" + this.attr + ")");
                }
                Object v0 = var2_6 = dictionary == null ? null : dictionary.get(this.attr);
                return var2_6 != null;
            }
        }
        return false;
    }

    private static String encodeValue(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    cArray[n3] = 92;
                    ++n3;
                    bl = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl ? new String(cArray, 0, n3) : string;
    }

    private boolean compare(int n, Object object, Object object2) {
        if (object == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("compare(" + object + "," + object2 + ")");
            }
            return false;
        }
        if (object instanceof String) {
            return this.compare_String(n, (String)object, object2);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return this.compare_PrimitiveArray(n, clazz2, object, object2);
            }
            return this.compare_ObjectArray(n, (Object[])object, object2);
        }
        if (object instanceof Collection) {
            return this.compare_Collection(n, (Collection)object, object2);
        }
        if (object instanceof Integer) {
            return this.compare_Integer(n, (Integer)object, object2);
        }
        if (object instanceof Long) {
            return this.compare_Long(n, (Long)object, object2);
        }
        if (object instanceof Byte) {
            return this.compare_Byte(n, (Byte)object, object2);
        }
        if (object instanceof Short) {
            return this.compare_Short(n, (Short)object, object2);
        }
        if (object instanceof Character) {
            return this.compare_Character(n, ((Character)object).charValue(), object2);
        }
        if (object instanceof Float) {
            return this.compare_Float(n, ((Float)object).floatValue(), object2);
        }
        if (object instanceof Double) {
            return this.compare_Double(n, (Double)object, object2);
        }
        if (object instanceof Boolean) {
            return this.compare_Boolean(n, (Boolean)object, object2);
        }
        if (object instanceof Comparable) {
            return this.compare_Comparable(n, (Comparable)object, object2);
        }
        return this.compare_Unknown(n, object, object2);
    }

    private boolean compare_Collection(int n, Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.compare(n, iterator.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean compare_ObjectArray(int n, Object[] objectArray, Object object) {
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            if (this.compare(n, objectArray[n2], object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean compare_PrimitiveArray(int n, Class clazz, Object object, Object object2) {
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            int[] nArray = (int[])object;
            int n2 = 0;
            int n3 = nArray.length;
            while (n2 < n3) {
                if (this.compare_Integer(n, nArray[n2], object2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            long[] lArray = (long[])object;
            int n4 = 0;
            int n5 = lArray.length;
            while (n4 < n5) {
                if (this.compare_Long(n, lArray[n4], object2)) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            byte[] byArray = (byte[])object;
            int n6 = 0;
            int n7 = byArray.length;
            while (n6 < n7) {
                if (this.compare_Byte(n, byArray[n6], object2)) {
                    return true;
                }
                ++n6;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            short[] sArray = (short[])object;
            int n8 = 0;
            int n9 = sArray.length;
            while (n8 < n9) {
                if (this.compare_Short(n, sArray[n8], object2)) {
                    return true;
                }
                ++n8;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            char[] cArray = (char[])object;
            int n10 = 0;
            int n11 = cArray.length;
            while (n10 < n11) {
                if (this.compare_Character(n, cArray[n10], object2)) {
                    return true;
                }
                ++n10;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            float[] fArray = (float[])object;
            int n12 = 0;
            int n13 = fArray.length;
            while (n12 < n13) {
                if (this.compare_Float(n, fArray[n12], object2)) {
                    return true;
                }
                ++n12;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            double[] dArray = (double[])object;
            int n14 = 0;
            int n15 = dArray.length;
            while (n14 < n15) {
                if (this.compare_Double(n, dArray[n14], object2)) {
                    return true;
                }
                ++n14;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            boolean[] blArray = (boolean[])object;
            int n16 = 0;
            int n17 = blArray.length;
            while (n16 < n17) {
                if (this.compare_Boolean(n, blArray[n16], object2)) {
                    return true;
                }
                ++n16;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compare_String(int n, String string, Object object) {
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + string + "," + object + ")");
                }
                String[] stringArray = (String[])object;
                int n2 = 0;
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String string2 = stringArray[n3];
                    if (n3 + 1 < n4) {
                        if (string2 == null) {
                            String string3 = stringArray[n3 + 1];
                            if (string3 != null) {
                                int n5;
                                if (Debug.DEBUG_FILTER) {
                                    Debug.println("indexOf(\"" + string3 + "\"," + n2 + ")");
                                }
                                if ((n5 = string.indexOf(string3, n2)) == -1) {
                                    return false;
                                }
                                n2 = n5 + string3.length();
                                if (n3 + 2 < n4) {
                                    ++n3;
                                }
                            }
                        } else {
                            int n6 = string2.length();
                            if (Debug.DEBUG_FILTER) {
                                Debug.println("regionMatches(" + n2 + ",\"" + string2 + "\")");
                            }
                            if (!string.regionMatches(n2, string2, 0, n6)) return false;
                            n2 += n6;
                        }
                    } else {
                        if (string2 == null) {
                            return true;
                        }
                        if (!Debug.DEBUG_FILTER) return string.endsWith(string2);
                        Debug.println("regionMatches(" + n2 + "," + string2 + ")");
                        return string.endsWith(string2);
                    }
                    ++n3;
                }
                return true;
            }
            case 1: {
                if (!Debug.DEBUG_FILTER) return string.equals(object);
                Debug.println("EQUAL(" + string + "," + object + ")");
                return string.equals(object);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + string + "," + object + ")");
                }
                string = FilterImpl.approxString(string);
                String string4 = FilterImpl.approxString((String)object);
                return string.equalsIgnoreCase(string4);
            }
            case 3: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) >= 0;
                Debug.println("GREATER(" + string + "," + object + ")");
                return string.compareTo((String)object) >= 0;
            }
            case 4: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) <= 0;
                Debug.println("LESS(" + string + "," + object + ")");
                return string.compareTo((String)object) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Integer(int n, int n2, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + n2 + "," + object + ")");
            }
            return false;
        }
        int n3 = Integer.parseInt(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + n2 + "," + object + ")");
                }
                return n2 >= n3;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + n2 + "," + object + ")");
                }
                return n2 <= n3;
            }
        }
        return false;
    }

    private boolean compare_Long(int n, long l, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + l + "," + object + ")");
            }
            return false;
        }
        long l2 = Long.parseLong(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + l + "," + object + ")");
                }
                return l >= l2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + l + "," + object + ")");
                }
                return l <= l2;
            }
        }
        return false;
    }

    private boolean compare_Byte(int n, byte by, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + by + "," + object + ")");
            }
            return false;
        }
        byte by2 = Byte.parseByte(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + by + "," + object + ")");
                }
                return by >= by2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + by + "," + object + ")");
                }
                return by <= by2;
            }
        }
        return false;
    }

    private boolean compare_Short(int n, short s, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + s + "," + object + ")");
            }
            return false;
        }
        short s2 = Short.parseShort(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + s + "," + object + ")");
                }
                return s >= s2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + s + "," + object + ")");
                }
                return s <= s2;
            }
        }
        return false;
    }

    private boolean compare_Character(int n, char c, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + c + "," + object + ")");
            }
            return false;
        }
        char c2 = ((String)object).trim().charAt(0);
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + c + "," + object + ")");
                }
                return c == c2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + c + "," + object + ")");
                }
                return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + c + "," + object + ")");
                }
                return c >= c2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + c + "," + object + ")");
                }
                return c <= c2;
            }
        }
        return false;
    }

    private boolean compare_Boolean(int n, boolean bl, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + bl + "," + object + ")");
            }
            return false;
        }
        boolean bl2 = Boolean.valueOf(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
        }
        return false;
    }

    private boolean compare_Float(int n, float f, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + f + "," + object + ")");
            }
            return false;
        }
        float f2 = Float.parseFloat(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + f + "," + object + ")");
                }
                return Float.compare(f, f2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + f + "," + object + ")");
                }
                return Float.compare(f, f2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + f + "," + object + ")");
                }
                return Float.compare(f, f2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + f + "," + object + ")");
                }
                return Float.compare(f, f2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Double(int n, double d, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + d + "," + object + ")");
            }
            return false;
        }
        double d2 = Double.parseDouble(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + d + "," + object + ")");
                }
                return Double.compare(d, d2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + d + "," + object + ")");
                }
                return Double.compare(d, d2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + d + "," + object + ")");
                }
                return Double.compare(d, d2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + d + "," + object + ")");
                }
                return Double.compare(d, d2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Comparable(int n, Comparable comparable, Object object) {
        Constructor<?> constructor;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + comparable + "," + object + ")");
            }
            return false;
        }
        try {
            constructor = comparable.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object = constructor.newInstance(((String)object).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Unknown(int n, Object object, Object object2) {
        Constructor<?> constructor;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("SUBSTRING(" + object + "," + object2 + ")");
            }
            return false;
        }
        try {
            constructor = object.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object2 = constructor.newInstance(((String)object2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
        }
        return false;
    }

    private static String approxString(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                bl = true;
            } else {
                cArray[n] = c;
                ++n;
            }
            ++n2;
        }
        return bl ? new String(cArray, 0, n) : string;
    }

    public String getRequiredObjectClass() {
        switch (this.op) {
            case 1: {
                if (!this.attr.equalsIgnoreCase("objectClass") || !(this.value instanceof String)) break;
                return (String)this.value;
            }
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                while (n < filterImplArray.length) {
                    String string;
                    if (filterImplArray[n].op == 1 && (string = filterImplArray[n].getRequiredObjectClass()) != null) {
                        return string;
                    }
                    ++n;
                }
                break;
            }
        }
        return null;
    }

    public String[] getAttributes() {
        ArrayList arrayList = new ArrayList();
        this.getAttributesInternal(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void getAttributesInternal(ArrayList arrayList) {
        if (this.value instanceof FilterImpl[]) {
            FilterImpl[] filterImplArray = (FilterImpl[])this.value;
            int n = 0;
            while (n < filterImplArray.length) {
                filterImplArray[n].getAttributesInternal(arrayList);
                ++n;
            }
            return;
        }
        if (this.value instanceof FilterImpl) {
            ((FilterImpl)this.value).getAttributesInternal(arrayList);
            return;
        }
        if (this.attr != null) {
            arrayList.add(this.attr);
        }
    }

    private static class Parser {
        private final String filterstring;
        private final char[] filterChars;
        private int pos;

        Parser(String string) {
            this.filterstring = string;
            this.filterChars = string.toCharArray();
            this.pos = 0;
        }

        FilterImpl parse() throws InvalidSyntaxException {
            FilterImpl filterImpl;
            try {
                filterImpl = this.parse_filter();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
            }
            if (this.pos != this.filterChars.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return filterImpl;
        }

        private FilterImpl parse_filter() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            FilterImpl filterImpl = this.parse_filtercomp();
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
            return filterImpl;
        }

        private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filterChars[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    return this.parse_and();
                }
                case '|': {
                    ++this.pos;
                    return this.parse_or();
                }
                case '!': {
                    ++this.pos;
                    return this.parse_not();
                }
            }
            return this.parse_item();
        }

        private FilterImpl parse_and() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl filterImpl = this.parse_filter();
                arrayList.add(filterImpl);
            }
            return new FilterImpl(7, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
        }

        private FilterImpl parse_or() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl filterImpl = this.parse_filter();
                arrayList.add(filterImpl);
            }
            return new FilterImpl(8, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
        }

        private FilterImpl parse_not() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            FilterImpl filterImpl = this.parse_filter();
            return new FilterImpl(9, null, filterImpl);
        }

        private FilterImpl parse_item() throws InvalidSyntaxException {
            String string = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filterChars[this.pos]) {
                case '~': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(2, string, this.parse_value());
                }
                case '>': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(3, string, this.parse_value());
                }
                case '<': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(4, string, this.parse_value());
                }
                case '=': {
                    if (this.filterChars[this.pos + 1] == '*') {
                        int n = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filterChars[this.pos] == ')') {
                            return new FilterImpl(5, string, null);
                        }
                        this.pos = n;
                    }
                    ++this.pos;
                    Object object = this.parse_substring();
                    if (object instanceof String) {
                        return new FilterImpl(1, string, object);
                    }
                    return new FilterImpl(6, string, object);
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, this.filterstring.substring(this.pos)), this.filterstring);
        }

        private String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int n = this.pos;
            int n2 = this.pos;
            char c = this.filterChars[this.pos];
            while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    n2 = this.pos;
                }
                c = this.filterChars[this.pos];
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return new String(this.filterChars, n, n3);
        }

        private String parse_value() throws InvalidSyntaxException {
            StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
            block5: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        stringBuffer.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (stringBuffer.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return stringBuffer.toString();
        }

        private Object parse_substring() throws InvalidSyntaxException {
            Object e;
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            block6: while (true) {
                n = this.filterChars[this.pos];
                switch (n) {
                    case 41: {
                        if (stringBuffer.length() <= 0) break block6;
                        arrayList.add(stringBuffer.toString());
                        break block6;
                    }
                    case 40: {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case 42: {
                        if (stringBuffer.length() > 0) {
                            arrayList.add(stringBuffer.toString());
                        }
                        stringBuffer.setLength(0);
                        arrayList.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case 92: {
                        ++this.pos;
                        n = this.filterChars[this.pos];
                    }
                    default: {
                        stringBuffer.append((char)n);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((n = arrayList.size()) == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
            }
            if (n == 1 && (e = arrayList.get(0)) != null) {
                return e;
            }
            return arrayList.toArray(new String[n]);
        }

        private void skipWhiteSpace() {
            int n = this.filterChars.length;
            while (this.pos < n && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }

    private static class ServiceReferenceDictionary
    extends Dictionary {
        private final ServiceReference reference;

        ServiceReferenceDictionary(ServiceReference serviceReference) {
            this.reference = serviceReference;
        }

        public Object get(Object object) {
            if (this.reference == null) {
                return null;
            }
            return this.reference.getProperty((String)object);
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Enumeration keys() {
            throw new UnsupportedOperationException();
        }

        public Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SetAccessibleAction
    implements PrivilegedAction {
        private final AccessibleObject accessible;

        SetAccessibleAction(AccessibleObject accessibleObject) {
            this.accessible = accessibleObject;
        }

        public Object run() {
            this.accessible.setAccessible(true);
            return null;
        }
    }
}

