/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.InternalSystemBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

public class Framework
implements EventDispatcher,
EventPublisher,
Runnable {
    private static final String PROP_CONTEXTCLASSLOADER_PARENT = "osgi.contextClassLoaderParent";
    private static final String CONTEXTCLASSLOADER_PARENT_APP = "app";
    private static final String CONTEXTCLASSLOADER_PARENT_EXT = "ext";
    private static final String CONTEXTCLASSLOADER_PARENT_BOOT = "boot";
    private static final String CONTEXTCLASSLOADER_PARENT_FWK = "fwk";
    public static final String PROP_FRAMEWORK_THREAD = "osgi.framework.activeThreadType";
    public static final String THREAD_NORMAL = "normal";
    public static final String PROP_EQUINOX_SECURITY = "eclipse.security";
    public static final String SECURITY_OSGI = "osgi";
    private static String J2SE = "J2SE-";
    private static String JAVASE = "JavaSE-";
    private static String PROFILE_EXT = ".profile";
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    private FrameworkEvent[] shutdownEvent;
    protected BundleRepository bundles;
    protected PackageAdminImpl packageAdmin;
    protected SecurityAdmin securityAdmin;
    protected StartLevelManager startLevelManager;
    private ServiceRegistry serviceRegistry;
    protected Map bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected Map bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected Map frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected static final int BATCHEVENT_BEGIN = -2147483647;
    protected static final int BATCHEVENT_END = Integer.MIN_VALUE;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected InternalSystemBundle systemBundle;
    private String[] bootDelegation;
    private String[] bootDelegationStems;
    private boolean bootDelegateAll = false;
    public final boolean contextBootDelegation = "true".equals(FrameworkProperties.getProperty("osgi.context.bootdelegation", "true"));
    public final boolean compatibiltyBootDelegation = "true".equals(FrameworkProperties.getProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION, "true"));
    ClassLoaderDelegateHook[] delegateHooks;
    private volatile boolean forcedRestart = false;
    protected static AliasMapper aliasMapper = new AliasMapper();
    SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private HashMap adminPermissions = new HashMap();
    private StreamHandlerFactory streamHandlerFactory;
    private org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory;
    private volatile ServiceTracker signedContentFactory;
    private volatile ContextFinder contextFinder;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework$GetDataFileAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    public Framework(FrameworkAdaptor frameworkAdaptor) {
        this.initialize(frameworkAdaptor);
    }

    protected void initialize(FrameworkAdaptor frameworkAdaptor) {
        BundleData[] bundleDataArray;
        if (Profile.STARTUP) {
            Profile.logEnter("Framework.initialze()", null);
        }
        long l = System.currentTimeMillis();
        this.adaptor = frameworkAdaptor;
        this.delegateHooks = frameworkAdaptor instanceof BaseAdaptor ? ((BaseAdaptor)frameworkAdaptor).getHookRegistry().getClassLoaderDelegateHooks() : null;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        this.setNLSFrameworkLog();
        this.initializeContextFinder();
        frameworkAdaptor.initialize(this);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter initialized");
        }
        try {
            frameworkAdaptor.initializeStorage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter storage initialized");
        }
        this.initializeProperties(frameworkAdaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        try {
            this.securityAdmin = new SecurityAdmin(null, this, frameworkAdaptor.getPermissionStorage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done init props & new PermissionAdminImpl");
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new CopyOnWriteIdentityMap();
        this.bundleEventSync = new CopyOnWriteIdentityMap();
        this.frameworkEvent = new CopyOnWriteIdentityMap();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new EventManager");
        }
        this.serviceRegistry = new ServiceRegistry(this);
        this.installLock = new Hashtable(10);
        this.createSystemBundle();
        this.loadVMProfile();
        this.setBootDelegation();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done createSystemBundle");
        }
        this.installURLStreamHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        this.installContentHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new URLStream/Content HandlerFactory");
        }
        this.bundles = new BundleRepository((bundleDataArray = frameworkAdaptor.getInstalledBundles()) == null ? 10 : bundleDataArray.length + 1);
        this.bundles.add(this.systemBundle);
        if (bundleDataArray != null) {
            int n = 0;
            while (n < bundleDataArray.length) {
                try {
                    AbstractBundle abstractBundle = AbstractBundle.createBundle(bundleDataArray[n], this, true);
                    this.bundles.add(abstractBundle);
                }
                catch (BundleException bundleException) {
                    this.publishFrameworkEvent(2, this.systemBundle, bundleException);
                }
                ++n;
            }
        }
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - l));
        }
        if (Profile.STARTUP) {
            Profile.logExit("Framework.initialize()");
        }
    }

    public FrameworkAdaptor getAdaptor() {
        return this.adaptor;
    }

    public ClassLoaderDelegateHook[] getDelegateHooks() {
        return this.delegateHooks;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    private void setNLSFrameworkLog() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.util.NLS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getDeclaredField("frameworkLog");
            field.setAccessible(true);
            field.set(null, this.adaptor.getFrameworkLog());
        }
        catch (Exception exception) {
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, exception.getMessage(), 0, exception, null));
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new InternalSystemBundle(this);
            this.systemBundle.getBundleData().setBundle(this.systemBundle);
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()));
        }
    }

    protected void initializeProperties(Properties properties) {
        String string;
        this.properties = FrameworkProperties.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.properties.getProperty(string) != null) continue;
            this.properties.put(string, properties.getProperty(string));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        string = this.properties.getProperty("org.osgi.framework.processor");
        if (string == null && (string = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", aliasMapper.aliasProcessor(string));
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            string = this.properties.getProperty("os.name");
            try {
                String string2 = (String)aliasMapper.aliasOSName(string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {}
            if (string != null) {
                this.properties.put("org.osgi.framework.os.name", string);
            }
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.version")) == null && (string = this.properties.getProperty("os.version")) != null) {
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(0, n);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string3 = "";
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
                n2 = this.parseVersionInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    n3 = this.parseVersionInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        n4 = this.parseVersionInt(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            string = new Version(n2, n3, n4, string3).toString();
            this.properties.put("org.osgi.framework.os.version", string);
        }
        if ((string = this.properties.getProperty("org.osgi.framework.language")) == null) {
            this.properties.put("org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
        this.properties.put("org.osgi.supports.framework.fragment", "true");
        this.properties.put("org.osgi.supports.framework.requirebundle", "true");
    }

    /*
     * Unable to fully structure code
     */
    private int parseVersionInt(String var1_1) {
        try {
            return Integer.parseInt(var1_1);
        }
        catch (NumberFormatException v0) {
            var2_2 = new StringBuffer(var1_1.length());
            var3_3 = var1_1.toCharArray();
            var4_4 = 0;
            ** while (var4_4 < var3_3.length)
        }
lbl-1000:
        // 1 sources

        {
            if (!Character.isDigit(var3_3[var4_4])) break;
            var2_2.append(var3_3[var4_4]);
            ++var4_4;
            continue;
        }
lbl13:
        // 2 sources

        if (var2_2.length() > 0) {
            return Integer.parseInt(var2_2.toString());
        }
        return 0;
    }

    private void setBootDelegation() {
        String string = this.properties.getProperty("org.osgi.framework.bootdelegation");
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        String[] stringArray = ManifestElement.getArrayFromList(string);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("*")) {
                this.bootDelegateAll = true;
                return;
            }
            if (stringArray[n].endsWith("*")) {
                if (stringArray[n].length() > 2 && stringArray[n].endsWith(".*")) {
                    arrayList2.add(stringArray[n].substring(0, stringArray[n].length() - 1));
                }
            } else {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.bootDelegation = arrayList.toArray(new String[arrayList.size()]);
        }
        if (arrayList2.size() > 0) {
            this.bootDelegationStems = arrayList2.toArray(new String[arrayList2.size()]);
        }
    }

    private void loadVMProfile() {
        String string;
        Properties properties = this.findVMProfile();
        String string2 = this.properties.getProperty("org.osgi.framework.system.packages");
        if (string2 == null && (string2 = properties.getProperty("org.osgi.framework.system.packages")) != null) {
            this.properties.put("org.osgi.framework.system.packages", string2);
        }
        String string3 = this.properties.getProperty("osgi.java.profile.bootdelegation");
        String string4 = properties.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(string3)) {
            if (string4 == null) {
                this.properties.remove("org.osgi.framework.bootdelegation");
            } else {
                this.properties.put("org.osgi.framework.bootdelegation", string4);
            }
        } else if ("none".equals(string3)) {
            this.properties.remove("org.osgi.framework.bootdelegation");
        }
        if (this.properties.getProperty("org.osgi.framework.executionenvironment") == null && (string = properties.getProperty("org.osgi.framework.executionenvironment", properties.getProperty("osgi.java.profile.name"))) != null) {
            this.properties.put("org.osgi.framework.executionenvironment", string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties findVMProfile() {
        String string;
        Properties properties;
        block24: {
            Version version;
            Object object;
            Object object2;
            Object object3;
            properties = new Properties();
            String string2 = this.properties.getProperty("microedition.configuration");
            String string3 = this.properties.getProperty("microedition.profiles");
            string = null;
            String string4 = null;
            Version version2 = null;
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                object3 = ManifestElement.getArrayFromList(string3, " ");
                if (object3 != null && ((String[])object3).length > 0) {
                    string = String.valueOf(string2) + '_' + (String)object3[((Object)object3).length - 1];
                }
            } else {
                object3 = this.properties.getProperty("java.specification.version");
                if (object3 != null) {
                    object2 = new StringTokenizer((String)object3, " _-");
                    object3 = ((StringTokenizer)object2).nextToken();
                    object = this.properties.getProperty("java.specification.name");
                    if ("J2ME Foundation Specification".equals(object)) {
                        string = "CDC-" + (String)object3 + "_Foundation-" + (String)object3;
                    } else {
                        version = new Version("1.6");
                        string4 = J2SE;
                        try {
                            version2 = new Version((String)object3);
                            if (version.compareTo(version2) <= 0) {
                                string4 = JAVASE;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        string = String.valueOf(string4) + (String)object3;
                    }
                }
            }
            object3 = null;
            object2 = FrameworkProperties.getProperty("osgi.java.profile");
            if (object2 != null) {
                try {
                    object3 = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    object3 = this.findInSystemBundle((String)object2);
                }
            }
            if (object3 == null && string != null && (object3 = this.findInSystemBundle((String)(object = String.valueOf(string) + PROFILE_EXT))) == null) {
                object3 = this.getNextBestProfile(string4, version2);
            }
            if (object3 == null) {
                object3 = this.findInSystemBundle("OSGi_Minimum-1.2.profile");
            }
            if (object3 != null) {
                object = null;
                try {
                    try {
                        object = ((URL)object3).openStream();
                        properties.load(new BufferedInputStream((InputStream)object));
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    version = null;
                    if (object == null) throw throwable;
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    version = null;
                    if (object == null) break block24;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)object).close();
            }
        }
        if (properties.getProperty("osgi.java.profile.name") != null) return properties;
        if (string != null) {
            properties.put("osgi.java.profile.name", string.replace('_', '/'));
            return properties;
        }
        properties.put("osgi.java.profile.name", "OSGi/Minimum-1.2");
        return properties;
    }

    private URL getNextBestProfile(String string, Version version) {
        if (version == null || string != J2SE && string != JAVASE) {
            return null;
        }
        URL uRL = this.findNextBestProfile(string, version);
        if (uRL == null && string == JAVASE) {
            uRL = this.findNextBestProfile(J2SE, version);
        }
        return uRL;
    }

    private URL findNextBestProfile(String string, Version version) {
        URL uRL = null;
        int n = version.getMinor();
        while ((uRL = this.findInSystemBundle(String.valueOf(string) + version.getMajor() + "." + n + PROFILE_EXT)) == null && --n > 0) {
        }
        return uRL;
    }

    private URL findInSystemBundle(String string) {
        URL uRL = this.systemBundle.getEntry0(string);
        if (uRL == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        }
        return uRL;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.adaptor == null) {
            return;
        }
        if (this.active) {
            this.shutdown(64);
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List list = this.bundles.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                abstractBundle.close();
                ++n2;
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.clear();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.clear();
            this.bundleEventSync = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.clear();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.secureAction = null;
        this.packageAdmin = null;
        this.adaptor = null;
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
        if (System.getSecurityManager() instanceof EquinoxSecurityManager) {
            System.setSecurityManager(null);
        }
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.shutdownEvent = new FrameworkEvent[1];
        if (THREAD_NORMAL.equals(FrameworkProperties.getProperty(PROP_FRAMEWORK_THREAD))) {
            Thread thread = new Thread((Runnable)this, "Framework Active Thread");
            thread.setDaemon(false);
            thread.start();
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to launch framework");
        }
        this.systemBundle.resume();
        BundleContext bundleContext = this.systemBundle.getBundleContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.signedContentFactory = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.signedContentFactory.open();
    }

    public synchronized void shutdown(int n) {
        if (!this.active) {
            return;
        }
        this.shutdownEvent[0] = new FrameworkEvent(n, this.systemBundle, null);
        this.systemBundle.state = 16;
        this.publishBundleEvent(256, this.systemBundle);
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable throwable) {
            this.publishFrameworkEvent(2, this.systemBundle, throwable);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to shutdown Framework");
        }
        this.systemBundle.suspend();
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException iOException) {
            this.publishFrameworkEvent(2, this.systemBundle, iOException);
        }
        if (this.signedContentFactory != null) {
            this.signedContentFactory.close();
        }
        this.active = false;
        this.notifyAll();
    }

    AbstractBundle createAndVerifyBundle(BundleData bundleData, boolean bl) throws BundleException {
        AbstractBundle abstractBundle;
        if (bundleData.getSymbolicName() != null && (abstractBundle = this.getBundleBySymbolicName(bundleData.getSymbolicName(), bundleData.getVersion())) != null && abstractBundle.getBundleId() != bundleData.getBundleID()) {
            String string = NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{abstractBundle.getSymbolicName(), abstractBundle.getVersion().toString(), abstractBundle.getLocation()});
            throw new DuplicateBundleException(string, abstractBundle);
        }
        return AbstractBundle.createBundle(bundleData, this, bl);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    protected String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    protected Object setProperty(String string, String string2) {
        return this.properties.put(string, string2);
    }

    protected AbstractBundle installBundle(final String string, final InputStream inputStream) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + string + ", " + inputStream);
        }
        final AccessControlContext accessControlContext = AccessController.getContext();
        return this.installWorker(string, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection uRLConnection = inputStream != null ? new BundleSource(inputStream) : Framework.this.adaptor.mapLocationToURLConnection(string);
                return Framework.this.installWorkerPrivileged(string, uRLConnection, accessControlContext);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorker(String string, PrivilegedExceptionAction privilegedExceptionAction) throws BundleException {
        Hashtable hashtable;
        Object object;
        AbstractBundle abstractBundle;
        Object object2 = this.installLock;
        synchronized (object2) {
            while (true) {
                if ((abstractBundle = this.getBundleByLocation(string)) != null) {
                    return abstractBundle;
                }
                Thread thread = Thread.currentThread();
                object = this.installLock.put(string, thread);
                if (object == null) break;
                if (thread.equals(object)) {
                    throw new BundleException(Msg.BUNDLE_INSTALL_RECURSION_EXCEPTION, 7);
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            object2 = (AbstractBundle)AccessController.doPrivileged(privilegedExceptionAction);
            this.publishBundleEvent(1, (Bundle)object2);
            object = object2;
            abstractBundle = null;
            hashtable = this.installLock;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                if (privilegedActionException.getException() instanceof RuntimeException) {
                    throw (RuntimeException)privilegedActionException.getException();
                }
                throw (BundleException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                abstractBundle = null;
                Hashtable hashtable2 = this.installLock;
                synchronized (hashtable2) {
                    this.installLock.remove(string);
                    this.installLock.notifyAll();
                }
                throw throwable;
            }
        }
        synchronized (hashtable) {
            this.installLock.remove(string);
            this.installLock.notifyAll();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractBundle installWorkerPrivileged(String string, URLConnection uRLConnection, AccessControlContext accessControlContext) throws BundleException {
        BundleOperation bundleOperation = this.adaptor.installBundle(string, uRLConnection);
        try {
            BundleData bundleData = bundleOperation.begin();
            final AbstractBundle abstractBundle = this.createAndVerifyBundle(bundleData, true);
            BundleWatcher bundleWatcher = this.adaptor.getBundleWatcher();
            if (bundleWatcher != null) {
                bundleWatcher.watchBundle(abstractBundle, 1);
            }
            try {
                try {
                    abstractBundle.load();
                    if (System.getSecurityManager() != null) {
                        boolean bl;
                        boolean bl2 = bl = (bundleData.getType() & 0x16) != 0;
                        if (bl && !abstractBundle.hasPermission(new AllPermission())) {
                            throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, 6, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                        }
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    Framework.this.checkAdminPermission(abstractBundle, "lifecycle");
                                    if (bl) {
                                        Framework.this.checkAdminPermission(abstractBundle, "extensionLifecycle");
                                    }
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                    }
                    bundleOperation.commit(false);
                }
                catch (Throwable throwable) {
                    BundleRepository bundleRepository = this.bundles;
                    synchronized (bundleRepository) {
                        abstractBundle.unload();
                    }
                    abstractBundle.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                BundleWatcher bundleWatcher2 = this.adaptor.getBundleWatcher();
                if (bundleWatcher2 == null) throw throwable;
                bundleWatcher2.watchBundle(abstractBundle, 2);
                throw throwable;
            }
            {
                Object var9_16 = null;
                BundleWatcher bundleWatcher3 = this.adaptor.getBundleWatcher();
                if (bundleWatcher3 != null) {
                    bundleWatcher3.watchBundle(abstractBundle, 2);
                }
                this.bundles.add(abstractBundle);
                return abstractBundle;
            }
        }
        catch (Throwable throwable) {
            try {
                bundleOperation.undo();
            }
            catch (BundleException bundleException) {
                this.publishFrameworkEvent(2, this.systemBundle, bundleException);
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (!(throwable instanceof BundleException)) throw new BundleException(throwable.getMessage(), throwable);
            throw (BundleException)throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long l) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(l);
        }
    }

    public BundleContextImpl getSystemBundleContext() {
        if (this.systemBundle == null) {
            return null;
        }
        return this.systemBundle.context;
    }

    public PackageAdminImpl getPackageAdmin() {
        return this.packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundleBySymbolicName(String string, Version version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(string, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            int n;
            List list;
            block4: {
                list = this.bundles.getBundles();
                n = list.size();
                if (n != 0) break block4;
                return null;
            }
            AbstractBundle[] abstractBundleArray = new AbstractBundle[n];
            list.toArray(abstractBundleArray);
            return abstractBundleArray;
        }
    }

    protected void resumeBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive()) {
            return;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to resume bundle " + abstractBundle);
            }
            abstractBundle.resume();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
    }

    protected boolean suspendBundle(AbstractBundle abstractBundle, boolean bl) {
        boolean bl2 = false;
        if (!abstractBundle.isActive() || abstractBundle.isFragment()) {
            return bl2;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + abstractBundle);
            }
            abstractBundle.suspend(bl);
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
        if (!abstractBundle.isActive()) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            final String string2 = string;
            return (AbstractBundle)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    List list = Framework.this.bundles.getBundles();
                    int n = list.size();
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                        if (string2.equals(abstractBundle.getLocation())) {
                            return abstractBundle;
                        }
                        ++n2;
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(string);
        }
    }

    protected File getDataFile(AbstractBundle abstractBundle, String string) {
        return (File)AccessController.doPrivileged(new GetDataFileAction(abstractBundle, string));
    }

    protected void checkAdminPermission(Bundle bundle, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getAdminPermission(bundle, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminPermission getAdminPermission(Bundle bundle, String string) {
        HashMap hashMap = this.adminPermissions;
        synchronized (hashMap) {
            AdminPermission adminPermission;
            Long l = new Long(bundle.getBundleId());
            HashMap<String, AdminPermission> hashMap2 = (HashMap<String, AdminPermission>)this.adminPermissions.get(l);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, AdminPermission>();
                this.adminPermissions.put(l, hashMap2);
            }
            if ((adminPermission = (AdminPermission)hashMap2.get(string)) == null) {
                adminPermission = new AdminPermission(bundle, string);
                hashMap2.put(string, adminPermission);
            }
            return adminPermission;
        }
    }

    protected void installSecurityManager() {
        SecurityManager securityManager;
        String string = FrameworkProperties.getProperty(PROP_EQUINOX_SECURITY, FrameworkProperties.getProperty("java.security.manager"));
        if (string != null && (securityManager = System.getSecurityManager()) == null) {
            if (string.length() == 0) {
                securityManager = new SecurityManager();
            } else if (string.equals(SECURITY_OSGI)) {
                securityManager = new EquinoxSecurityManager();
            } else {
                try {
                    Class<?> clazz = Class.forName(string);
                    securityManager = (SecurityManager)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            if (securityManager == null) {
                throw new NoClassDefFoundError(string);
            }
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting SecurityManager to: " + securityManager);
            }
            System.setSecurityManager(securityManager);
            return;
        }
    }

    public void publishFrameworkEvent(int n, Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            if (bundle == null) {
                bundle = this.systemBundle;
            }
            final FrameworkEvent frameworkEvent = new FrameworkEvent(n, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(frameworkEvent);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(frameworkEvent);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent frameworkEvent) {
        Object object;
        if (frameworkEvent.getType() == 2 && (object = this.adaptor.getFrameworkLog()) != null) {
            object.log(frameworkEvent);
        }
        object = new ListenerQueue(this.eventManager);
        ListenerQueue listenerQueue = new ListenerQueue(this.eventManager);
        Map map = this.frameworkEvent;
        synchronized (map) {
            listenerQueue.queueListeners(this.frameworkEvent.entrySet(), (EventDispatcher)this);
            listenerQueue.dispatchEventSynchronous(4, object);
        }
        ((ListenerQueue)object).dispatchEventAsynchronous(4, frameworkEvent);
    }

    public void publishBundleEvent(int n, Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent bundleEvent = new BundleEvent(n, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(bundleEvent);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(bundleEvent);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent bundleEvent) {
        Object object;
        ListenerQueue listenerQueue;
        ListenerQueue listenerQueue2 = null;
        if (this.bundleEventSync != null) {
            listenerQueue2 = new ListenerQueue(this.eventManager);
            listenerQueue = new ListenerQueue(this.eventManager);
            object = this.bundleEventSync;
            synchronized (object) {
                listenerQueue.queueListeners(this.bundleEventSync.entrySet(), (EventDispatcher)this);
                listenerQueue.dispatchEventSynchronous(2, listenerQueue2);
            }
        }
        listenerQueue = null;
        if (this.bundleEvent != null && (bundleEvent.getType() & 0x380) == 0) {
            listenerQueue = new ListenerQueue(this.eventManager);
            object = new ListenerQueue(this.eventManager);
            Map map = this.bundleEvent;
            synchronized (map) {
                ((ListenerQueue)object).queueListeners(this.bundleEvent.entrySet(), (EventDispatcher)this);
                ((ListenerQueue)object).dispatchEventSynchronous(1, listenerQueue);
            }
        }
        if (listenerQueue2 != null) {
            listenerQueue2.dispatchEventSynchronous(2, bundleEvent);
        }
        if (listenerQueue != null) {
            listenerQueue.dispatchEventAsynchronous(1, bundleEvent);
        }
    }

    public ListenerQueue newListenerQueue() {
        return new ListenerQueue(this.eventManager);
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        block8: {
            try {
                BundleContextImpl bundleContextImpl = (BundleContextImpl)object;
                if (!bundleContextImpl.isValid()) break block8;
                ListenerQueue listenerQueue = (ListenerQueue)object3;
                switch (n) {
                    case 1: {
                        listenerQueue.queueListeners(bundleContextImpl.bundleEvent.entrySet(), (EventDispatcher)bundleContextImpl);
                        break;
                    }
                    case 2: {
                        listenerQueue.queueListeners(bundleContextImpl.bundleEventSync.entrySet(), (EventDispatcher)bundleContextImpl);
                        break;
                    }
                    case 4: {
                        listenerQueue.queueListeners(bundleContextImpl.frameworkEvent.entrySet(), (EventDispatcher)bundleContextImpl);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            catch (Throwable throwable) {
                Object object4;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.adaptor.handleRuntimeError(throwable);
                if (n == 4 && ((FrameworkEvent)(object4 = (FrameworkEvent)object3)).getType() == 2) break block8;
                object4 = (BundleContextImpl)object;
                this.publishFrameworkEvent(2, ((BundleContextImpl)object4).bundle, throwable);
            }
        }
    }

    private void initializeContextFinder() {
        Thread thread = Thread.currentThread();
        try {
            ClassLoader classLoader = null;
            String string = FrameworkProperties.getProperty(PROP_CONTEXTCLASSLOADER_PARENT);
            if (CONTEXTCLASSLOADER_PARENT_APP.equals(string)) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_BOOT.equals(string)) {
                classLoader = null;
            } else if (CONTEXTCLASSLOADER_PARENT_FWK.equals(string)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classLoader = clazz.getClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_EXT.equals(string)) {
                ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                if (classLoader2 != null) {
                    classLoader = classLoader2.getParent();
                }
            } else {
                classLoader = thread.getContextClassLoader();
            }
            this.contextFinder = new ContextFinder(classLoader);
            thread.setContextClassLoader(this.contextFinder);
            return;
        }
        catch (Exception exception) {
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, NLS.bind(Msg.CANNOT_SET_CONTEXTFINDER, null), 0, exception, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            return;
        }
    }

    public static Field getField(Class clazz, Class clazz2, boolean bl) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            boolean bl2 = Modifier.isStatic(fieldArray[n].getModifiers());
            if (bl != bl2 && fieldArray[n].getType().equals(clazz2)) {
                fieldArray[n].setAccessible(true);
                return fieldArray[n];
            }
            ++n;
        }
        return null;
    }

    private void installContentHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory = new org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URLConnection.setContentHandlerFactory(contentHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceContentHandlerFactory(contentHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.contentHandlerFactory = contentHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory) throws Exception {
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("java.net.ContentHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getField(clazz2, clazz, false)) == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz4 = clazz3;
        synchronized (clazz3) {
            ContentHandlerFactory contentHandlerFactory2 = (ContentHandlerFactory)field.get(null);
            if (contentHandlerFactory2 != null) {
                try {
                    contentHandlerFactory2.getClass().getMethod("isMultiplexing", null);
                    Class<?> clazz5 = contentHandlerFactory2.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz6 = class$6;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$6 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz6;
                    Method method = clazz5.getMethod("register", classArray);
                    method.invoke((Object)contentHandlerFactory2, contentHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    contentHandlerFactory.setParentFactory(contentHandlerFactory2);
                    contentHandlerFactory2 = contentHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetContentHandlers();
            URLConnection.setContentHandlerFactory(contentHandlerFactory2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        try {
            Field field;
            Class<?> clazz;
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("java.net.URLConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$5) == null) {
                try {
                    clazz = class$5 = Class.forName("java.net.ContentHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((field = Framework.getField(clazz2, clazz, false)) == null) {
                return;
            }
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.net.URLConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz4 = clazz3;
            synchronized (clazz3) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)field.get(null);
                if (contentHandlerFactory == this.contentHandlerFactory) {
                    contentHandlerFactory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Class<?> clazz5 = contentHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz6 = class$6;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$6 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz6;
                    Method method = clazz5.getMethod("unregister", classArray);
                    method.invoke((Object)contentHandlerFactory, this.contentHandlerFactory);
                }
                field.set(null, null);
                Framework.resetContentHandlers();
                if (contentHandlerFactory != null) {
                    URLConnection.setContentHandlerFactory(contentHandlerFactory);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {}
        {
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$7) == null) {
            try {
                clazz = class$7 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getField(clazz2, clazz, false)) != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    private void installURLStreamHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        StreamHandlerFactory streamHandlerFactory = new StreamHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URL.setURLStreamHandlerFactory(streamHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceURLStreamHandlerFactory(streamHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.streamHandlerFactory = streamHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(StreamHandlerFactory streamHandlerFactory) throws Exception {
        Object object;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$9) == null) {
            try {
                clazz = class$9 = Class.forName("java.net.URLStreamHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getField(clazz2, clazz, false)) == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
        synchronized (object2) {
            URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
            if (uRLStreamHandlerFactory != null) {
                try {
                    uRLStreamHandlerFactory.getClass().getMethod("isMultiplexing", null);
                    Class<?> clazz3 = uRLStreamHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz4 = class$6;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$6 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz4;
                    Method method = clazz3.getMethod("register", classArray);
                    method.invoke((Object)uRLStreamHandlerFactory, streamHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    streamHandlerFactory.setParentFactory(uRLStreamHandlerFactory);
                    uRLStreamHandlerFactory = streamHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        try {
            Object object;
            Field field;
            Class<?> clazz;
            Class<?> clazz2 = class$8;
            if (clazz2 == null) {
                try {
                    clazz2 = class$8 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$9) == null) {
                try {
                    clazz = class$9 = Class.forName("java.net.URLStreamHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((field = Framework.getField(clazz2, clazz, false)) == null) {
                return;
            }
            Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
            synchronized (object2) {
                URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
                if (uRLStreamHandlerFactory == this.streamHandlerFactory) {
                    uRLStreamHandlerFactory = (URLStreamHandlerFactory)this.streamHandlerFactory.designateSuccessor();
                } else {
                    Class<?> clazz3 = uRLStreamHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz4 = class$6;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$6 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz4;
                    Method method = clazz3.getMethod("unregister", classArray);
                    method.invoke((Object)uRLStreamHandlerFactory, this.streamHandlerFactory);
                }
                field.set(null, null);
                Framework.resetURLStreamHandlers();
                if (uRLStreamHandlerFactory != null) {
                    URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
                }
            }
        }
        catch (Exception exception) {}
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object object;
        try {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getDeclaredField("streamHandlerLock");
            field.setAccessible(true);
            object = field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = clazz;
        }
        return object;
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$7) == null) {
            try {
                clazz = class$7 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getField(clazz2, clazz, false)) != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Framework framework = this;
        synchronized (framework) {
            while (true) {
                if (!this.active) {
                    return;
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void setForcedRestart(boolean bl) {
        this.forcedRestart = bl;
    }

    boolean isForcedRestart() {
        return this.forcedRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        boolean bl = l == 0L;
        long l2 = System.currentTimeMillis();
        long l3 = l;
        Framework framework = this;
        synchronized (framework) {
            FrameworkEvent[] frameworkEventArray = this.shutdownEvent;
            while (frameworkEventArray != null && frameworkEventArray[0] == null) {
                this.wait(l3);
                if (!bl && (l3 = l2 + l - System.currentTimeMillis()) <= 0L) break;
            }
            if (frameworkEventArray == null || frameworkEventArray[0] == null) {
                return new FrameworkEvent(512, this.systemBundle, null);
            }
            return frameworkEventArray[0];
        }
    }

    public boolean isServiceAssignableTo(Bundle bundle, Bundle bundle2, String string, Class clazz) {
        Object object;
        AbstractBundle abstractBundle = (AbstractBundle)bundle2;
        if (abstractBundle.isFragment()) {
            return false;
        }
        AbstractBundle abstractBundle2 = (AbstractBundle)bundle;
        if (abstractBundle == abstractBundle2) {
            return true;
        }
        String string2 = BundleLoader.getPackageName(string);
        if (string2.startsWith("java.")) {
            return true;
        }
        BundleLoader bundleLoader = abstractBundle2.getBundleLoader();
        if (bundleLoader == null) {
            return false;
        }
        BundleLoader bundleLoader2 = abstractBundle.getBundleLoader();
        if (bundleLoader2 == null) {
            return false;
        }
        PackageSource packageSource = bundleLoader2.getPackageSource(string2);
        if (packageSource == null) {
            return true;
        }
        if (this.isBootDelegationPackage(string2) && ((SystemBundleLoader)(object = (SystemBundleLoader)this.systemBundle.getBundleLoader())).isEEPackage(string2)) {
            return true;
        }
        object = bundleLoader.getPackageSource(string2);
        if (object == null && (object = this.getPackageSource(clazz, string2)) == null) {
            return false;
        }
        return ((PackageSource)object).hasCommonSource(packageSource);
    }

    private PackageSource getPackageSource(Class clazz, String string) {
        if (clazz == null) {
            return null;
        }
        AbstractBundle abstractBundle = (AbstractBundle)this.packageAdmin.getBundle(clazz);
        if (abstractBundle == null) {
            return null;
        }
        BundleLoader bundleLoader = abstractBundle.getBundleLoader();
        if (bundleLoader == null) {
            return null;
        }
        PackageSource packageSource = bundleLoader.getPackageSource(string);
        if (packageSource != null) {
            return packageSource;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            packageSource = this.getPackageSource(classArray[n], string);
            if (packageSource != null) {
                return packageSource;
            }
            ++n;
        }
        return this.getPackageSource(clazz.getSuperclass(), string);
    }

    public boolean isBootDelegationPackage(String string) {
        int n;
        if (this.bootDelegateAll) {
            return true;
        }
        if (this.bootDelegation != null) {
            n = 0;
            while (n < this.bootDelegation.length) {
                if (string.equals(this.bootDelegation[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (this.bootDelegationStems != null) {
            n = 0;
            while (n < this.bootDelegationStems.length) {
                if (string.startsWith(this.bootDelegationStems[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    SignedContentFactory getSignedContentFactory() {
        ServiceTracker serviceTracker = this.signedContentFactory;
        return (SignedContentFactory)(serviceTracker == null ? null : serviceTracker.getService());
    }

    ContextFinder getContextFinder() {
        return this.contextFinder;
    }

    private class DuplicateBundleException
    extends BundleException
    implements StatusException {
        private static final long serialVersionUID = 135669822846323624L;
        private final Bundle duplicate;

        public DuplicateBundleException(String string, Bundle bundle) {
            super(string, 9);
            this.duplicate = bundle;
        }

        public Object getStatus() {
            return this.duplicate;
        }

        public int getStatusCode() {
            return 1;
        }
    }

    static class GetDataFileAction
    implements PrivilegedAction {
        private AbstractBundle bundle;
        private String filename;

        public GetDataFileAction(AbstractBundle abstractBundle, String string) {
            this.bundle = abstractBundle;
            this.filename = string;
        }

        public Object run() {
            return this.bundle.getBundleData().getDataFile(this.filename);
        }
    }
}

