/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class InternalSystemBundle
extends BundleHost
implements org.osgi.framework.launch.Framework {
    ProtectionDomain systemDomain;

    protected InternalSystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
    }

    protected void load() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        return false;
    }

    protected void refresh() {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(string);
    }

    public URL getResource(String string) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    public void start(int n) {
        this.framework.checkAdminPermission(this, "execute");
    }

    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.loadInstalledBundles(this.framework.startLevelManager.getInstalledBundles(this.framework.bundles, false));
        try {
            this.framework.systemBundle.state = 8;
            this.framework.systemBundle.context.start();
            this.framework.publishBundleEvent(128, this.framework.systemBundle);
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle resume exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            throw new RuntimeException(bundleException.getMessage());
        }
    }

    private void loadInstalledBundles(AbstractBundle[] abstractBundleArray) {
        int n = 0;
        while (n < abstractBundleArray.length) {
            AbstractBundle abstractBundle = abstractBundleArray[n];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Trying to load bundle " + abstractBundle);
            }
            abstractBundle.load();
            ++n;
        }
    }

    public void stop() {
        this.framework.checkAdminPermission(this, "execute");
        if ((this.state & 0x28) != 0) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    try {
                        InternalSystemBundle.this.framework.close();
                    }
                    catch (Throwable throwable) {
                        InternalSystemBundle.this.framework.adaptor.handleRuntimeError(throwable);
                    }
                }
            }, "System Bundle Shutdown", this.framework.getContextFinder());
            thread.start();
        }
    }

    public void stop(int n) {
        this.stop();
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    protected void suspend(boolean bl) {
    }

    public void update() {
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.state & 0x28) != 0) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    int n = InternalSystemBundle.this.framework.startLevelManager.getStartLevel();
                    FrameworkProperties.setProperty("osgi.framework.relaunch", "");
                    InternalSystemBundle.this.framework.shutdown(128);
                    InternalSystemBundle.this.framework.launch();
                    if (n > 0) {
                        InternalSystemBundle.this.framework.startLevelManager.doSetStartLevel(n);
                    }
                    FrameworkProperties.clearProperty("osgi.framework.relaunch");
                }
            }, "System Bundle Update", this.framework.getContextFinder());
            thread.start();
        }
    }

    public void update(InputStream inputStream) {
        this.update();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission(this, "lifecycle");
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    public boolean hasPermission(Object object) {
        if (this.systemDomain != null) {
            if (object instanceof Permission) {
                return this.systemDomain.implies((Permission)object);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(AbstractBundle[] abstractBundleArray) {
    }

    public Dictionary getHeaders(String string) {
        return new SystemBundleHeaders(super.getHeaders(string));
    }

    public void init() {
    }

    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        return this.framework.waitForStop(l);
    }

    class SystemBundleHeaders
    extends Dictionary {
        private final Dictionary headers;

        public SystemBundleHeaders(Dictionary dictionary) {
            this.headers = dictionary;
        }

        public Enumeration elements() {
            return this.headers.elements();
        }

        public Object get(Object object) {
            if (!"Export-Package".equals(object)) {
                return this.headers.get(object);
            }
            String string = FrameworkProperties.getProperty("org.osgi.framework.system.packages");
            String string2 = (String)this.headers.get("Export-Package");
            if (string != null) {
                string2 = string2 != null ? String.valueOf(string2) + ", " + string : string;
            }
            return string2;
        }

        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        public Enumeration keys() {
            return this.headers.keys();
        }

        public Object put(Object object, Object object2) {
            return this.headers.put(object, object2);
        }

        public Object remove(Object object) {
            return this.headers.remove(object);
        }

        public int size() {
            return this.headers.size();
        }
    }
}

